/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi;

import com.goide.psi.GoFile;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.CollectionFactory;
import com.plan9.intel.AsmIntelFileType;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public final class GoPsiTreeChangeProcessor
implements PsiTreeChangePreprocessor {
    private final ConcurrentMap<PsiDirectory, SimpleModificationTracker> myPackageTrackers = CollectionFactory.createConcurrentWeakValueMap();

    public void treeChanged(@NotNull PsiTreeChangeEventImpl event) {
        if (event == null) {
            GoPsiTreeChangeProcessor.$$$reportNull$$$0(0);
        }
        this.incPackageTrackers(event);
    }

    private void incPackageTrackers(@NotNull PsiTreeChangeEventImpl event) {
        PsiDirectory directory;
        PsiFile file2;
        if (event == null) {
            GoPsiTreeChangeProcessor.$$$reportNull$$$0(1);
        }
        if ((file2 = GoPsiTreeChangeProcessor.getFile(event)) == null || !file2.isValid()) {
            return;
        }
        if ((file2 instanceof GoFile || file2.getFileType() == AsmIntelFileType.INSTANCE) && (directory = file2.getContainingDirectory()) != null) {
            this.getTracker(directory).incModificationCount();
        }
    }

    @NotNull
    public static ModificationTracker packageModificationTracker(@NotNull PsiElement element) {
        PsiDirectory directory;
        if (element == null) {
            GoPsiTreeChangeProcessor.$$$reportNull$$$0(2);
        }
        if (!Registry.is((String)"go.package.modification.tracker.enabled")) {
            PsiModificationTracker psiModificationTracker = element.getManager().getModificationTracker();
            if (psiModificationTracker == null) {
                GoPsiTreeChangeProcessor.$$$reportNull$$$0(3);
            }
            return psiModificationTracker;
        }
        if (element instanceof PsiDirectory) {
            directory = (PsiDirectory)element;
        } else {
            PsiFile file2 = element.getContainingFile();
            PsiDirectory psiDirectory = directory = file2 != null ? file2.getContainingDirectory() : null;
        }
        if (directory == null) {
            PsiModificationTracker psiModificationTracker = element.getManager().getModificationTracker();
            if (psiModificationTracker == null) {
                GoPsiTreeChangeProcessor.$$$reportNull$$$0(4);
            }
            return psiModificationTracker;
        }
        return ((GoPsiTreeChangeProcessor)PsiTreeChangePreprocessor.EP.findExtensionOrFail(GoPsiTreeChangeProcessor.class, (AreaInstance)element.getProject())).getTracker(directory);
    }

    @NotNull
    private SimpleModificationTracker getTracker(PsiDirectory directory) {
        SimpleModificationTracker simpleModificationTracker = this.myPackageTrackers.computeIfAbsent(directory, dir -> new SimpleModificationTracker());
        if (simpleModificationTracker == null) {
            GoPsiTreeChangeProcessor.$$$reportNull$$$0(5);
        }
        return simpleModificationTracker;
    }

    private static PsiFile getFile(@NotNull PsiTreeChangeEventImpl event) {
        PsiFile file2;
        if (event == null) {
            GoPsiTreeChangeProcessor.$$$reportNull$$$0(6);
        }
        if ((file2 = event.getFile()) == null) {
            return (PsiFile)ObjectUtils.tryCast((Object)event.getChild(), PsiFile.class);
        }
        return file2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/GoPsiTreeChangeProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/GoPsiTreeChangeProcessor";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "packageModificationTracker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "treeChanged";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "incPackageTrackers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "packageModificationTracker";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

