/*
 * Decompiled with CFR 0.152.
 */
package com.goide.psi.impl;

import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoPsiTreeUtil;
import com.goide.psi.GoQualifier;
import com.goide.psi.GoReceiver;
import com.goide.psi.GoResolvable;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSignatureOwner;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeCaseClause;
import com.goide.psi.GoTypeParamDefinition;
import com.goide.psi.GoTypeParameters;
import com.goide.psi.GoTypeParametersOwner;
import com.goide.psi.GoTypeReferenceExpression;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoPackage;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoReferenceBase;
import com.goide.psi.impl.GoScopeProcessor;
import com.goide.psi.impl.GoTypeProcessor;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.ResolveUtil;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.stubs.GoTypeReferenceExpressionStub;
import com.goide.util.GoUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.OrderedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTypeReference
extends GoReferenceBase<GoTypeReferenceExpression> {
    private final boolean myIsC;

    @Contract(value="_ -> new")
    @NotNull
    public static GoTypeReference create(@NotNull GoTypeReferenceExpression o) {
        if (o == null) {
            GoTypeReference.$$$reportNull$$$0(0);
        }
        return new GoTypeReference(o);
    }

    public GoTypeReference(@NotNull GoTypeReferenceExpression o) {
        if (o == null) {
            GoTypeReference.$$$reportNull$$$0(1);
        }
        super(o, null);
        this.myIsC = "C".equals(this.getDesiredName((GoResolvable)this.myElement));
    }

    @NotNull
    public String getCanonicalText() {
        GoTypeReferenceExpressionStub stub = (GoTypeReferenceExpressionStub)((GoTypeReferenceExpression)this.myElement).getStub();
        if (stub != null) {
            String text = stub.getText();
            return text != null ? text : "";
        }
        String string = super.getCanonicalText();
        if (string == null) {
            GoTypeReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public TextRange getRangeInElement() {
        if (((GoTypeReferenceExpression)this.myElement).getStub() != null) {
            TextRange textRange = TextRange.EMPTY_RANGE;
            if (textRange == null) {
                GoTypeReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        TextRange textRange = super.getRangeInElement();
        if (textRange == null) {
            GoTypeReference.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return TextRange.from((int)((GoTypeReferenceExpression)this.myElement).getIdentifier().getStartOffsetInParent(), (int)((GoTypeReferenceExpression)this.myElement).getIdentifier().getTextLength());
    }

    public Object @NotNull [] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            GoTypeReference.$$$reportNull$$$0(5);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @Override
    protected boolean processFileEntities(@NotNull GoFile file2, @NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        if (file2 == null) {
            GoTypeReference.$$$reportNull$$$0(6);
        }
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(7);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(8);
        }
        if (processor2.isCompletion()) {
            return super.processFileTypes(file2, processor2, state, processor2.getDesiredName());
        }
        return super.processFileEntities(file2, processor2, state);
    }

    @Override
    @Nullable
    protected String getDesiredName(@NotNull GoResolvable o) {
        if (o == null) {
            GoTypeReference.$$$reportNull$$$0(9);
        }
        return o instanceof GoTypeReferenceExpression && ((GoTypeReferenceExpression)o).getStub() != null ? o.getText() : super.getDesiredName(o);
    }

    @Override
    @Nullable
    protected PsiElement calculateContext() {
        return GoTypeReference.calculateContextForTypeParameters(super.calculateContext(), this.getDesiredName((GoResolvable)this.myElement), (GoResolvable)this.myElement);
    }

    @Nullable
    private static PsiElement calculateContextForTypeParameters(@Nullable PsiElement defaultContext, @Nullable String desiredName, @NotNull GoResolvable element) {
        if (element == null) {
            GoTypeReference.$$$reportNull$$$0(10);
        }
        if (defaultContext == null) {
            return null;
        }
        if (desiredName != null) {
            GoMethodDeclaration method = (GoMethodDeclaration)GoTypeReference.getReceiverTypeParams((PsiElement)element, (String)desiredName).first;
            if (method != null && GoTypeReference.isPsiOrStubAncestor(defaultContext, method)) {
                return method;
            }
            GoTypeParametersOwner typeParametersOwner = GoTypeReference.findTypeParametersOwner(element);
            if (typeParametersOwner != null && GoTypeReference.isPsiOrStubAncestor(defaultContext, typeParametersOwner)) {
                return typeParametersOwner;
            }
        }
        return defaultContext;
    }

    @NotNull
    private static @NotNull Pair<@Nullable GoMethodDeclaration, @NotNull List<GoTypeParamDefinition>> getReceiverTypeParams(@Nullable PsiElement element, @Nullable String desiredName) {
        GoSdk sdk;
        if (GoPsiImplUtil.isReceiverTypeReferenceExpression(element) && (sdk = GoSdkService.getInstance(element.getProject()).getSdk(GoUtil.module(element))).getMajorVersion().isAtLeast(GoSdkVersion.GO_1_19)) {
            Pair pair = Pair.create(null, Collections.emptyList());
            if (pair == null) {
                GoTypeReference.$$$reportNull$$$0(11);
            }
            return pair;
        }
        GoMethodDeclaration method = (GoMethodDeclaration)PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)element, GoMethodDeclaration.class);
        if (method == null) {
            Pair pair = Pair.create(null, Collections.emptyList());
            if (pair == null) {
                GoTypeReference.$$$reportNull$$$0(12);
            }
            return pair;
        }
        ArrayList<GoTypeParamDefinition> result = new ArrayList<GoTypeParamDefinition>();
        GoType receiverType = GoTypeUtil.unwrapPointerAndParTypes(method.getReceiverType());
        for (GoType type : GoPsiImplUtil.getTypeArguments(receiverType)) {
            GoTypeParamDefinition typeParam = GoPsiUtil.getReceiverTypeParamDefinition(type);
            if (typeParam == null || desiredName != null && !desiredName.equals(typeParam.getName())) continue;
            result.add(typeParam);
        }
        Pair pair = Pair.create((Object)method, result);
        if (pair == null) {
            GoTypeReference.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @Nullable
    private static GoTypeParametersOwner findTypeParametersOwner(@Nullable PsiElement element) {
        PsiElement parent = element;
        while (parent != null && !(parent instanceof GoFile)) {
            GoSignature signature;
            if (parent instanceof GoTypeParametersOwner) {
                if (((GoTypeParametersOwner)parent).getTypeParameters() != null) {
                    return (GoTypeParametersOwner)parent;
                }
            } else if (parent instanceof GoSignatureOwner && (signature = ((GoSignatureOwner)parent).getSignature()) != null && signature.getTypeParameters() != null) {
                return signature;
            }
            parent = PsiTreeUtil.getStubOrPsiParent((PsiElement)parent);
        }
        return null;
    }

    private static boolean isPsiOrStubAncestor(@NotNull PsiElement ancestor, @NotNull PsiElement descendant) {
        if (ancestor == null) {
            GoTypeReference.$$$reportNull$$$0(14);
        }
        if (descendant == null) {
            GoTypeReference.$$$reportNull$$$0(15);
        }
        PsiElement element = descendant;
        while (element != null) {
            if (element.equals((Object)ancestor)) {
                return true;
            }
            if (element instanceof PsiFile) {
                return false;
            }
            element = PsiTreeUtil.getStubOrPsiParent((PsiElement)element);
        }
        return false;
    }

    @Override
    public boolean processResolveVariants(@NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        GoFile substitutionFile;
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(16);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(17);
        }
        if ((substitutionFile = this.getSubstitutionFile(state)) == null) {
            return false;
        }
        GoQualifier qualifier = ((GoTypeReferenceExpression)this.myElement).getQualifier();
        if (qualifier instanceof GoTypeReferenceExpression) {
            return this.processQualifierExpression(substitutionFile, (GoTypeReferenceExpression)qualifier, processor2, state);
        }
        if (qualifier == null) {
            return this.processUnqualifiedResolve(substitutionFile, processor2, state);
        }
        return false;
    }

    private boolean processQualifierExpression(@NotNull GoFile file2, @NotNull GoTypeReferenceExpression qualifier, @NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        PsiElement target;
        if (file2 == null) {
            GoTypeReference.$$$reportNull$$$0(18);
        }
        if (qualifier == null) {
            GoTypeReference.$$$reportNull$$$0(19);
        }
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(20);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(21);
        }
        if ((target = qualifier.resolve(state)) == null || target == qualifier) {
            return false;
        }
        if (!this.processPackage(file2, processor2, state, target)) {
            return false;
        }
        return this.processImport(file2, processor2, state, target);
    }

    private boolean processUnqualifiedResolve(@NotNull GoFile file2, @NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        PsiElement context;
        if (file2 == null) {
            GoTypeReference.$$$reportNull$$$0(22);
        }
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(23);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(24);
        }
        if (!this.processBlock(processor2, state, context = (PsiElement)state.get(SUBSTITUTION_CONTEXT))) {
            return false;
        }
        if (!this.processTypeParameters(processor2, state)) {
            return false;
        }
        if (!this.processFileEntities(file2, processor2, state)) {
            return false;
        }
        GoFile originalFile = (GoFile)((Object)ObjectUtils.tryCast((Object)file2.getOriginalFile(), GoFile.class));
        if (originalFile != null && !this.processPackage(GoPackage.of(originalFile), file2, processor2, state, true)) {
            return false;
        }
        if (this.myIsC && !this.processImports(file2, processor2, state)) {
            return false;
        }
        if (processor2.isCompletion() && PsiTreeUtil.getStubOrPsiParentOfType((PsiElement)this.myElement, GoReceiver.class) != null) {
            return true;
        }
        if (!this.myIsC && !this.processImports(file2, processor2, state)) {
            return false;
        }
        if (!this.processBuiltin(processor2, state, (GoCompositeElement)this.myElement)) {
            return false;
        }
        return this.processDotImports(file2, processor2, state, (GoCompositeElement)this.myElement);
    }

    private boolean processBlock(@NotNull GoScopeProcessor processor2, @NotNull ResolveState state, PsiElement context) {
        StubElement stub;
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(25);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(26);
        }
        StubElement stubElement = stub = context instanceof StubBasedPsiElement ? ((StubBasedPsiElement)context).getStub() : ((GoTypeReferenceExpression)this.myElement).getStub();
        if (stub == null) {
            PsiElement startElement = this.startElementForBlockWalkUp(context);
            if (startElement == null) {
                return true;
            }
            GoDelegateTypeProcessor delegate = new GoDelegateTypeProcessor(((GoTypeReferenceExpression)this.myElement).getIdentifier(), startElement, processor2.isCompletion());
            ResolveUtil.treeWalkUp(startElement, delegate);
            return GoPsiImplUtil.processNamedElements(processor2, state, delegate.getVariants());
        }
        return true;
    }

    private boolean processTypeParameters(@NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(27);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(28);
        }
        return GoTypeReference.processTypeParameters(this.getDesiredName((GoResolvable)this.myElement), (GoResolvable)this.myElement, processor2, state);
    }

    static boolean processTypeParameters(@Nullable String desiredName, @NotNull GoResolvable element, @NotNull GoScopeProcessor processor2, @NotNull ResolveState state) {
        if (element == null) {
            GoTypeReference.$$$reportNull$$$0(29);
        }
        if (processor2 == null) {
            GoTypeReference.$$$reportNull$$$0(30);
        }
        if (state == null) {
            GoTypeReference.$$$reportNull$$$0(31);
        }
        PsiElement context = (PsiElement)ObjectUtils.notNull((Object)((PsiElement)state.get(SUBSTITUTION_CONTEXT)), (Object)element);
        List typeParams = (List)GoTypeReference.getReceiverTypeParams((PsiElement)context, (String)(processor2.isCompletion() ? null : desiredName)).second;
        if (!GoPsiImplUtil.processNamedElements(processor2, state, typeParams)) {
            return false;
        }
        GoTypeParametersOwner typeParametersOwner = GoTypeReference.findTypeParametersOwner(context);
        GoTypeParameters typeParameters = (GoTypeParameters)ObjectUtils.doIfNotNull((Object)typeParametersOwner, GoTypeParametersOwner::getTypeParameters);
        if (typeParameters == null) {
            return true;
        }
        List<GoTypeParamDefinition> definitions = GoPsiImplUtil.getTypeParamDefinitions(typeParameters);
        return GoPsiImplUtil.processNamedElements(processor2, state, definitions);
    }

    @Nullable
    private PsiElement startElementForBlockWalkUp(@Nullable PsiElement context) {
        PsiElement psiElement;
        PsiElement colon;
        PsiElement startElement = (PsiElement)ObjectUtils.chooseNotNull((Object)context, (Object)this.myElement);
        PsiElement receiverOrSignature = GoPsiTreeUtil.findTopmostParent(startElement, true, (Condition<? super PsiElement>)Conditions.instanceOf((Class[])new Class[]{GoReceiver.class, GoSignature.class}), new Class[0]);
        if (receiverOrSignature != null) {
            return receiverOrSignature.getParent();
        }
        GoTypeCaseClause typeCaseClause = (GoTypeCaseClause)PsiTreeUtil.getParentOfType((PsiElement)startElement, GoTypeCaseClause.class);
        if (typeCaseClause != null && ((colon = typeCaseClause.getColon()) == null || startElement.getTextRange().getStartOffset() < colon.getTextRange().getStartOffset())) {
            return typeCaseClause.getParent();
        }
        if (startElement instanceof PsiWhiteSpace && (psiElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)startElement)) instanceof GoTypeCaseClause) {
            GoTypeCaseClause previousTypeCaseClause = (GoTypeCaseClause)psiElement;
            return PsiTreeUtil.lastChild((PsiElement)previousTypeCaseClause);
        }
        return startElement;
    }

    @Override
    public boolean allowed(@NotNull GoTypeSpec definition) {
        if (definition == null) {
            GoTypeReference.$$$reportNull$$$0(32);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/psi/impl/GoTypeReference";
                break;
            }
            case 6: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 16: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 8: 
            case 17: 
            case 21: 
            case 24: 
            case 26: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descendant";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/psi/impl/GoTypeReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverTypeParams";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFileEntities";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDesiredName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculateContextForTypeParameters";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPsiOrStubAncestor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processResolveVariants";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierExpression";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "processUnqualifiedResolve";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processBlock";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processTypeParameters";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "allowed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private static final class GoDelegateTypeProcessor
    extends GoTypeProcessor {
        @NotNull
        private final OrderedSet<GoNamedElement> myVariants;

        private GoDelegateTypeProcessor(@NotNull PsiElement requestedNameElement, @NotNull PsiElement origin, boolean isCompletion) {
            if (requestedNameElement == null) {
                GoDelegateTypeProcessor.$$$reportNull$$$0(0);
            }
            if (origin == null) {
                GoDelegateTypeProcessor.$$$reportNull$$$0(1);
            }
            super(requestedNameElement, origin, isCompletion);
            this.myVariants = new OrderedSet();
        }

        @Override
        protected boolean processInner(@NotNull GoNamedElement o, @NotNull ResolveState state) {
            if (o == null) {
                GoDelegateTypeProcessor.$$$reportNull$$$0(2);
            }
            if (state == null) {
                GoDelegateTypeProcessor.$$$reportNull$$$0(3);
            }
            return !this.myVariants.add((Object)o) || super.processInner(o, state);
        }

        @NotNull
        List<GoNamedElement> getVariants() {
            OrderedSet<GoNamedElement> orderedSet = this.myVariants;
            if (orderedSet == null) {
                GoDelegateTypeProcessor.$$$reportNull$$$0(4);
            }
            return orderedSet;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "requestedNameElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "origin";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/psi/impl/GoTypeReference$GoDelegateTypeProcessor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/psi/impl/GoTypeReference$GoDelegateTypeProcessor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processInner";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }
}

