/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoCompositeLit;
import com.goide.psi.GoElement;
import com.goide.psi.GoLiteralValue;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoStructType;
import com.goide.psi.GoType;
import com.goide.psi.GoValue;
import com.goide.psi.impl.GoElementFactory;
import com.goide.util.GoZeroValue;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class GoAddKeysToStructLiteralValueQuickFix
implements LocalQuickFix {
    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.add.keys.to.struct.literal.value.name", (Object[])new Object[0]);
        if (string == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoAddKeysToStructLiteralValueQuickFix.getQuickFixName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        GoLiteralValue literalValue;
        PsiElement element;
        if (project == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptor == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(2);
        }
        if ((element = descriptor.getPsiElement()) instanceof GoLiteralValue) {
            literalValue = (GoLiteralValue)element;
        } else if (element instanceof GoCompositeLit) {
            literalValue = ((GoCompositeLit)element).getLiteralValue();
        } else {
            return;
        }
        if (literalValue == null) {
            return;
        }
        GoStructType structType = GoInspectionUtil.findStructTypeForLiteralValue(literalValue);
        if (structType == null) {
            return;
        }
        List<GoNamedElement> fields = structType.getFieldDefinitions();
        List<GoElement> elements2 = literalValue.getElementList();
        GoAddKeysToStructLiteralValueQuickFix.processElements(elements2, fields, GoAddKeysToStructLiteralValueQuickFix::addKeyOrDeleteElement);
    }

    public static boolean processElements(@NotNull List<GoElement> elements2, @NotNull List<GoNamedElement> fields, @NotNull BiConsumer<? super GoElement, ? super GoNamedElement> consumer) {
        if (elements2 == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(3);
        }
        if (fields == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(5);
        }
        if (fields.size() < elements2.size()) {
            return false;
        }
        Iterator<GoNamedElement> iterator = fields.iterator();
        for (GoElement element : elements2) {
            assert (iterator.hasNext());
            GoNamedElement field = iterator.next();
            consumer.accept(element, field);
        }
        return true;
    }

    private static void addKeyOrDeleteElement(@NotNull GoElement element, @NotNull GoNamedElement field) {
        GoValue elementValue;
        if (element == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(6);
        }
        if (field == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(7);
        }
        if ((elementValue = element.getValue()) == null) {
            return;
        }
        GoType fieldType = field.getGoType(null);
        if (GoZeroValue.isZeroValue(elementValue.getExpression(), fieldType)) {
            GoElement first;
            ASTNode prevLeaf = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)element.getNode());
            GoElement goElement = first = prevLeaf != null && prevLeaf.getElementType() == GoTypes.COMMA ? prevLeaf.getPsi() : element;
            if (prevLeaf != null && prevLeaf.getElementType() == GoTypes.LBRACE) {
                PsiElement last = GoAddKeysToStructLiteralValueQuickFix.findLast(element);
                element.getParent().deleteChildRange((PsiElement)first, last);
                return;
            }
            element.getParent().deleteChildRange((PsiElement)first, (PsiElement)element);
            return;
        }
        String name = field.getName();
        if (name == null) {
            return;
        }
        Project project = element.getProject();
        element.addBefore(GoElementFactory.createKey(project, name), elementValue);
        element.getNode().addLeaf(GoTypes.COLON, (CharSequence)":", elementValue.getNode());
    }

    @NotNull
    private static PsiElement findLast(@NotNull GoElement element) {
        ASTNode next;
        ASTNode comma;
        ASTNode lastNode;
        if (element == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(8);
        }
        if ((lastNode = FormatterUtil.getNext((ASTNode)(comma = (next = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)element.getNode())) != null && next.getElementType() == GoTypes.COMMA ? next : null), (IElementType[])new IElementType[0])) != null && lastNode.getPsi() instanceof PsiWhiteSpace) {
            PsiElement psiElement = lastNode.getPsi();
            if (psiElement == null) {
                GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(9);
            }
            return psiElement;
        }
        if (comma != null) {
            PsiElement psiElement = comma.getPsi();
            if (psiElement == null) {
                GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(10);
            }
            return psiElement;
        }
        GoElement goElement = element;
        if (goElement == null) {
            GoAddKeysToStructLiteralValueQuickFix.$$$reportNull$$$0(11);
        }
        return goElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoAddKeysToStructLiteralValueQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fields";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoAddKeysToStructLiteralValueQuickFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "findLast";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addKeyOrDeleteElement";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

