/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoFile;
import com.goide.psi.GoImportSpec;
import com.goide.psi.GoType;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.quickfix.GoReplaceExpressionQuickFix;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoIntToStringConversionCallQuickFix
extends GoReplaceExpressionQuickFix {
    private static final String DECIMAL_SYSTEM_BASE = "10";

    public GoIntToStringConversionCallQuickFix(@NotNull GoFile file2, @NotNull GoType callExpressionType, @NotNull String callExpressionText, @NotNull GoType argumentType, @NotNull GoType argumentUnderlyingType, @NotNull String argumentText) {
        if (file2 == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(0);
        }
        if (callExpressionType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(1);
        }
        if (callExpressionText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(2);
        }
        if (argumentType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(3);
        }
        if (argumentUnderlyingType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(4);
        }
        if (argumentText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(5);
        }
        super(GoIntToStringConversionCallQuickFix.buildItoaCallText(callExpressionType, callExpressionText, file2, argumentType, argumentUnderlyingType, argumentText));
    }

    @Override
    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        PsiElement element;
        PsiFile file2;
        if (project == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(6);
        }
        if (descriptor == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(7);
        }
        PsiFile psiFile = file2 = (element = descriptor.getPsiElement()) != null ? element.getContainingFile() : null;
        if (file2 instanceof GoFile && file2.isPhysical()) {
            GoRefactoringUtil.importPackageIfNeeded((GoFile)file2, "strconv");
        }
        super.applyFix(project, descriptor);
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.fix.convert.int.to.string.using.conversion.call", (Object[])new Object[]{this.getNewReplaceValue()});
        if (string == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @Nullable
    protected PsiElement getElementToReplace(@Nullable PsiElement sourceElement) {
        GoType type;
        GoCallExpr parentGoCallExpr = (GoCallExpr)PsiTreeUtil.getParentOfType((PsiElement)sourceElement, GoCallExpr.class);
        if (parentGoCallExpr != null && GoTypeUtil.isString(type = parentGoCallExpr.getExpression().getGoUnderlyingType(null), null)) {
            return parentGoCallExpr;
        }
        return super.getElementToReplace(sourceElement);
    }

    @NotNull
    private static String buildItoaCallText(@NotNull GoType callExpressionType, @NotNull String callExpressionText, @NotNull GoFile file2, @NotNull GoType argumentType, @NotNull GoType argumentUnderlyingType, @NotNull String argumentText) {
        if (callExpressionType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(9);
        }
        if (callExpressionText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(10);
        }
        if (file2 == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(11);
        }
        if (argumentType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(12);
        }
        if (argumentUnderlyingType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(13);
        }
        if (argumentText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(14);
        }
        GoImportSpec strconvImportSpec = (GoImportSpec)ContainerUtil.find(file2.getImports(), importSpec -> "strconv".equals(importSpec.getPath()));
        String qualifier = "strconv";
        String alias = (String)ObjectUtils.doIfNotNull((Object)strconvImportSpec, spec -> spec.getAlias());
        if (alias != null && !"_".equals(alias)) {
            qualifier = alias;
        }
        String conversionCallText = qualifier + "." + GoIntToStringConversionCallQuickFix.getConversionCallText(file2, argumentType, argumentUnderlyingType, argumentText);
        String string = !GoTypeUtil.identical(callExpressionType, callExpressionType.getUnderlyingType((PsiElement)file2), (PsiElement)file2) ? callExpressionText + "(" + conversionCallText + ")" : conversionCallText;
        if (string == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    private static String getConversionCallText(@NotNull GoFile file2, @NotNull GoType argumentType, @NotNull GoType argumentUnderlyingType, @NotNull String argumentText) {
        if (file2 == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(16);
        }
        if (argumentType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(17);
        }
        if (argumentUnderlyingType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(18);
        }
        if (argumentText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(19);
        }
        boolean isAlias = GoTypeUtil.identical(argumentType, argumentUnderlyingType, (PsiElement)file2);
        if (GoTypeUtil.isInt64(argumentUnderlyingType, (PsiElement)file2)) {
            return GoIntToStringConversionCallQuickFix.getFormatIntCallText(argumentText, isAlias);
        }
        if (GoTypeUtil.isUint64(argumentUnderlyingType, (PsiElement)file2)) {
            return GoIntToStringConversionCallQuickFix.getFormatUintCallText(argumentText, isAlias);
        }
        return GoIntToStringConversionCallQuickFix.getItoaCallText(file2, argumentUnderlyingType, argumentText, argumentText, isAlias);
    }

    @NotNull
    private static String getFormatUintCallText(@NotNull String callArgument, boolean isAlias) {
        if (callArgument == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(20);
        }
        if (!isAlias) {
            callArgument = "uint64(" + (String)callArgument + ")";
        }
        String string = "FormatUint(" + (String)callArgument + ", 10)";
        if (string == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String getFormatIntCallText(@NotNull String callArgument, boolean isAlias) {
        if (callArgument == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(22);
        }
        if (!isAlias) {
            callArgument = "int64(" + (String)callArgument + ")";
        }
        String string = "FormatInt(" + (String)callArgument + ", 10)";
        if (string == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    private static String getItoaCallText(@NotNull GoFile file2, @NotNull GoType argumentUnderlyingType, @NotNull String argumentText, @NotNull String callArgument, boolean isAlias) {
        if (file2 == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(24);
        }
        if (argumentUnderlyingType == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(25);
        }
        if (argumentText == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(26);
        }
        if (callArgument == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(27);
        }
        if (!GoTypeUtil.isIntType(argumentUnderlyingType, (PsiElement)file2) || !isAlias) {
            callArgument = "int(" + argumentText + ")";
        }
        String string = "Itoa(" + (String)callArgument + ")";
        if (string == null) {
            GoIntToStringConversionCallQuickFix.$$$reportNull$$$0(28);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 15, 21, 23, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionType";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpressionText";
                break;
            }
            case 3: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentType";
                break;
            }
            case 4: 
            case 13: 
            case 18: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentUnderlyingType";
                break;
            }
            case 5: 
            case 14: 
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentText";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 8: 
            case 15: 
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoIntToStringConversionCallQuickFix";
                break;
            }
            case 20: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callArgument";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoIntToStringConversionCallQuickFix";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildItoaCallText";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatUintCallText";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFormatIntCallText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getItoaCallText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 8: 
            case 15: 
            case 21: 
            case 23: 
            case 28: {
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildItoaCallText";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getConversionCallText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFormatUintCallText";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFormatIntCallText";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getItoaCallText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 15, 21, 23, 28 -> new IllegalStateException(string);
        };
    }
}

