/*
 * Decompiled with CFR 0.152.
 */
package com.goide.quickfix;

import com.goide.GoTypes;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoBinaryExpr;
import com.goide.psi.GoExpression;
import com.goide.quickfix.GoSimplifyBoolExprQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class GoRemoveRedundantBoolLiteralQuickFix
extends LocalQuickFixOnPsiElement {
    @IntentionName
    private final String myName;

    @Nls
    @NotNull
    public static String getQuickFixName() {
        String string = GoBundle.message((String)"go.fix.remove.redundant.bool.literal.name", (Object[])new Object[0]);
        if (string == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public GoRemoveRedundantBoolLiteralQuickFix(@NotNull GoExpression literalExpression, @NotNull String otherExpressionText) {
        if (literalExpression == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(1);
        }
        if (otherExpressionText == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(2);
        }
        super((PsiElement)literalExpression);
        this.myName = GoBundle.message((String)"go.fix.simplify.to.text", (Object[])new Object[]{otherExpressionText});
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        return GoRemoveRedundantBoolLiteralQuickFix.getQuickFixName();
    }

    @NotNull
    public String getText() {
        String string = this.myName;
        if (string == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(5);
        }
        if (startElement == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(6);
        }
        if (endElement == null) {
            GoRemoveRedundantBoolLiteralQuickFix.$$$reportNull$$$0(7);
        }
        if (!startElement.isValid()) {
            return;
        }
        GoExpression literalExpression = (GoExpression)ObjectUtils.tryCast((Object)endElement, GoExpression.class);
        if (literalExpression == null) {
            return;
        }
        GoBinaryExpr binaryExpr = (GoBinaryExpr)ObjectUtils.tryCast((Object)literalExpression.getParent(), GoBinaryExpr.class);
        if (binaryExpr == null) {
            return;
        }
        List filtered = ContainerUtil.filter(binaryExpr.getExpressionList(), e -> e != literalExpression);
        PsiElement operator = binaryExpr.getOperator();
        IElementType elementType = operator != null ? operator.getNode().getElementType() : null;
        GoSimplifyBoolExprQuickFix.replace(project, binaryExpr, elementType == GoTypes.COND_AND, filtered);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4, 5, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/quickfix/GoRemoveRedundantBoolLiteralQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalExpression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherExpressionText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuickFixName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/quickfix/GoRemoveRedundantBoolLiteralQuickFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4, 5, 6, 7 -> new IllegalArgumentException(string);
        };
    }
}

