/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor;

import com.goide.GoTypes;
import com.goide.documentation.GoDocumentationProvider;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.go.GoDefaultRenderer;
import com.goide.go.GoGotoSuperHandler;
import com.goide.go.GoGotoUtil;
import com.goide.go.GoTypeContributor;
import com.goide.i18n.GoBundle;
import com.goide.psi.GoBlock;
import com.goide.psi.GoFile;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoSignature;
import com.goide.psi.GoSpecType;
import com.goide.psi.GoTopLevelDeclaration;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeDeclaration;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoNavigationItem;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.GoTypeContributorsBasedGotoByModel;
import com.goide.refactor.template.GoTemplate;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.navigation.PsiTargetNavigator;
import com.intellij.codeInsight.navigation.TargetPresentationProvider;
import com.intellij.codeInsight.navigation.TargetUpdaterTask;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.gotoByName.ChooseByNameItemProvider;
import com.intellij.ide.util.gotoByName.ChooseByNameModel;
import com.intellij.ide.util.gotoByName.ChooseByNamePopup;
import com.intellij.ide.util.gotoByName.ChooseByNamePopupComponent;
import com.intellij.ide.util.gotoByName.DefaultChooseByNameItemProvider;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.util.FilteringProcessor;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FindSymbolParameters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GoImplementMethodsHandler
implements LanguageCodeInsightActionHandler {
    private static final String RECEIVER_NAME_VARIABLE = "RECEIVER_NAME";
    private static final String RECEIVER_VARIABLE = "RECEIVER";
    public static final Key<GoTypeSpec> TESTING_INTERFACE_TO_IMPLEMENT = Key.create((String)"GoImplementMethodsHandler.TESTING_INTERFACE_TO_IMPLEMENT");
    @VisibleForTesting
    public static final Key<Boolean> ADD_CREATE_TYPE_ITEM_IN_TESTS = Key.create((String)"GoImplementMethodsHandler.ADD_CREATE_TYPE_ITEM_IN_TESTS");

    public boolean isValidFor(@NotNull Editor editor, PsiFile file2) {
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(0);
        }
        return file2 instanceof GoFile;
    }

    public static boolean isValidTypeSpec(@Nullable GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            return false;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)typeSpec, GoBlock.class) != null) {
            return false;
        }
        GoSpecType type = typeSpec.getSpecType();
        if (type.getAssign() != null) {
            return false;
        }
        return !GoTypeUtil.isInterface(typeSpec);
    }

    @Nullable
    private static GoTypeSpec findTypeSpec(@NotNull Editor editor, @NotNull PsiFile file2) {
        List<GoTypeSpec> specList;
        Caret caret;
        int offset;
        PsiElement at;
        GoTypeSpec typeSpec;
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(2);
        }
        if ((typeSpec = (GoTypeSpec)PsiTreeUtil.getParentOfType((PsiElement)(at = (at = file2.findElementAt(offset = (caret = editor.getCaretModel().getPrimaryCaret()).getOffset())) instanceof PsiWhiteSpace || at == null && offset > 0 ? file2.findElementAt(offset - 1) : at), GoTypeSpec.class)) != null) {
            return typeSpec;
        }
        GoTypeDeclaration typeDeclaration = (GoTypeDeclaration)PsiTreeUtil.getParentOfType((PsiElement)at, GoTypeDeclaration.class);
        if (typeDeclaration != null && (specList = typeDeclaration.getTypeSpecList()).size() == 1) {
            return specList.get(0);
        }
        GoType type = (GoType)PsiTreeUtil.getParentOfType((PsiElement)at, GoType.class);
        if (type != null) {
            return (GoTypeSpec)ObjectUtils.tryCast((Object)type.contextlessResolve(), GoTypeSpec.class);
        }
        return null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(4);
        }
        if (psiFile == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(5);
        }
        if (!(psiFile instanceof GoFile)) {
            return;
        }
        GoTypeSpec typeSpecToGenerate = GoImplementMethodsHandler.findTypeSpec(editor, psiFile);
        if (GoImplementMethodsHandler.isValidTypeSpec(typeSpecToGenerate)) {
            GoImplementMethodsHandler.invoke(project, editor, psiFile, typeSpecToGenerate, GoPsiImplUtil.getTopLevelDeclaration(typeSpecToGenerate));
        } else {
            List validTypeSpecs = GoImplementMethodsHandler.selectValidTypeSpecs((GoFile)psiFile).toList();
            if (!ApplicationManager.getApplication().isUnitTestMode() || TestModeFlags.is(ADD_CREATE_TYPE_ITEM_IN_TESTS)) {
                validTypeSpecs = ContainerUtil.prepend((List)validTypeSpecs, (Object[])new NavigatablePsiElement[]{new CreateTypeFakePsiElement(psiFile)});
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                if (validTypeSpecs.size() == 1) {
                    PsiElement element2 = (PsiElement)validTypeSpecs.get(0);
                    GoImplementMethodsHandler.invokeOnPopupElement(project, editor, psiFile, element2);
                    return;
                }
                if (validTypeSpecs.isEmpty()) {
                    return;
                }
                throw new RuntimeException("Multiple pop-up choices");
            }
            GoDefaultRenderer renderer = GoDefaultRenderer.fromContext((PsiElement)psiFile);
            new PsiTargetNavigator(validTypeSpecs).presentationProvider((TargetPresentationProvider)renderer).builderConsumer(builder -> builder.setResizable(true).setMovable(true).setSelectionMode(0)).updater(new TargetUpdaterTask(this, project, GoBundle.message((String)"go.refactoring.implement.methods.dummy.background.updater.task.title", (Object[])new Object[0]), renderer.getItemWithPresentationComparator()){

                @Nullable
                public String getCaption(int size) {
                    return null;
                }
            }).createPopup(psiFile.getProject(), CodeInsightBundle.message((String)"choose.type.popup.title", (Object[])new Object[0]), element -> {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    GoImplementMethodsHandler.invokeOnPopupElement(project, editor, psiFile, element);
                }, ModalityState.current());
                return true;
            }).showInBestPositionFor(editor);
        }
    }

    private static StreamEx<NavigatablePsiElement> selectValidTypeSpecs(@NotNull GoFile file2) {
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(6);
        }
        return ((StreamEx)StreamEx.of(file2.getTypes()).filter(GoImplementMethodsHandler::isValidTypeSpec)).select(NavigatablePsiElement.class);
    }

    private static void invokeOnPopupElement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @Nullable PsiElement selectedPopupElement) {
        if (project == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(8);
        }
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(9);
        }
        if (selectedPopupElement instanceof GoTypeSpec) {
            GoTypeSpec typeSpec = (GoTypeSpec)selectedPopupElement;
            GoImplementMethodsHandler.invoke(project, editor, file2, typeSpec, null);
        } else {
            GoImplementMethodsHandler.invoke(project, editor, file2, null, null);
        }
    }

    public static void invoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file2, final @Nullable GoTypeSpec typeSpecToGenerate, final @Nullable GoTopLevelDeclaration anchor) {
        GoTypeSpec testingInterfaceToImplement;
        if (project == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(12);
        }
        final GoTypeContributorsBasedGotoByModel model = new GoTypeContributorsBasedGotoByModel(project, new MyGoTypeContributor(typeSpecToGenerate), GoBundle.message((String)"go.refactoring.implement.methods.prompt", (Object[])new Object[0]));
        ChooseByNamePopup oldPopup = (ChooseByNamePopup)project.getUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY);
        if (oldPopup != null) {
            oldPopup.close(false);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (ApplicationManager.getApplication().isUnitTestMode() && (testingInterfaceToImplement = (GoTypeSpec)TestModeFlags.get(TESTING_INTERFACE_TO_IMPLEMENT)) != null) {
            GoImplementMethodsHandler.generateTemplate((GoFile)file2, editor, typeSpecToGenerate, testingInterfaceToImplement, anchor);
            return;
        }
        DefaultChooseByNameItemProvider provider = new DefaultChooseByNameItemProvider((PsiElement)file2);
        final MyChooseByNamePopup popup = new MyChooseByNamePopup(project, (ChooseByNameModel)model, (ChooseByNameItemProvider)provider, oldPopup);
        project.putUserData(ChooseByNamePopup.CHOOSE_BY_NAME_POPUP_IN_PROJECT_KEY, (Object)popup);
        popup.setCheckBoxShortcut(ActionManager.getInstance().getAction("ImplementMethods").getShortcutSet());
        popup.setSearchInAnyPlace(true);
        popup.invoke(new ChooseByNamePopupComponent.Callback(){

            public void elementChosen(Object element) {
            }

            public void onClose() {
                Disposer.dispose((Disposable)model);
                if (!popup.myClosedCorrectly) {
                    return;
                }
                NavigationItem chosenElement = this.getChosenItem();
                if (chosenElement instanceof GoTypeSpec && !project.isDisposed()) {
                    IdeFocusManager.getInstance((Project)project).doWhenFocusSettlesDown(() -> GoImplementMethodsHandler.generateTemplate((GoFile)file2, editor, typeSpecToGenerate, (GoTypeSpec)chosenElement, anchor));
                }
            }

            private NavigationItem getChosenItem() {
                NavigationItem navigationItem;
                Object chosenElement = popup.getChosenElement();
                if (chosenElement == null) {
                    return null;
                }
                if (chosenElement instanceof GoNavigationItem) {
                    GoNavigationItem resolved = (GoNavigationItem)chosenElement;
                    navigationItem = resolved.getNamedElement();
                } else {
                    navigationItem = (NavigationItem)chosenElement;
                }
                return navigationItem;
            }
        }, ModalityState.current(), true);
    }

    public static void generateTemplate(@NotNull GoFile currentFile, @NotNull Editor editor, @Nullable GoTypeSpec typeSpecToGenerate, @NotNull GoTypeSpec interfaceToImplement, @Nullable GoTopLevelDeclaration anchor) {
        GoFile targetFile;
        GoFile file2;
        if (currentFile == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(14);
        }
        if (interfaceToImplement == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(15);
        }
        if (!((Object)((Object)(file2 = (GoFile)((Object)ObjectUtils.notNull((Object)((Object)(targetFile = (GoFile)((Object)ObjectUtils.doIfNotNull((Object)typeSpecToGenerate, GoNamedElement::getContainingFile)))), (Object)((Object)currentFile)))))).equals((Object)currentFile)) {
            editor = GoRefactoringUtil.openEditorForRefactoring((PsiFile)file2);
        }
        Project project = file2.getProject();
        if (!file2.isValid() || editor == null || editor.isDisposed() || project.isDisposed()) {
            return;
        }
        String title = GoBundle.message((String)"go.refactoring.implement.methods.preparing.template.progress.title", (Object[])new Object[0]);
        GoTemplate template = (GoTemplate)ActionUtil.underModalProgress((Project)project, (String)title, () -> GoImplementMethodsHandler.prepareTemplate(typeSpecToGenerate, interfaceToImplement, file2));
        int offset = GoImplementMethodsHandler.calcOffset(editor, anchor, file2);
        template.startTemplate(editor, offset, GoBundle.message((String)"go.refactoring.implement.methods.command", (Object[])new Object[]{interfaceToImplement.getName()}), null);
    }

    @NotNull
    private static GoTemplate prepareTemplate(@Nullable GoTypeSpec typeSpecToGenerate, @NotNull GoTypeSpec interfaceToImplement, @NotNull GoFile file2) {
        if (interfaceToImplement == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(17);
        }
        GoTemplate template = new GoTemplate(file2);
        template.addTextSegment("\n");
        boolean firstMethod = true;
        if (typeSpecToGenerate == null) {
            template.addTextSegment("\ntype ");
            template.addPrimaryVariable(RECEIVER_VARIABLE);
            template.addTextSegment(" struct{}\n");
            firstMethod = false;
        }
        List<GoNamedSignatureOwner> existingMethods = typeSpecToGenerate != null ? GoImplementMethodsHandler.removeShadowedMethods(typeSpecToGenerate.getAllMethods()) : ContainerUtil.emptyList();
        String todoComment = GoImplementMethodsHandler.getTodoComment(file2);
        List<GoNamedSignatureOwner> methodsToImplement = GoImplementMethodsHandler.removeDuplicates(interfaceToImplement.getAllMethods());
        for (GoNamedSignatureOwner m : methodsToImplement) {
            String methodName = m.getName();
            GoSignature signature = m.getSignature();
            if (methodName == null || signature == null || GoImplementMethodsHandler.isAlreadyImplemented(m, existingMethods)) continue;
            template.addTextSegment("\nfunc ");
            if (firstMethod) {
                template.setupMethodReceiver(typeSpecToGenerate, RECEIVER_NAME_VARIABLE, RECEIVER_VARIABLE, false);
            } else {
                template.setupSecondaryMethodReceiver(RECEIVER_NAME_VARIABLE, RECEIVER_VARIABLE);
            }
            template.addTextSegment(methodName);
            template.setupSignature(signature, false, true);
            template.addTextSegment(" {\n\t");
            if (firstMethod) {
                template.addEndVariable();
            }
            template.addTextSegment(todoComment + "panic(\"implement me\")\n}\n");
            firstMethod = false;
        }
        GoTemplate goTemplate = template;
        if (goTemplate == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(18);
        }
        return goTemplate;
    }

    @Contract(value="_ -> new")
    @NotNull
    public static List<GoNamedSignatureOwner> removeShadowedMethods(List<GoNamedSignatureOwner> methods) {
        LinkedHashMap<String, GoNamedSignatureOwner> resultMethods = new LinkedHashMap<String, GoNamedSignatureOwner>();
        for (GoNamedSignatureOwner method : methods) {
            resultMethods.putIfAbsent(method.getName(), method);
        }
        return new ArrayList<GoNamedSignatureOwner>(resultMethods.values());
    }

    @Contract(value="_ -> new")
    @NotNull
    private static List<GoNamedSignatureOwner> removeDuplicates(List<GoNamedSignatureOwner> methods) {
        ArrayList<GoNamedSignatureOwner> uniqueMethods = new ArrayList<GoNamedSignatureOwner>();
        for (GoNamedSignatureOwner method : methods) {
            if (GoImplementMethodsHandler.isAlreadyImplemented(method, uniqueMethods)) continue;
            uniqueMethods.add(method);
        }
        ArrayList<GoNamedSignatureOwner> arrayList = uniqueMethods;
        if (arrayList == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    private static String getTodoComment(@NotNull GoFile file2) {
        boolean addLeadingSpace;
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(20);
        }
        String string = "//" + ((addLeadingSpace = ((GoCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file2, GoCodeStyleSettings.class)).ADD_LEADING_SPACE_TO_COMMENTS) ? " " : "") + "TODO implement me\n";
        if (string == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(21);
        }
        return string;
    }

    public static int calcOffset(@NotNull Editor editor, @Nullable PsiElement anchor, @NotNull GoFile file2) {
        List<PsiComment> comments;
        PsiComment lastComment;
        PsiElement next;
        if (editor == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(22);
        }
        if (file2 == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(23);
        }
        if (anchor == null) {
            int offset = editor.getCaretModel().getOffset();
            GoTopLevelDeclaration top = GoPsiImplUtil.getTopLevelDeclaration(file2.findElementAt(offset));
            if (top == null) {
                return offset;
            }
            anchor = top;
        }
        Object target = (next = PsiTreeUtil.nextVisibleLeaf((PsiElement)anchor)) instanceof LeafPsiElement && ((LeafPsiElement)next).getElementType() == GoTypes.SEMICOLON ? next : ((lastComment = (PsiComment)ContainerUtil.getLastItem(comments = GoDocumentationProvider.getAfterComments(anchor))) != null ? lastComment : anchor);
        return target.getTextRange().getEndOffset();
    }

    private static boolean isAlreadyImplemented(@NotNull GoNamedSignatureOwner m, @NotNull List<GoNamedSignatureOwner> existingMethod) {
        if (m == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(24);
        }
        if (existingMethod == null) {
            GoImplementMethodsHandler.$$$reportNull$$$0(25);
        }
        return ContainerUtil.exists(existingMethod, em -> Objects.equals(em.getName(), m.getName()) && GoTypeUtil.areSignaturesIdentical(m, em, true));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 17: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentFile";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceToImplement";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/GoImplementMethodsHandler";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/GoImplementMethodsHandler";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTemplate";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicates";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getTodoComment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findTypeSpec";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "selectValidTypeSpecs";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invokeOnPopupElement";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "generateTemplate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "prepareTemplate";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getTodoComment";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "calcOffset";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isAlreadyImplemented";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19, 21 -> new IllegalStateException(string);
        };
    }

    private static final class CreateTypeFakePsiElement
    extends RenameableFakePsiElement {
        private CreateTypeFakePsiElement(@NotNull PsiFile file2) {
            if (file2 == null) {
                CreateTypeFakePsiElement.$$$reportNull$$$0(0);
            }
            super((PsiElement)file2);
        }

        public String getName() {
            return GoBundle.message((String)"go.refactoring.implement.methods.create.type.name", (Object[])new Object[0]);
        }

        public String getTypeName() {
            return this.getName();
        }

        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Actions.IntentionBulb;
            if (icon == null) {
                CreateTypeFakePsiElement.$$$reportNull$$$0(1);
            }
            return icon;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/GoImplementMethodsHandler$CreateTypeFakePsiElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/GoImplementMethodsHandler$CreateTypeFakePsiElement";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIcon";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static class MyGoTypeContributor
    extends GoTypeContributor
    implements Disposable {
        private GoTypeSpec myGenerate;
        private Set<GoTypeSpec> myAlreadyImplementedTypes;

        @NotNull
        Set<GoTypeSpec> getAlreadyImplementedTypes() {
            if (this.myAlreadyImplementedTypes == null) {
                HashSet<GoTypeSpec> set = new HashSet<GoTypeSpec>();
                if (this.myGenerate != null) {
                    GoGotoSuperHandler.SUPER_SEARCH.execute(GoGotoUtil.param(this.myGenerate), Processors.cancelableCollectProcessor(set));
                }
                this.myAlreadyImplementedTypes = set;
            }
            Set<GoTypeSpec> set = this.myAlreadyImplementedTypes;
            if (set == null) {
                MyGoTypeContributor.$$$reportNull$$$0(0);
            }
            return set;
        }

        MyGoTypeContributor(@Nullable GoTypeSpec typeSpecToGenerate) {
            this.myGenerate = typeSpecToGenerate;
        }

        @Override
        public void processElementsWithName(@NotNull String s, @NotNull Processor<? super NavigationItem> processor2, @NotNull FindSymbolParameters parameters) {
            if (s == null) {
                MyGoTypeContributor.$$$reportNull$$$0(1);
            }
            if (processor2 == null) {
                MyGoTypeContributor.$$$reportNull$$$0(2);
            }
            if (parameters == null) {
                MyGoTypeContributor.$$$reportNull$$$0(3);
            }
            Set<GoTypeSpec> alreadyImplementedTypes = this.getAlreadyImplementedTypes();
            Processor resolvingProcessor = item -> {
                Object navigationItem = item instanceof GoNamedElement ? new GoNavigationItem((GoNamedElement)item) : item;
                return processor2.process(navigationItem);
            };
            FilteringProcessor filteringProcessor = new FilteringProcessor(o -> {
                if (!(o instanceof GoTypeSpec)) {
                    return false;
                }
                GoTypeSpec typeSpec = (GoTypeSpec)o;
                if (alreadyImplementedTypes.contains(o)) {
                    return false;
                }
                return GoTypeUtil.isInterface(typeSpec);
            }, resolvingProcessor);
            super.processElementsWithName(s, (Processor<NavigationItem>)filteringProcessor, parameters);
        }

        public void dispose() {
            this.myGenerate = null;
            if (this.myAlreadyImplementedTypes != null) {
                this.myAlreadyImplementedTypes.clear();
            }
            this.myAlreadyImplementedTypes = null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/refactor/GoImplementMethodsHandler$MyGoTypeContributor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAlreadyImplementedTypes";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/refactor/GoImplementMethodsHandler$MyGoTypeContributor";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "processElementsWithName";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    private static final class MyChooseByNamePopup
    extends ChooseByNamePopup {
        private boolean myClosedCorrectly;

        private MyChooseByNamePopup(@Nullable Project project, @NotNull ChooseByNameModel model, @NotNull ChooseByNameItemProvider provider, @Nullable ChooseByNamePopup oldPopup) {
            if (model == null) {
                MyChooseByNamePopup.$$$reportNull$$$0(0);
            }
            if (provider == null) {
                MyChooseByNamePopup.$$$reportNull$$$0(1);
            }
            super(project, model, provider, oldPopup, null, false, 0);
        }

        public void close(boolean isOk) {
            if (!this.checkDisposed()) {
                this.myClosedCorrectly = isOk;
            }
            super.close(isOk);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "model";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "provider";
                    break;
                }
            }
            objectArray[1] = "com/goide/refactor/GoImplementMethodsHandler$MyChooseByNamePopup";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

