/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.changeSignature;

import com.goide.GoLanguage;
import com.goide.psi.GoCompositeElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameters;
import com.goide.psi.GoResult;
import com.goide.psi.GoType;
import com.goide.refactor.changeSignature.GoChangeSignatureUtil;
import com.goide.refactor.changeSignature.GoMethodDescriptor;
import com.goide.refactor.changeSignature.GoParameterInfo;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GoMethodChangeInfo
implements ChangeInfo {
    private final GoMethodDescriptor myMethod;
    private final String myNewMethodName;
    private final GoParameterInfo[] myParameters;
    private final GoParameterInfo[] myResultParameters;

    GoMethodChangeInfo(@NotNull GoMethodDescriptor method, @NotNull String newMethodName, GoParameterInfo @NotNull [] parameters, GoParameterInfo @NotNull [] resultParameters) {
        if (method == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(0);
        }
        if (newMethodName == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(1);
        }
        if (parameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(2);
        }
        if (resultParameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(3);
        }
        this.myMethod = method;
        this.myNewMethodName = newMethodName;
        this.myParameters = parameters;
        this.myResultParameters = resultParameters;
    }

    public GoParameterInfo @NotNull [] getNewParameters() {
        if (this.myParameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(4);
        }
        return this.myParameters;
    }

    int getOldParametersLength() {
        return GoChangeSignatureUtil.getDefinitions(this.myMethod.getSignature().getParameters()).size();
    }

    public boolean isParameterSetOrOrderChanged() {
        return GoMethodChangeInfo.isParameterSetOrOrderChanged(this.myMethod.getSignature().getParameters(), this.myParameters);
    }

    public boolean isParameterTypesChanged() {
        return ContainerUtil.or((Object[])this.myParameters, GoParameterInfo::isTypeChanged);
    }

    public boolean isParameterNamesChanged() {
        return ContainerUtil.or((Object[])this.myParameters, GoParameterInfo::isNameChanged);
    }

    public GoParameterInfo @NotNull [] getNewResultParameters() {
        if (this.myResultParameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(5);
        }
        return this.myResultParameters;
    }

    int getOldResultParametersLength() {
        GoResult result = this.myMethod.getSignature().getResult();
        GoParameters parameters = (GoParameters)ObjectUtils.doIfNotNull((Object)result, GoResult::getParameters);
        GoType type = (GoType)ObjectUtils.doIfNotNull((Object)result, GoResult::getType);
        if (result == null || parameters == null && type == null) {
            return 0;
        }
        return type != null ? 1 : GoChangeSignatureUtil.getDefinitions(parameters).size();
    }

    boolean isResultParameterSetOrOrderChanged() {
        GoResult result = this.myMethod.getSignature().getResult();
        GoParameters parameters = (GoParameters)ObjectUtils.doIfNotNull((Object)result, GoResult::getParameters);
        GoType type = (GoType)ObjectUtils.doIfNotNull((Object)result, GoResult::getType);
        if (result == null || parameters == null && type == null) {
            return this.myResultParameters.length != 0;
        }
        if (type != null) {
            return this.myResultParameters.length != 1 || this.myResultParameters[0].getOldIndex() != 0;
        }
        return GoMethodChangeInfo.isParameterSetOrOrderChanged(parameters, this.myResultParameters);
    }

    private static boolean isParameterSetOrOrderChanged(@NotNull GoParameters oldParameters, GoParameterInfo @NotNull [] newParameters) {
        List<? extends PsiElement> definitions;
        if (oldParameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(6);
        }
        if (newParameters == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(7);
        }
        if ((definitions = GoChangeSignatureUtil.getDefinitions(oldParameters)).size() != newParameters.length) {
            return true;
        }
        for (int i = 0; i < definitions.size(); ++i) {
            if (newParameters[i].getOldIndex() == i) continue;
            return true;
        }
        return false;
    }

    boolean isResultParameterTypesChanged() {
        return ContainerUtil.or((Object[])this.myResultParameters, GoParameterInfo::isTypeChanged);
    }

    boolean isResultParameterNamesChanged() {
        return ContainerUtil.or((Object[])this.myResultParameters, GoParameterInfo::isNameChanged);
    }

    boolean isAnyParameterChanged() {
        return this.myMethod.isReuseTypesChanged() || this.isParameterNamesChanged() || this.isResultParameterNamesChanged() || this.isParameterTypesChanged() || this.isResultParameterTypesChanged() || this.isParameterSetOrOrderChanged() || this.isResultParameterSetOrOrderChanged();
    }

    public boolean isNameChanged() {
        return !this.myNewMethodName.equals(this.myMethod.getName());
    }

    @NotNull
    public GoNamedSignatureOwner getMethod() {
        GoNamedSignatureOwner goNamedSignatureOwner = Objects.requireNonNull(this.myMethod.getMethod());
        if (goNamedSignatureOwner == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(8);
        }
        return goNamedSignatureOwner;
    }

    @NotNull
    public String getNewName() {
        String string = this.myNewMethodName;
        if (string == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(9);
        }
        return string;
    }

    boolean hasParameterTrailingComma() {
        return this.myMethod.hasParameterTrailingComma();
    }

    boolean hasResultParameterTrailingComma() {
        return this.myMethod.hasResultParameterTrailingComma();
    }

    @Nullable
    GoCompositeElement getLocationToSkip() {
        return this.myMethod.getLocationToSkip();
    }

    boolean isRefactorImplementations() {
        return this.myMethod.isRefactorImplementations();
    }

    boolean isReuseTypes() {
        return this.myMethod.isReuseTypes();
    }

    @NotNull
    Project getProject() {
        Project project = this.getMethod().getProject();
        if (project == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(10);
        }
        return project;
    }

    @NotNull
    public Language getLanguage() {
        Language language = GoLanguage.INSTANCE;
        if (language == null) {
            GoMethodChangeInfo.$$$reportNull$$$0(11);
        }
        return language;
    }

    public boolean isReturnTypeChanged() {
        return false;
    }

    public boolean isGenerateDelegate() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMethodName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultParameters";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/changeSignature/GoMethodChangeInfo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldParameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/changeSignature/GoMethodChangeInfo";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewParameters";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewResultParameters";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethod";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isParameterSetOrOrderChanged";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

