/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.extractInterface;

import com.goide.i18n.GoBundle;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.refactor.GoNamesValidator;
import com.goide.refactor.extractInterface.GoExtractInterfaceInfoModel;
import com.goide.refactor.extractInterface.GoExtractInterfaceProcessor;
import com.goide.refactor.extractInterface.TypeSpecWithSelectedMethods;
import com.goide.refactor.ui.GoDeclarationInfo;
import com.goide.refactor.ui.GoRefactoringDialogWithDeclarations;
import com.goide.stubs.GoMethodDeclarationStub;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.ComponentPanelBuilder;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.ui.components.JBBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ItemEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@VisibleForTesting
public class GoExtractInterfaceDialog
extends GoRefactoringDialogWithDeclarations<GoExtractInterfaceInfoModel> {
    private final TypeSpecWithSelectedMethods mySpecWithSelectedMethods;
    private JRadioButton myRenameTypeSpecRadioButton;
    private JTextField myNewTypeNameField;

    public GoExtractInterfaceDialog(@NotNull TypeSpecWithSelectedMethods specWithSelectedMethods) {
        if (specWithSelectedMethods == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(0);
        }
        super(GoExtractInterfaceDialog.getTypeSpecWithAllMethods(specWithSelectedMethods.myTypeSpec), specWithSelectedMethods.myTypeSpec.getProject());
        this.mySpecWithSelectedMethods = specWithSelectedMethods;
        this.init();
    }

    @NotNull
    private static Collection<PsiElement> getTypeSpecWithAllMethods(GoTypeSpec typeSpec) {
        List list = ContainerUtil.prepend(GoExtractInterfaceDialog.getMethods(typeSpec), (Object[])new PsiElement[]{typeSpec});
        if (list == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(1);
        }
        return list;
    }

    @VisibleForTesting
    @NotNull
    public static List<? extends GoNamedSignatureOwner> getMethods(@NotNull GoTypeSpec typeSpec) {
        if (typeSpec == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(2);
        }
        List<StubBasedPsiElement<GoMethodDeclarationStub>> list = GoTypeUtil.isInterface(typeSpec) ? ((GoInterfaceType)typeSpec.getSpecType().getContextlessUnderlyingType()).getMethods() : typeSpec.getMethods();
        if (list == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        if (this.myRenameTypeSpecRadioButton == null || this.myNewTypeNameField == null) {
            List<ValidationInfo> list = Collections.emptyList();
            if (list == null) {
                GoExtractInterfaceDialog.$$$reportNull$$$0(4);
            }
            return list;
        }
        GoTypeSpec typeSpec = this.getTypeSpec();
        String newTypeName = this.getNewTypeName();
        GoExtractInterfaceInfoModel model = (GoExtractInterfaceInfoModel)((Object)this.getDeclarationInfoModel());
        model.setTypeSpec(typeSpec);
        model.setRenameTypeSpec(this.isRenameTypeSpec());
        model.setNewTypeName(newTypeName);
        List<ValidationInfo> infos = super.doValidateAll();
        if (StringUtil.isEmpty((String)newTypeName)) {
            String message = GoBundle.message((String)"go.refactoring.extract.interface.empty.type.name.validation.message", (Object[])new Object[0]);
            infos.add(new ValidationInfo(message, (JComponent)this.myNewTypeNameField));
        }
        List<ValidationInfo> list = infos;
        if (list == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @NotNull
    protected BaseRefactoringProcessor getRefactoringProcessor(@NotNull GoExtractInterfaceInfoModel model) {
        if (model == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(6);
        }
        return new GoExtractInterfaceProcessor(this.getProject(), model, this.isOpenInEditor());
    }

    @Override
    @VisibleForTesting
    @NotNull
    public List<GoDeclarationInfo> getDeclarationInfos() {
        List list = ((StreamEx)((StreamEx)StreamEx.of((Collection)this.myDeclarations).skip(1L)).select(GoNamedElement.class).map(GoDeclarationInfo::new).peek(this::setChecked)).toList();
        if (list == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(7);
        }
        return list;
    }

    private void setChecked(@NotNull GoDeclarationInfo info) {
        if (info == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(8);
        }
        info.setChecked(this.mySpecWithSelectedMethods.mySelectedMethods.contains(info.getDeclaration()));
    }

    @Override
    @NotNull
    protected GoExtractInterfaceInfoModel createDeclarationInfoModel(@NotNull List<GoDeclarationInfo> infos) {
        if (infos == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(9);
        }
        return new GoExtractInterfaceInfoModel(infos);
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        JComponent panel2 = super.createCenterPanel();
        PanelGridBuilder grid = UI.PanelFactory.grid();
        GoTypeSpec spec = this.getTypeSpec();
        grid.add(GoExtractInterfaceDialog.createSpecField(spec));
        this.createExtractRadioButtons();
        grid.add(this.createExtractedTypeNameField(spec));
        panel2.add(grid.createPanel(), "Center", 0);
        JComponent jComponent = panel2;
        if (jComponent == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(10);
        }
        return jComponent;
    }

    @Override
    @NotNull
    protected MemberInfoChangeListener<GoNamedElement, GoDeclarationInfo> getMemberInfoChangeListener() {
        MemberInfoChangeListener memberInfoChangeListener = e -> this.updatePreviewAction();
        if (memberInfoChangeListener == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(11);
        }
        return memberInfoChangeListener;
    }

    @NotNull
    private GoTypeSpec getTypeSpec() {
        GoTypeSpec goTypeSpec = this.mySpecWithSelectedMethods.myTypeSpec;
        if (goTypeSpec == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(12);
        }
        return goTypeSpec;
    }

    @NotNull
    private static PanelBuilder createSpecField(@NotNull GoTypeSpec spec) {
        if (spec == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(13);
        }
        JTextField specField = new JTextField();
        specField.setEditable(false);
        specField.setText(spec.getQualifiedName());
        ComponentPanelBuilder componentPanelBuilder = UI.PanelFactory.panel((JComponent)specField).withLabel(RefactoringBundle.message((String)"extract.interface.from"));
        if (componentPanelBuilder == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(14);
        }
        return componentPanelBuilder;
    }

    @NotNull
    private PanelBuilder createExtractRadioButtons() {
        JBBox box = JBBox.createHorizontalBox();
        JRadioButton extractInterfaceRadioButton = new JRadioButton();
        extractInterfaceRadioButton.setText(RefactoringBundle.message((String)"extractSuper.extract", (Object[])new Object[]{"interface"}));
        extractInterfaceRadioButton.setSelected(true);
        this.myRenameTypeSpecRadioButton = new JRadioButton();
        this.myRenameTypeSpecRadioButton.setText(GoBundle.message((String)"go.refactoring.extract.interface.rename.type.and.use.interface.radio.button", (Object[])new Object[0]));
        box.add((Component)extractInterfaceRadioButton);
        box.add((Component)this.myRenameTypeSpecRadioButton);
        box.add(Box.createHorizontalGlue());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(extractInterfaceRadioButton);
        buttonGroup.add(this.myRenameTypeSpecRadioButton);
        extractInterfaceRadioButton.addItemListener(this::updateDialog);
        this.myRenameTypeSpecRadioButton.addItemListener(this::updateDialog);
        this.updatePreviewAction();
        ComponentPanelBuilder componentPanelBuilder = UI.PanelFactory.panel((JComponent)box);
        if (componentPanelBuilder == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(15);
        }
        return componentPanelBuilder;
    }

    private void updateDialog(ItemEvent e) {
        Container parent = this.myNewTypeNameField.getParent();
        JLabel label = (JLabel)UIUtil.uiChildren((Component)parent).filter(JLabel.class).first();
        Objects.requireNonNull(label).setText(this.getClassNameLabelText());
        this.updatePreviewAction();
    }

    private void updatePreviewAction() {
        this.getPreviewAction().setEnabled(this.isRenameTypeSpec() || ((GoExtractInterfaceInfoModel)((Object)this.getDeclarationInfoModel())).getDeclarationsToChangeVisibility().length > 0);
    }

    @NotNull
    private PanelBuilder createExtractedTypeNameField(@NotNull GoTypeSpec spec) {
        if (spec == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(16);
        }
        this.myNewTypeNameField = new JTextField();
        this.myNewTypeNameField.setText(spec.getName());
        this.myNewTypeNameField.selectAll();
        new ComponentValidator(this.getDisposable()).withValidator(() -> this.validateType(this.getNewTypeName())).installOn((JComponent)this.myNewTypeNameField).andRegisterOnDocumentListener((JTextComponent)this.myNewTypeNameField).andStartOnFocusLost();
        ComponentPanelBuilder componentPanelBuilder = UI.PanelFactory.panel((JComponent)this.myNewTypeNameField).withLabel(this.getClassNameLabelText());
        if (componentPanelBuilder == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(17);
        }
        return componentPanelBuilder;
    }

    @Nullable
    public ValidationInfo validateType(@NotNull String extractedTypeName) {
        if (extractedTypeName == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(18);
        }
        if (StringUtil.isEmpty((String)extractedTypeName)) {
            return null;
        }
        if (!GoNamesValidator.INSTANCE.isIdentifier(extractedTypeName, null)) {
            String message = GoBundle.message((String)"go.refactoring.extract.interface.incorrect.type.name.validation.message", (Object[])new Object[0]);
            return new ValidationInfo(message, (JComponent)this.myNewTypeNameField);
        }
        return null;
    }

    @NlsContexts.Label
    @NotNull
    private String getClassNameLabelText() {
        String string = this.isRenameTypeSpec() ? GoBundle.message((String)"go.refactoring.extract.interface.rename.type.spec.label", (Object[])new Object[0]) : RefactoringBundle.message((String)"interface.name.prompt");
        if (string == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(19);
        }
        return string;
    }

    private boolean isRenameTypeSpec() {
        return this.myRenameTypeSpecRadioButton != null && this.myRenameTypeSpecRadioButton.isSelected();
    }

    @NotNull
    private String getNewTypeName() {
        String string = this.myNewTypeNameField.getText();
        if (string == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Override
    @NotNull
    protected List<JComponent> getComponentsToValidate() {
        List list = ContainerUtil.prepend(super.getComponentsToValidate(), (Object[])new JComponent[]{this.myNewTypeNameField});
        if (list == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myNewTypeNameField;
    }

    @Override
    @NotNull
    protected String getRefactoringName() {
        String string = RefactoringBundle.message((String)"extract.interface.title");
        if (string == null) {
            GoExtractInterfaceDialog.$$$reportNull$$$0(22);
        }
        return string;
    }

    @NotNull
    protected String getRefactoringId() {
        return "GoExtractInterfaceDialog";
    }

    @Nullable
    protected String getHelpId() {
        return "Extract_interface_";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 5, 7, 10, 11, 12, 14, 15, 17, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specWithSelectedMethods";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/extractInterface/GoExtractInterfaceDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeSpec";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "spec";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/extractInterface/GoExtractInterfaceDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSpecWithAllMethods";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doValidateAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationInfos";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberInfoChangeListener";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSpec";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createSpecField";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractRadioButtons";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createExtractedTypeNameField";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassNameLabelText";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewTypeName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentsToValidate";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefactoringName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRefactoringProcessor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setChecked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createDeclarationInfoModel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createSpecField";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createExtractedTypeNameField";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "validateType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 5, 7, 10, 11, 12, 14, 15, 17, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

