/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.rename;

import com.goide.formatter.GoFormatterUtil;
import com.goide.inspections.tag.GoTagFieldNameStyle;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.psi.impl.GoElementFactory;
import com.goide.refactor.rename.GoRenameFieldDefinitionProcessorKt;
import com.goide.refactor.rename.GoRenamePsiElementProcessor;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.NameUtilCore;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J5\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J \u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\tH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/goide/refactor/rename/GoRenameTagProcessor;", "Lcom/goide/refactor/rename/GoRenamePsiElementProcessor;", "<init>", "()V", "renameElement", "", "element", "Lcom/intellij/psi/PsiElement;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "listener", "Lcom/intellij/refactoring/listeners/RefactoringElementListener;", "(Lcom/intellij/psi/PsiElement;Ljava/lang/String;[Lcom/intellij/usageView/UsageInfo;Lcom/intellij/refactoring/listeners/RefactoringElementListener;)V", "canProcessElement", "", "updateTagValue", "tagValue", "normalizedOldName", "normalizedNewName", "applyCaseStyleToValue", "processedValue", "name", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nGoRenameTagProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoRenameTagProcessor.kt\ncom/goide/refactor/rename/GoRenameTagProcessor\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,95:1\n66#2,2:96\n*S KotlinDebug\n*F\n+ 1 GoRenameTagProcessor.kt\ncom/goide/refactor/rename/GoRenameTagProcessor\n*L\n51#1:96,2\n*E\n"})
public final class GoRenameTagProcessor
extends GoRenamePsiElementProcessor {
    public void renameElement(@NotNull PsiElement element, @NotNull String newName, @NotNull UsageInfo[] usages2, @Nullable RefactoringElementListener listener2) throws IncorrectOperationException {
        block4: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
            Intrinsics.checkNotNullParameter((Object)usages2, (String)"usages");
            if (!(element instanceof GoTag)) {
                return;
            }
            String string = (String)element.getUserData(GoRenameFieldDefinitionProcessorKt.getTAG_RENAME_OLD_NAME());
            if (string == null) {
                return;
            }
            String oldName = string;
            element.putUserData(GoRenameFieldDefinitionProcessorKt.getTAG_RENAME_OLD_NAME(), null);
            if (((CharSequence)oldName).length() == 0) {
                return;
            }
            CharSequence charSequence = oldName;
            Object object = GoRenameFieldDefinitionProcessorKt.getTAG_VALUE_NORMALIZATION_REGEX();
            String string2 = "";
            String normalizedOldName = object.replace(charSequence, string2);
            object = newName;
            string2 = GoRenameFieldDefinitionProcessorKt.getTAG_VALUE_NORMALIZATION_REGEX();
            String string3 = "";
            String normalizedNewName = string2.replace((CharSequence)object, string3);
            List<Pair<String, String>> list = GoTagUtil.getEntries((GoTag)element);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getEntries(...)");
            String newTagContent = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, arg_0 -> GoRenameTagProcessor.renameElement$lambda$0(this, normalizedOldName, normalizedNewName, arg_0), (int)30, null);
            GoTag goTag = GoElementFactory.createTag(((GoTag)element).getProject(), newTagContent);
            Intrinsics.checkNotNullExpressionValue((Object)goTag, (String)"createTag(...)");
            GoTag newTag = goTag;
            PsiElement replacedElement = element.replace((PsiElement)newTag);
            Intrinsics.checkNotNull((Object)replacedElement);
            PsiElement $this$parentOfType_u24default$iv = replacedElement;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            GoStructType parentStruct = (GoStructType)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, GoStructType.class, (boolean)true);
            if (parentStruct != null) {
                GoFormatterUtil.reformat(parentStruct);
            }
            RefactoringElementListener refactoringElementListener = listener2;
            if (refactoringElementListener == null) break block4;
            refactoringElementListener.elementRenamed(element);
        }
    }

    @Override
    public boolean canProcessElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof GoTag;
    }

    private final String updateTagValue(String tagValue, String normalizedOldName, String normalizedNewName) {
        String string;
        CharSequence charSequence = tagValue;
        Regex regex = GoRenameFieldDefinitionProcessorKt.getTAG_VALUE_NORMALIZATION_REGEX();
        String normalizedValue = regex.replace(charSequence, string = "");
        if (!StringsKt.contains((CharSequence)normalizedValue, (CharSequence)normalizedOldName, (boolean)true)) {
            return tagValue;
        }
        GoTagFieldNameStyle goTagFieldNameStyle = GoTagFieldNameStyle.guessStyle(tagValue);
        if (goTagFieldNameStyle == null) {
            return tagValue;
        }
        GoTagFieldNameStyle style = goTagFieldNameStyle;
        String string2 = style.apply(normalizedOldName);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"apply(...)");
        String styledOldName = this.applyCaseStyleToValue(normalizedValue, string2);
        String string3 = style.apply(normalizedNewName);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"apply(...)");
        String styledNewName = this.applyCaseStyleToValue(normalizedValue, string3);
        return StringsKt.replace((String)tagValue, (String)styledOldName, (String)styledNewName, (boolean)true);
    }

    private final String applyCaseStyleToValue(String processedValue, String name) {
        String string;
        if (StringUtil.isUpperCase((CharSequence)processedValue)) {
            String string2 = name.toUpperCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
        } else if (StringUtil.isLowerCase((CharSequence)processedValue)) {
            String string3 = name.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            Object[] objectArray = NameUtilCore.nameToWords((String)processedValue);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"nameToWords(...)");
            Object[] valueWords = objectArray;
            Object[] objectArray2 = NameUtilCore.nameToWords((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"nameToWords(...)");
            Object[] guessedNameWords = objectArray2;
            string = valueWords.length != guessedNameWords.length ? name : CollectionsKt.joinToString$default((Iterable)ArraysKt.zip((Object[])valueWords, (Object[])guessedNameWords), (CharSequence)"", null, null, (int)0, null, GoRenameTagProcessor::applyCaseStyleToValue$lambda$0, (int)30, null);
        }
        return string;
    }

    private static final CharSequence renameElement$lambda$0(GoRenameTagProcessor this$0, String $normalizedOldName, String $normalizedNewName, Pair entry) {
        String key = (String)entry.first;
        Object object = entry.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        char[] cArray = new char[]{','};
        String value2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)StringsKt.removeSurrounding((String)((String)object), (CharSequence)"\""), (char[])cArray, (boolean)false, (int)0, (int)6, null), (CharSequence)",", null, null, (int)0, null, arg_0 -> GoRenameTagProcessor.renameElement$lambda$0$0(this$0, $normalizedOldName, $normalizedNewName, arg_0), (int)30, null);
        return key + ":\"" + value2 + "\"";
    }

    private static final CharSequence renameElement$lambda$0$0(GoRenameTagProcessor this$0, String $normalizedOldName, String $normalizedNewName, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.updateTagValue(it, $normalizedOldName, $normalizedNewName);
    }

    private static final CharSequence applyCaseStyleToValue$lambda$0(kotlin.Pair pair) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String valueWord = (String)pair.component1();
        String guessedWord = (String)pair.component2();
        if (StringUtil.isUpperCase((CharSequence)valueWord)) {
            Intrinsics.checkNotNull((Object)guessedWord);
            String string = guessedWord.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            charSequence = string;
        } else if (StringUtil.isLowerCase((CharSequence)valueWord)) {
            Intrinsics.checkNotNull((Object)guessedWord);
            String string = guessedWord.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            charSequence = string;
        } else {
            Intrinsics.checkNotNull((Object)guessedWord);
            charSequence = guessedWord;
        }
        return charSequence;
    }
}

