/*
 * Decompiled with CFR 0.152.
 */
package com.goide.refactor.template;

import com.goide.codeInsight.imports.GoImport;
import com.goide.inspections.tag.GoTagUtil;
import com.goide.psi.GoAnonymousFieldDefinition;
import com.goide.psi.GoArrayOrSliceType;
import com.goide.psi.GoFieldDeclaration;
import com.goide.psi.GoFile;
import com.goide.psi.GoMapType;
import com.goide.psi.GoMethodDeclaration;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoParamDefinition;
import com.goide.psi.GoParameters;
import com.goide.psi.GoResult;
import com.goide.psi.GoSignature;
import com.goide.psi.GoStructType;
import com.goide.psi.GoTag;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeList;
import com.goide.psi.GoTypeOwner;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.psi.impl.fake.GoFakeTypeOwner;
import com.goide.refactor.GoNameSuggestionProvider;
import com.goide.refactor.template.CompositeTemplateEditingListener;
import com.goide.refactor.template.GoLookupExpression;
import com.goide.refactor.template.GoParameterNameExpression;
import com.goide.refactor.template.GoReceiverNameExpression;
import com.goide.refactor.template.GoReceiverTypeExpression;
import com.goide.refactor.util.GoRefactoringUtil;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInsight.lookup.LookupFocusDegree;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.macro.CompleteSmartMacro;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoTemplate {
    private static final String DEPENDANT = "_DEPENDANT";
    private static final String VARIABLE = "VARIABLE_";
    private final SmartPsiElementPointer<GoFile> myFilePointer;
    private final Set<GoImport> myPathsToImport;
    private final Template myTemplate;
    private final List<TemplateEditingListener> myListeners;
    private final Collection<String> myKnownTypeParameters;

    public GoTemplate(@NotNull GoFile file2) {
        if (file2 == null) {
            GoTemplate.$$$reportNull$$$0(0);
        }
        this.myPathsToImport = new HashSet<GoImport>();
        this.myListeners = new SmartList();
        this.myKnownTypeParameters = new HashSet<String>();
        this.myTemplate = new TemplateImpl("", "");
        this.myFilePointer = SmartPointerManager.createPointer((PsiElement)file2);
        this.myTemplate.setToReformat(true);
        this.myTemplate.setToIndent(false);
    }

    public void setupStruct(@NotNull GoStructType struct) {
        if (struct == null) {
            GoTemplate.$$$reportNull$$$0(1);
        }
        this.setupStruct(struct, true, true);
    }

    public void setupStruct(@NotNull GoStructType struct, boolean addBody, boolean addFieldDefinitions) {
        if (struct == null) {
            GoTemplate.$$$reportNull$$$0(2);
        }
        this.addTextSegment("struct");
        List<GoFieldDeclaration> declarationList = struct.getFieldDeclarationList();
        if (!declarationList.isEmpty()) {
            this.addWhiteSpace();
        }
        SmartList names = new SmartList();
        this.braces(() -> this.lambda$setupStruct$3(declarationList, (List)names, struct));
        if (!addBody) {
            return;
        }
        this.braces(() -> this.lambda$setupStruct$5(struct, addFieldDefinitions, (List)names));
    }

    public void setupStructWithImplicitType(@NotNull GoStructType struct) {
        if (struct == null) {
            GoTemplate.$$$reportNull$$$0(3);
        }
        this.braces(() -> {
            List fieldNames = ContainerUtil.mapNotNull(struct.getFieldDefinitions(), it -> it.getName());
            this.joinWithComma(fieldNames, fieldName -> {
                this.addTextSegment(fieldName + ":");
                this.addVariableWithSmartCompletion();
            });
        });
    }

    public void setupSignature(@NotNull GoSignature signature, boolean stopAtType, boolean exposePrivateTypes) {
        GoParameters resultParameters;
        if (signature == null) {
            GoTemplate.$$$reportNull$$$0(4);
        }
        GoParameters parameters = signature.getParameters();
        this.setupParameters(parameters, true, stopAtType, true, exposePrivateTypes);
        GoResult result = signature.getResult();
        if (result == null) {
            return;
        }
        this.addWhiteSpace();
        GoType type = result.getType();
        if (type != null) {
            this.setupFunctionResult(type, stopAtType, exposePrivateTypes);
        }
        if ((resultParameters = result.getParameters()) != null) {
            this.setupResultParameters(resultParameters, stopAtType, exposePrivateTypes);
        }
    }

    public void setupMethodReceiver(@NotNull GoTypeOwner receiver) {
        if (receiver == null) {
            GoTemplate.$$$reportNull$$$0(5);
        }
        this.parens(() -> {
            GoTypeSpec typeSpecFromReceiver = GoPsiImplUtil.getTypeSpecFromReceiver(receiver);
            LinkedHashSet<String> suggestedNames = GoNameSuggestionProvider.getSuggestedNamesForReceiver(receiver, this.myFilePointer.getElement());
            this.myTemplate.addVariable((Expression)new GoReceiverNameExpression(typeSpecFromReceiver, suggestedNames), true);
            this.addWhiteSpace();
            this.myTemplate.addVariable((Expression)new GoReceiverTypeExpression(typeSpecFromReceiver, false), true);
        });
    }

    public void setupMethodReceiver(@Nullable GoTypeSpec typeSpec, @NotNull String receiverNameVariable, @NotNull String receiverTypeVariable, boolean pointerOnly) {
        if (receiverNameVariable == null) {
            GoTemplate.$$$reportNull$$$0(6);
        }
        if (receiverTypeVariable == null) {
            GoTemplate.$$$reportNull$$$0(7);
        }
        this.parens(() -> {
            GoMethodDeclaration method = typeSpec != null ? (GoMethodDeclaration)ContainerUtil.getFirstItem(typeSpec.getMethods()) : null;
            Set<String> suggestedNames = method != null ? GoNameSuggestionProvider.getSuggestedNames(Objects.requireNonNull(method.getReceiver()), this.myFilePointer.getElement()) : Collections.singleton(GoTemplate.receiverName(typeSpec));
            this.myTemplate.addVariable(receiverNameVariable, (Expression)new GoReceiverNameExpression(typeSpec, suggestedNames), true);
            this.addWhiteSpace();
            this.myTemplate.addVariable(receiverTypeVariable, (Expression)new GoReceiverTypeExpression(typeSpec, pointerOnly), true);
        });
    }

    public void setupSecondaryMethodReceiver(@NotNull String receiverNameVariable, @NotNull String receiverTypeVariable) {
        if (receiverNameVariable == null) {
            GoTemplate.$$$reportNull$$$0(8);
        }
        if (receiverTypeVariable == null) {
            GoTemplate.$$$reportNull$$$0(9);
        }
        this.parens(() -> {
            this.addVariableSegment(receiverNameVariable);
            this.addWhiteSpace();
            this.addVariableSegment(receiverTypeVariable);
        });
    }

    @NotNull
    private static String receiverName(@Nullable GoTypeSpec typeSpec) {
        String typeName = typeSpec != null ? typeSpec.getName() : "";
        String string = StringUtil.isEmpty((String)typeName) ? "r" : String.valueOf(StringUtil.decapitalize((String)typeName).charAt(0));
        if (string == null) {
            GoTemplate.$$$reportNull$$$0(10);
        }
        return string;
    }

    public void setupFunctionResult(@Nullable GoType type, boolean stopAt, boolean exposePrivateTypes) {
        this.setupFunctionResult(GoTypeUtil.getListOfTypesFromTypeList(type), stopAt, exposePrivateTypes);
    }

    public void setupFunctionResult(@NotNull List<GoType> typeList, boolean stopAt, boolean exposePrivateTypes) {
        if (typeList == null) {
            GoTemplate.$$$reportNull$$$0(11);
        }
        if (typeList.size() > 1) {
            this.parens(() -> this.joinWithComma(typeList, type -> TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withStopAt(stopAt).withExposePrivateTypes(exposePrivateTypes).build((GoType)type)));
            return;
        }
        GoType type = (GoType)ContainerUtil.getFirstItem(typeList);
        if (type != null && !(type instanceof GoLightType.LightVoidType)) {
            TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withStopAt(stopAt).withExposePrivateTypes(exposePrivateTypes).build(type);
        }
    }

    public void setupParameters(@NotNull List<? extends GoTypeOwner> args, boolean argsListHasTripleDot) {
        GoTypeOwner firstItem;
        GoType type;
        if (args == null) {
            GoTemplate.$$$reportNull$$$0(12);
        }
        if (args.size() == 1 && (type = (firstItem = args.get(0)).getGoType(null)) instanceof GoTypeList) {
            this.parens(() -> this.joinWithComma(((GoTypeList)type).getTypeList(), t -> {
                this.addVariableWithSuggestionNames(firstItem);
                this.addWhiteSpace();
                TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withStopAt(true).build((GoType)t);
            }));
            return;
        }
        GoTypeOwner lastArg = (GoTypeOwner)ContainerUtil.getLastItem(args);
        this.parens(() -> this.joinWithComma(args, typeOwner -> {
            this.addVariableWithSuggestionNames((GoTypeOwner)typeOwner);
            this.addWhiteSpace();
            boolean variadic = argsListHasTripleDot && typeOwner == lastArg;
            TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withStopAt(true).withVariadic(variadic).build(typeOwner.getGoType(null));
        }));
    }

    public void setupParameters(@NotNull Iterable<GoNamedElement> parameters) {
        if (parameters == null) {
            GoTemplate.$$$reportNull$$$0(13);
        }
        this.parens(() -> this.joinWithComma(parameters, param -> {
            this.addTextSegment(StringUtil.notNullize((String)param.getName()));
            this.addWhiteSpace();
            TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).build(param.getGoType(null));
        }));
    }

    public void setupBracesWithEndVariableBetween() {
        this.setupBracesWithEndVariableBetween(true);
    }

    public void setupBracesWithEndVariableBetween(boolean addNewLine) {
        this.braces(() -> {
            if (addNewLine) {
                this.wrapWithNewLines(this::addEndVariable);
            } else {
                this.addEndVariable();
            }
        });
    }

    public void setupResultParameters(@NotNull GoParameters resultParameters, boolean stopAtType, boolean exposePrivateTypes) {
        if (resultParameters == null) {
            GoTemplate.$$$reportNull$$$0(14);
        }
        this.setupParameters(resultParameters, false, stopAtType, false, exposePrivateTypes);
    }

    private void setupParameters(@NotNull GoParameters parameters, boolean parensRequired, boolean stopAtType, boolean generateMissingNames, boolean exposePrivateTypes) {
        if (parameters == null) {
            GoTemplate.$$$reportNull$$$0(15);
        }
        this.parens(() -> this.joinWithComma(parameters.getParameterDeclarationList(), declaration -> {
            List<GoParamDefinition> paramDefinitionList = declaration.getParamDefinitionList();
            GoType declarationType = GoTypeUtil.getInterfaceIfNull(declaration.getType(), parameters);
            if (!paramDefinitionList.isEmpty()) {
                this.joinWithComma(paramDefinitionList, this::addVariable);
            } else if (generateMissingNames) {
                GoFakeTypeOwner typeOwner = new GoFakeTypeOwner(declaration.getManager(), declarationType, declaration.getContainingFile());
                this.myTemplate.addVariable(this.createParameterNameSuggestedExpression(typeOwner), true);
            }
            this.addWhiteSpace();
            TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withExposePrivateTypes(exposePrivateTypes).withVariadic(declaration.isVariadic()).withStopAt(stopAtType).build(declarationType);
        }), parensRequired || !parameters.getParameterDeclarationList().isEmpty());
    }

    public void setupMapLiteral(@NotNull GoMapType mapType) {
        if (mapType == null) {
            GoTemplate.$$$reportNull$$$0(16);
        }
        this.setupMapLiteral(mapType, true);
    }

    public void setupMapLiteral(@NotNull GoMapType mapType, boolean addBracesAfter) {
        if (mapType == null) {
            GoTemplate.$$$reportNull$$$0(17);
        }
        this.addTextSegment("map[");
        TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).build(mapType.getKeyType());
        this.addTextSegment("]");
        TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).build(mapType.getValueType());
        if (!addBracesAfter) {
            return;
        }
        this.addTextSegment("{");
        this.addEndVariable();
        this.addTextSegment("}");
    }

    public void setupArrayOrSliceLiteral(@NotNull GoArrayOrSliceType type) {
        if (type == null) {
            GoTemplate.$$$reportNull$$$0(18);
        }
        this.setupArrayOrSliceLiteral(type, true);
    }

    public void setupArrayOrSliceLiteral(@NotNull GoArrayOrSliceType type, boolean addBracesAfter) {
        if (type == null) {
            GoTemplate.$$$reportNull$$$0(19);
        }
        this.addTextSegment("[");
        int length = type.getLength();
        if (length != -1) {
            this.addTextSegment(String.valueOf(type.getLength()));
        }
        this.addTextSegment("]");
        TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).build(type.getType());
        if (!addBracesAfter) {
            return;
        }
        this.addTextSegment("{");
        this.addEndVariable();
        this.addTextSegment("}");
    }

    private void setupFieldDeclaration(@NotNull GoFieldDeclaration declaration, @NotNull List<String> names, int structureHash) {
        GoAnonymousFieldDefinition anon;
        GoTag tag;
        if (declaration == null) {
            GoTemplate.$$$reportNull$$$0(20);
        }
        if (names == null) {
            GoTemplate.$$$reportNull$$$0(21);
        }
        this.joinWithComma(declaration.getFieldDefinitionList(), definition -> this.addPrimaryVariable(names, definition.getText(), structureHash));
        GoType type = declaration.getType();
        if (type != null) {
            this.addWhiteSpace();
            TypeVariableBuilder.create(this).withCanBeEmptyInterface(true).withStopAt(true).build(type);
        }
        if ((tag = declaration.getTag()) != null) {
            List<String> keys = GoTagUtil.getKeys(tag);
            this.addWhiteSpace();
            this.addTextSegment("`");
            for (int i = 0; i < keys.size(); ++i) {
                String key = keys.get(i);
                String value2 = tag.getValue(key);
                if (value2 == null) continue;
                this.addPrimaryVariable("KEY_" + structureHash + i, (Expression)new ConstantNode(key));
                this.addTextSegment(":\"");
                this.addVariable(value2);
                this.addTextSegment("\"");
                if (i >= keys.size() - 1) continue;
                this.addWhiteSpace();
            }
            this.addTextSegment("`");
        }
        if ((anon = declaration.getAnonymousFieldDefinition()) != null) {
            GoFile dereferencedFile = Objects.requireNonNull((GoFile)this.myFilePointer.getElement());
            GoRefactoringUtil.TypeTextWithImports typeTextWithImports = GoRefactoringUtil.getTypeTextWithImports(dereferencedFile, anon.getType());
            this.myPathsToImport.addAll(typeTextWithImports.imports);
            this.addPrimaryVariable(names, typeTextWithImports.typeText, structureHash);
        }
    }

    private void addPrimaryVariable(@NotNull List<String> names, @NotNull String expressionText, int prefix) {
        if (names == null) {
            GoTemplate.$$$reportNull$$$0(22);
        }
        if (expressionText == null) {
            GoTemplate.$$$reportNull$$$0(23);
        }
        ConstantNode expression = new ConstantNode(expressionText);
        String name = VARIABLE + prefix + "_" + names.size();
        names.add(name);
        this.addPrimaryVariable(name, (Expression)expression);
    }

    public void addSecondaryVariable(@NotNull String primaryVariableName) {
        if (primaryVariableName == null) {
            GoTemplate.$$$reportNull$$$0(24);
        }
        this.addSecondaryVariable((List<String>)new SmartList((Object)primaryVariableName));
    }

    private void addSecondaryVariable(@NotNull List<String> names) {
        if (names == null) {
            GoTemplate.$$$reportNull$$$0(25);
        }
        String name = !names.isEmpty() ? names.remove(0) : "";
        String dependantName = name + DEPENDANT;
        this.addVariableSegment(dependantName);
        this.addDependantVariable(dependantName, name);
    }

    @NotNull
    private Expression createParameterNameSuggestedExpression(@NotNull GoTypeOwner o) {
        if (o == null) {
            GoTemplate.$$$reportNull$$$0(26);
        }
        return new GoParameterNameExpression(GoNameSuggestionProvider.getSuggestedNames(o, this.myFilePointer.getElement()));
    }

    public void addWhiteSpace() {
        this.addTextSegment(" ");
    }

    private void addVariableWithSmartCompletion() {
        this.myTemplate.addVariable((Expression)new MacroCallNode((Macro)new CompleteSmartMacro()), true);
    }

    private void addVariable(@NotNull PsiElement element) {
        if (element == null) {
            GoTemplate.$$$reportNull$$$0(27);
        }
        this.addVariable(element.getText());
    }

    private void addVariable(@NotNull String text) {
        if (text == null) {
            GoTemplate.$$$reportNull$$$0(28);
        }
        this.addVariable(text, true);
    }

    public void addVariable(@NonNls @NotNull String text, boolean at) {
        if (text == null) {
            GoTemplate.$$$reportNull$$$0(29);
        }
        this.myTemplate.addVariable((Expression)new ConstantNode(text), at);
    }

    public void addVariable(@NonNls @NotNull String name, @Nullable Expression expression, boolean at) {
        if (name == null) {
            GoTemplate.$$$reportNull$$$0(30);
        }
        this.myTemplate.addVariable(name, expression, expression, at);
    }

    private boolean trySetupTypeAsContainerOrTypeParameter(@Nullable GoType type, boolean addBracesAfter) {
        if (type instanceof GoMapType) {
            this.setupMapLiteral((GoMapType)type, addBracesAfter);
            return true;
        }
        if (type instanceof GoStructType) {
            this.setupStruct((GoStructType)type, addBracesAfter, false);
            return true;
        }
        if (type instanceof GoArrayOrSliceType) {
            this.setupArrayOrSliceLiteral((GoArrayOrSliceType)type, addBracesAfter);
            return true;
        }
        if (GoTypeUtil.isTypeParameter(type, null)) {
            String typeText = type.getText();
            if (this.myKnownTypeParameters.contains(typeText)) {
                this.myTemplate.addVariableSegment(typeText);
            } else {
                this.myTemplate.addVariable(typeText, (Expression)new GoLookupExpression(Set.of(typeText), LookupFocusDegree.SEMI_FOCUSED), true);
                this.myKnownTypeParameters.add(typeText);
            }
            return true;
        }
        return false;
    }

    public void addEmptyCompositeLiteral(@NotNull GoType type, boolean stopAt, boolean multiline, boolean canBeEmptyInterface) {
        if (type == null) {
            GoTemplate.$$$reportNull$$$0(31);
        }
        TypeVariableBuilder.create(this).withStopAt(stopAt).withMultiline(multiline).withCanBeEmptyInterface(canBeEmptyInterface).withAddBracesAfter(true).build(type);
    }

    private void addVariableWithSuggestionNames(@NotNull GoTypeOwner e) {
        if (e == null) {
            GoTemplate.$$$reportNull$$$0(32);
        }
        this.myTemplate.addVariable(this.createParameterNameSuggestedExpression(e), true);
    }

    public void addPrimaryVariable(@NotNull String name) {
        if (name == null) {
            GoTemplate.$$$reportNull$$$0(33);
        }
        this.addPrimaryVariable(name, null);
    }

    public void addPrimaryVariable(@NonNls @NotNull String name, @Nullable Expression expression) {
        if (name == null) {
            GoTemplate.$$$reportNull$$$0(34);
        }
        this.myTemplate.addVariable(name, expression, expression, true);
    }

    public void addDependantVariable(@NotNull String name, @NotNull String primaryVariableName) {
        if (name == null) {
            GoTemplate.$$$reportNull$$$0(35);
        }
        if (primaryVariableName == null) {
            GoTemplate.$$$reportNull$$$0(36);
        }
        this.myTemplate.addVariable(name, primaryVariableName, primaryVariableName, false);
    }

    private <T> void joinWithComma(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<? super T> consumer) {
        if (iterable == null) {
            GoTemplate.$$$reportNull$$$0(37);
        }
        if (consumer == null) {
            GoTemplate.$$$reportNull$$$0(38);
        }
        this.join(iterable, consumer, ", ");
    }

    private <T> void join(@NotNull Iterable<? extends T> iterable, @NotNull Consumer<? super T> consumer, @NotNull String separator) {
        if (iterable == null) {
            GoTemplate.$$$reportNull$$$0(39);
        }
        if (consumer == null) {
            GoTemplate.$$$reportNull$$$0(40);
        }
        if (separator == null) {
            GoTemplate.$$$reportNull$$$0(41);
        }
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            consumer.accept(iterator.next());
            if (!iterator.hasNext()) continue;
            this.addTextSegment(separator);
        }
    }

    private void braces(@NotNull Runnable r) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(42);
        }
        this.wrap(r, "{", "}");
    }

    private void parens(@NotNull Runnable r, boolean parensRequired) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(43);
        }
        if (parensRequired) {
            this.wrap(r, "(", ")");
        } else {
            r.run();
        }
    }

    private void parens(@NotNull Runnable r) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(44);
        }
        this.parens(r, true);
    }

    private void wrapWithNewLines(@NotNull Runnable r) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(45);
        }
        this.wrap(r, "\n", "\n");
    }

    private void wrapWithWhiteSpaces(@NotNull Runnable r) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(46);
        }
        this.wrap(r, " ", " ");
    }

    private void wrap(@NotNull Runnable r, @NotNull String left, @NotNull String right) {
        if (r == null) {
            GoTemplate.$$$reportNull$$$0(47);
        }
        if (left == null) {
            GoTemplate.$$$reportNull$$$0(48);
        }
        if (right == null) {
            GoTemplate.$$$reportNull$$$0(49);
        }
        this.addTextSegment(left);
        r.run();
        this.addTextSegment(right);
    }

    public void addTextSegment(@NonNls @NotNull String text) {
        if (text == null) {
            GoTemplate.$$$reportNull$$$0(50);
        }
        this.myTemplate.addTextSegment(text);
    }

    public void addVariableSegment(@NotNull String name) {
        if (name == null) {
            GoTemplate.$$$reportNull$$$0(51);
        }
        this.myTemplate.addVariableSegment(name);
    }

    public void addSelectionStartVariable() {
        this.myTemplate.addSelectionStartVariable();
    }

    public void addSelectionEndVariable() {
        this.myTemplate.addSelectionEndVariable();
    }

    public void addEndVariable() {
        this.myTemplate.addEndVariable();
    }

    public void addImports(Collection<GoImport> imports) {
        this.myPathsToImport.addAll(imports);
    }

    @NotNull
    public SmartPsiElementPointer<GoFile> getFilePointer() {
        SmartPsiElementPointer<GoFile> smartPsiElementPointer = this.myFilePointer;
        if (smartPsiElementPointer == null) {
            GoTemplate.$$$reportNull$$$0(52);
        }
        return smartPsiElementPointer;
    }

    @NotNull
    public Template getTemplate() {
        Template template = this.myTemplate;
        if (template == null) {
            GoTemplate.$$$reportNull$$$0(53);
        }
        return template;
    }

    public void addListener(@NotNull TemplateEditingListener listener2) {
        if (listener2 == null) {
            GoTemplate.$$$reportNull$$$0(54);
        }
        this.myListeners.add(listener2);
    }

    public void startTemplate(@NotNull Editor editor, int offset, @NotNull @Nls String commandName, @Nullable TextRange rangeToRemove) {
        if (editor == null) {
            GoTemplate.$$$reportNull$$$0(55);
        }
        if (commandName == null) {
            GoTemplate.$$$reportNull$$$0(56);
        }
        this.startTemplate(editor, offset, commandName, rangeToRemove, this.myPathsToImport);
    }

    public void startTemplate(final @NotNull Editor editor, int offset, @Nullable @Nls String commandName, @Nullable TextRange rangeToRemove, final @Nullable Set<GoImport> imports) {
        Project project;
        if (editor == null) {
            GoTemplate.$$$reportNull$$$0(57);
        }
        if ((project = this.myFilePointer.getProject()).isDisposed() || editor.isDisposed()) {
            return;
        }
        Runnable runnable = () -> {
            editor.getCaretModel().moveToOffset(offset);
            IntentionPreviewUtils.write(() -> {
                if (rangeToRemove != null) {
                    editor.getDocument().deleteString(rangeToRemove.getStartOffset(), rangeToRemove.getEndOffset());
                }
            });
            CompositeTemplateEditingListener compositeListener = new CompositeTemplateEditingListener();
            this.myListeners.forEach(compositeListener::addListener);
            if (!ContainerUtil.isEmpty((Collection)imports) && GoTemplate.shouldAddImports(project)) {
                compositeListener.addListener((TemplateEditingListener)new TemplateEditingAdapter(){

                    public void templateFinished(@NotNull Template template, boolean brokenOff) {
                        GoFile dereferencedFile;
                        if (template == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if ((dereferencedFile = (GoFile)GoTemplate.this.myFilePointer.getElement()) == null || !dereferencedFile.isValid()) {
                            return;
                        }
                        if (ApplicationManager.getApplication().isUnitTestMode()) {
                            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        }
                        IntentionPreviewUtils.write(() -> GoRefactoringUtil.runUndoTransparentActionPreviewAware(() -> GoRefactoringUtil.addImports(Objects.requireNonNull((GoFile)GoTemplate.this.myFilePointer.getElement()), imports)));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/goide/refactor/template/GoTemplate$1", "templateFinished"));
                    }
                });
            }
            TemplateManager.getInstance((Project)project).startTemplate(editor, this.getTemplate(), (TemplateEditingListener)compositeListener);
        };
        if (IntentionPreviewUtils.isIntentionPreviewActive()) {
            runnable.run();
        } else {
            CommandProcessor.getInstance().executeCommand(project, runnable, commandName, null, editor.getDocument());
        }
    }

    private static boolean shouldAddImports(Project project) {
        boolean isPreviewActive = IntentionPreviewUtils.isIntentionPreviewActive();
        boolean isTestModeOn = ((TemplateManagerImpl)TemplateManager.getInstance((Project)project)).shouldSkipInTests();
        return !isPreviewActive || isTestModeOn;
    }

    private /* synthetic */ void lambda$setupStruct$5(GoStructType struct, boolean addFieldDefinitions, List names) {
        List<GoNamedElement> definitions = struct.getFieldDefinitions();
        if (definitions.isEmpty() || !addFieldDefinitions) {
            return;
        }
        this.joinWithComma(definitions, field -> {
            this.addSecondaryVariable(names);
            this.addTextSegment(": ");
            this.addVariableWithSmartCompletion();
        });
    }

    private /* synthetic */ void lambda$setupStruct$3(List declarationList, List names, GoStructType struct) {
        if (declarationList.size() > 1) {
            this.wrapWithNewLines(() -> this.join(declarationList, e -> this.setupFieldDeclaration((GoFieldDeclaration)e, names, struct.hashCode()), "\n"));
        } else if (declarationList.size() == 1) {
            this.wrapWithWhiteSpaces(() -> this.setupFieldDeclaration((GoFieldDeclaration)declarationList.get(0), names, struct.hashCode()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 52, 53 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "struct";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiver";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverNameVariable";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverTypeVariable";
                break;
            }
            case 10: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/refactor/template/GoTemplate";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeList";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapType";
                break;
            }
            case 18: 
            case 19: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 21: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionText";
                break;
            }
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "primaryVariableName";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 28: 
            case 29: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 37: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "left";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "right";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 55: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/refactor/template/GoTemplate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "receiverName";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePointer";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupStruct";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupStructWithImplicitType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupSignature";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setupMethodReceiver";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setupSecondaryMethodReceiver";
                break;
            }
            case 10: 
            case 52: 
            case 53: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setupFunctionResult";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setupParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setupResultParameters";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setupMapLiteral";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setupArrayOrSliceLiteral";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setupFieldDeclaration";
                break;
            }
            case 22: 
            case 23: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addPrimaryVariable";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addSecondaryVariable";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createParameterNameSuggestedExpression";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addVariable";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "addEmptyCompositeLiteral";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addVariableWithSuggestionNames";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addDependantVariable";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "joinWithComma";
                break;
            }
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "braces";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "parens";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithNewLines";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithWhiteSpaces";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "wrap";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addTextSegment";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addVariableSegment";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "startTemplate";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 52, 53 -> new IllegalStateException(string);
        };
    }

    public static class TypeVariableBuilder {
        private final GoTemplate myTemplate;
        private boolean myStopAt;
        private boolean myMultiline;
        private boolean myCanBeEmptyInterface;
        private boolean myAddBracesAfter;
        private boolean myExposePrivateTypes;
        private boolean myVariadic;

        private TypeVariableBuilder(@NotNull GoTemplate template) {
            if (template == null) {
                TypeVariableBuilder.$$$reportNull$$$0(0);
            }
            this.myStopAt = false;
            this.myMultiline = false;
            this.myCanBeEmptyInterface = false;
            this.myAddBracesAfter = false;
            this.myExposePrivateTypes = false;
            this.myVariadic = false;
            this.myTemplate = template;
        }

        @NotNull
        public static TypeVariableBuilder create(@NotNull GoTemplate template) {
            if (template == null) {
                TypeVariableBuilder.$$$reportNull$$$0(1);
            }
            return new TypeVariableBuilder(template);
        }

        public TypeVariableBuilder withStopAt(boolean stopAt) {
            this.myStopAt = stopAt;
            return this;
        }

        public TypeVariableBuilder withMultiline(boolean multiline) {
            this.myMultiline = multiline;
            return this;
        }

        public TypeVariableBuilder withCanBeEmptyInterface(boolean canBeEmptyInterface) {
            this.myCanBeEmptyInterface = canBeEmptyInterface;
            return this;
        }

        public TypeVariableBuilder withAddBracesAfter(boolean addBracesAfter) {
            this.myAddBracesAfter = addBracesAfter;
            return this;
        }

        public TypeVariableBuilder withExposePrivateTypes(boolean exposePrivateTypes) {
            this.myExposePrivateTypes = exposePrivateTypes;
            return this;
        }

        public TypeVariableBuilder withVariadic(boolean variadic) {
            this.myVariadic = variadic;
            return this;
        }

        public void build(@Nullable GoType type) {
            if (this.myVariadic) {
                type = GoTypeUtil.unwrapVariadicArrayOrSliceType(type, true);
                this.myAddBracesAfter = false;
            }
            if (this.myTemplate.trySetupTypeAsContainerOrTypeParameter(type, this.myAddBracesAfter)) {
                return;
            }
            GoFile dereferencedFile = Objects.requireNonNull((GoFile)this.myTemplate.getFilePointer().getElement());
            GoRefactoringUtil.TypeTextWithImports typeTextWithImports = GoRefactoringUtil.getTypeTextWithImports(dereferencedFile, type, this.myMultiline, this.myExposePrivateTypes);
            if (StringUtil.isEmpty((String)typeTextWithImports.typeText) || !this.myCanBeEmptyInterface && "interface{}".equals(typeTextWithImports.typeText)) {
                this.myTemplate.addVariable("", this.myStopAt);
                return;
            }
            String prefix = this.myVariadic ? "..." : "";
            String suffix = this.myAddBracesAfter ? "{}" : "";
            this.myTemplate.addVariable(prefix + typeTextWithImports.typeText + suffix, this.myStopAt);
            this.myTemplate.addImports(typeTextWithImports.imports);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "template";
            objectArray2[1] = "com/goide/refactor/template/GoTemplate$TypeVariableBuilder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "create";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

