/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.combobox;

import com.goide.configuration.ColoredListCellRendererWithProgressIcon;
import com.goide.configuration.GoUIUtil;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoBasedSdk;
import com.goide.sdk.GoSdkUtil;
import com.goide.sdk.combobox.GoSdkActionsProvider;
import com.goide.sdk.combobox.GoSdkListProvider;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.ComboboxWithBrowseButton;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GoBasedSdkChooserCombo<Sdk extends GoBasedSdk>
extends ComboboxWithBrowseButton {
    private final List<ActionListener> myChangedListeners;
    private final Set<String> mySdkUrls;
    private final List<Sdk> mySdks;
    private final AsyncProcessIcon myAsyncProcessIcon;
    @NotNull
    private final Validator<Sdk> myValidator;
    @NotNull
    private final GoSdkListProvider<Sdk> mySdkListProvider;
    @NotNull
    private final GoSdkActionsProvider<Sdk> mySdkActionsProvider;
    @NotNull
    private final JButton myAddSdkBigButton;
    @NotNull
    private final Sdk myNullSdk;
    private volatile boolean isDisposed;

    public void dispose() {
        super.dispose();
        this.isDisposed = true;
        this.myChangedListeners.clear();
        JComboBox comboBox = this.getComboBox();
        UIUtil.dispose((Component)this.myAddSdkBigButton);
        for (ActionListener listener2 : comboBox.getActionListeners()) {
            comboBox.removeActionListener(listener2);
        }
    }

    public GoBasedSdkChooserCombo(@NotNull Validator<Sdk> validator, @NotNull GoSdkListProvider<Sdk> sdkListProvider, @NotNull GoSdkActionsProvider<Sdk> sdkActionsProvider, @NotNull Sdk nullSdk, Sdk ... additionalSdks) {
        if (validator == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(0);
        }
        if (sdkListProvider == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(1);
        }
        if (sdkActionsProvider == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(2);
        }
        if (nullSdk == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(3);
        }
        super((JComboBox)new ComboBox());
        this.myChangedListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.mySdkUrls = new HashSet<String>();
        this.mySdks = new ArrayList<Sdk>();
        this.myAddSdkBigButton = new JButton(GoBundle.message((String)"go.settings.sdk.add.button", (Object[])new Object[0]));
        this.myValidator = validator;
        this.mySdkListProvider = sdkListProvider;
        this.mySdkActionsProvider = sdkActionsProvider;
        this.myAsyncProcessIcon = GoUIUtil.createProcessIcon("Go SDK", (Disposable)this, () -> this.repaint());
        this.myNullSdk = nullSdk;
        this.initUi();
        ComboBox comboBox = (ComboBox)this.getComboBox();
        comboBox.setModel((ComboBoxModel)new CollectionComboBoxModel(this.mySdks));
        boolean selectAddedSdk = true;
        for (Sdk sdk : additionalSdks) {
            this.addSdk(sdk, selectAddedSdk);
            selectAddedSdk = false;
        }
        for (GoBasedSdk sdk : this.mySdkListProvider.getAllKnownSdks()) {
            if (this.myValidator.validate(sdk).isOk()) {
                this.addSdk(sdk, selectAddedSdk);
                selectAddedSdk = false;
                continue;
            }
            this.addSdk(sdk, false);
        }
        this.addSdk(this.myNullSdk, selectAddedSdk);
        comboBox.setRenderer((ListCellRenderer)((Object)new GoSdkRenderer()));
        this.addActionListener(e -> {
            this.showOptions((Component)this.getButton());
            this.notifyChanged(e);
        });
        this.myAddSdkBigButton.addActionListener(e -> {
            this.showOptions(this.myAddSdkBigButton);
            this.notifyChanged(e);
        });
        comboBox.addActionListener(e -> {
            this.notifyChanged(e);
            this.updateTooltip();
        });
        this.updateTooltip();
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            boolean finalSelectAddedSdk = selectAddedSdk;
            this.onComponentShown(() -> this.discoverSdks(finalSelectAddedSdk));
        }
    }

    private void initUi() {
        this.add(this.myAddSdkBigButton, "West");
        this.myAddSdkBigButton.setToolTipText(GoBundle.message((String)"go.settings.sdk.combo.tooltip", (Object[])new Object[0]));
        this.getButton().setToolTipText(GoBundle.message((String)"go.settings.sdk.add.button.tooltip", (Object[])new Object[]{this.getButton().getToolTipText()}));
        this.setButtonIcon(AllIcons.General.Add);
        this.hideComboBox();
    }

    private void hideComboBox() {
        this.getComboBox().setVisible(false);
        this.getButton().setVisible(false);
        this.myAddSdkBigButton.setVisible(true);
    }

    public void showComboBox() {
        this.getComboBox().setVisible(true);
        this.getButton().setVisible(true);
        this.myAddSdkBigButton.setVisible(false);
    }

    private void onComponentShown(final @NotNull Runnable runnable) {
        if (runnable == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(4);
        }
        if (this.isShowing()) {
            runnable.run();
            return;
        }
        this.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L && GoBasedSdkChooserCombo.this.isShowing()) {
                    GoBasedSdkChooserCombo.this.removeHierarchyListener(this);
                    runnable.run();
                }
            }
        });
    }

    private void discoverSdks(final boolean selectFirstAddedSdk) {
        new Task.Backgroundable(null, GoBundle.message((String)"go.settings.sdk.discovering.go.sdks.progress.title", (Object[])new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (GoBasedSdkChooserCombo.this.isDisposed) {
                    return;
                }
                boolean firstSdk = true;
                for (GoBasedSdk sdk : GoBasedSdkChooserCombo.this.mySdkListProvider.discoverSdks()) {
                    if (GoBasedSdkChooserCombo.this.myValidator.validate(sdk).isOk()) {
                        GoBasedSdkChooserCombo.this.addSdk(sdk, firstSdk && selectFirstAddedSdk);
                        firstSdk = false;
                        continue;
                    }
                    GoBasedSdkChooserCombo.this.addSdk(sdk, false);
                }
                Disposer.dispose((Disposable)GoBasedSdkChooserCombo.this.myAsyncProcessIcon);
                if (GoBasedSdkChooserCombo.this.isVisible()) {
                    ((CollectionComboBoxModel)GoBasedSdkChooserCombo.this.getComboBox().getModel()).update();
                    ApplicationManager.getApplication().invokeLater(() -> GoBasedSdkChooserCombo.this.repaint());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/goide/sdk/combobox/GoBasedSdkChooserCombo$2", "run"));
            }
        }.queue();
    }

    @NotNull
    public Sdk getSdk() {
        Object selectedItem = this.getComboBox().getSelectedItem();
        GoBasedSdk goBasedSdk = selectedItem instanceof GoBasedSdk ? (GoBasedSdk)selectedItem : this.myNullSdk;
        if (goBasedSdk == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(5);
        }
        return (Sdk)goBasedSdk;
    }

    private void updateTooltip() {
        Object item = this.getComboBox().getSelectedItem();
        this.getComboBox().setToolTipText(item instanceof GoBasedSdk ? VfsUtilCore.urlToPath((String)((GoBasedSdk)item).getHomeUrl()) : null);
    }

    private void showOptions(@NotNull Component sourceComponent) {
        if (sourceComponent == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(6);
        }
        DefaultActionGroup group = new DefaultActionGroup(this.mySdkActionsProvider.createSdkActions(this));
        DataContext dataContext = DataManager.getInstance().getDataContext(sourceComponent);
        JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.MNEMONICS, false).showUnderneathOf(sourceComponent);
    }

    @NotNull
    public Validator<Sdk> getValidator() {
        Validator<Sdk> validator = this.myValidator;
        if (validator == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(7);
        }
        return validator;
    }

    public synchronized void addSdk(@NotNull Sdk newSdk, boolean selectAddedSdk) {
        if (newSdk == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(8);
        }
        JComboBox comboBox = this.getComboBox();
        if (!this.mySdkUrls.contains(newSdk.getHomeUrl())) {
            this.mySdks.add(newSdk);
            this.mySdkUrls.add(newSdk.getHomeUrl());
            Collections.sort(this.mySdks, (sdk1, sdk2) -> -GoSdkUtil.compareVersions(sdk1 != null ? sdk1.getVersion() : null, sdk2 != null ? sdk2.getVersion() : null));
            if (selectAddedSdk) {
                ((CollectionComboBoxModel)comboBox.getModel()).update();
                UIUtil.invokeLaterIfNeeded(() -> comboBox.setSelectedItem(newSdk));
            }
        } else if (selectAddedSdk) {
            UIUtil.invokeLaterIfNeeded(() -> comboBox.setSelectedItem(newSdk));
        }
        if (newSdk != this.myNullSdk) {
            UIUtil.invokeLaterIfNeeded(() -> this.showComboBox());
        }
    }

    private void notifyChanged(ActionEvent e) {
        for (ActionListener changedListener : this.myChangedListeners) {
            changedListener.actionPerformed(e);
        }
    }

    public void addChangedListener(@NotNull ActionListener listener2) {
        if (listener2 == null) {
            GoBasedSdkChooserCombo.$$$reportNull$$$0(9);
        }
        this.myChangedListeners.add(listener2);
    }

    public void selectSdkByUrl(@Nullable String url) {
        ComboBoxModel model = this.getComboBox().getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object elementAt = model.getElementAt(i);
            if ((!StringUtil.isEmpty((String)url) || elementAt != null) && (!(elementAt instanceof GoBasedSdk) || !((GoBasedSdk)elementAt).getHomeUrl().equals(url))) continue;
            model.setSelectedItem(elementAt);
            return;
        }
    }

    public void selectFirstNotNullSdk() {
        ComboBoxModel model = this.getComboBox().getModel();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object elementAt = model.getElementAt(i);
            if (!(elementAt instanceof GoBasedSdk) || elementAt == this.myNullSdk || !this.myValidator.validate((GoBasedSdk)elementAt).isOk()) continue;
            model.setSelectedItem(elementAt);
            return;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkListProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkActionsProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nullSdk";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/combobox/GoBasedSdkChooserCombo";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSdk";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/combobox/GoBasedSdkChooserCombo";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onComponentShown";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showOptions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addChangedListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    public static interface Validator<Sdk extends GoBasedSdk> {
        public ValidationResult validate(@NotNull Sdk var1);
    }

    private final class GoSdkRenderer
    extends ColoredListCellRendererWithProgressIcon<Sdk> {
        private GoSdkRenderer() {
            super(GoBasedSdkChooserCombo.this.myAsyncProcessIcon);
        }

        @Override
        protected void customizeCellRenderer(@NotNull JList<? extends Sdk> list, Sdk value2, int index, boolean selected, boolean hasFocus) {
            if (list == null) {
                GoSdkRenderer.$$$reportNull$$$0(0);
            }
            if (value2 == null || value2 == GoBasedSdkChooserCombo.this.myNullSdk) {
                this.append(ProjectBundle.message((String)"sdk.missing.item", (Object[])new Object[0]));
            } else {
                this.setIcon(value2.getIcon());
                boolean valid = value2.isValid() && GoBasedSdkChooserCombo.this.myValidator.validate(value2).isOk();
                this.append(value2.getName(), valid ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.ERROR_ATTRIBUTES);
                this.append(" " + FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)value2.getHomeUrl())), selected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAYED_ATTRIBUTES);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/goide/sdk/combobox/GoBasedSdkChooserCombo$GoSdkRenderer", "customizeCellRenderer"));
        }
    }
}

