/*
 * Decompiled with CFR 0.152.
 */
package com.goide.sdk.combobox;

import com.goide.GoOsManager;
import com.goide.sdk.GoSdkUtil;
import com.goide.vgo.VgoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoSdkPathDiscoverer {
    private static final Logger LOG = Logger.getInstance(GoSdkPathDiscoverer.class);

    @NotNull
    private static Set<String> suggestUnix() {
        HashSet<String> candidates = new HashSet<String>();
        GoSdkPathDiscoverer.addIfDirectory("/usr/local/go", candidates);
        GoSdkPathDiscoverer.collectInBinary("/usr/bin", candidates);
        GoSdkPathDiscoverer.collectSnap(candidates);
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    @NotNull
    private static Set<String> suggestMac() {
        HashSet<String> candidates = new HashSet<String>();
        GoSdkPathDiscoverer.addIfDirectory("/usr/local/opt/go", candidates);
        GoSdkPathDiscoverer.addIfDirectory("/opt/homebrew/opt/go", candidates);
        GoSdkPathDiscoverer.collectInBinary("/usr/local/bin", candidates);
        GoSdkPathDiscoverer.collectInLibs("/usr/local/Cellar/", candidates);
        GoSdkPathDiscoverer.collectInLibs("/opt/local/lib/", candidates);
        HashSet<String> hashSet = candidates;
        if (hashSet == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void addIfDirectory(@NotNull String path, @NotNull Set<String> candidates) {
        File file2;
        if (path == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(2);
        }
        if (candidates == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(3);
        }
        if ((file2 = new File(path)).isDirectory()) {
            candidates.add(path);
        }
    }

    @Nullable
    private static String getPathSafe(@NotNull File file2) {
        if (file2 == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(4);
        }
        try {
            return file2.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    private static Set<String> suggestWindows() {
        HashSet<String> result = new HashSet<String>();
        for (File file2 : File.listRoots()) {
            result.add(new File(file2, "Go").getAbsolutePath());
            result.add(new File(file2, "Program Files\\Go").getAbsolutePath());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(5);
        }
        return hashSet;
    }

    private static void collectSnap(Set<String> candidates) {
        File[] snapInstallations = new File("/snap/go").listFiles();
        if (snapInstallations != null) {
            for (File installation : snapInstallations) {
                if (!installation.isDirectory()) continue;
                candidates.add(installation.getAbsolutePath());
            }
        }
    }

    private static void collectInLibs(@NotNull String path, @NotNull Set<String> candidates) {
        File[] list;
        if (path == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(6);
        }
        if (candidates == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(7);
        }
        if ((list = new File(path).listFiles((dir, name) -> name.matches("go@?[0-9.]*$"))) != null) {
            for (File go : list) {
                Object[] inner = go.listFiles();
                if (inner == null) continue;
                candidates.addAll(ContainerUtil.mapNotNull((Object[])inner, GoSdkPathDiscoverer::getPathSafe));
            }
        }
    }

    private static void collectInBinary(@NotNull String path, @NotNull Set<String> candidates) {
        VirtualFile rootDir;
        if (path == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(8);
        }
        if (candidates == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(9);
        }
        if ((rootDir = LocalFileSystem.getInstance().findFileByPath(path)) != null) {
            String resolve;
            String pathToGo;
            if (rootDir instanceof NewVirtualFile) {
                ((NewVirtualFile)rootDir).markDirty();
            }
            rootDir.refresh(true, false);
            VirtualFile go = rootDir.findChild("go");
            if (go != null && !go.isDirectory() && (pathToGo = FileSystemUtil.isSymLink((String)(pathToGo = go.getPath())) ? ((resolve = FileSystemUtil.resolveSymLink((String)pathToGo)) == null ? null : GoSdkUtil.trimWayToBinGo(resolve)) : GoSdkUtil.trimWayToBinGo(pathToGo)) != null) {
                candidates.add(pathToGo);
            }
        }
    }

    private static void collectAsdf(@NotNull Set<String> candidates) {
        Path installsDir;
        if (candidates == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(10);
        }
        if ((installsDir = GoSdkPathDiscoverer.findAsdfInstallsDir()) == null) {
            return;
        }
        Path sdkRoots = installsDir.resolve("golang");
        if (GoSdkPathDiscoverer.safeIsDirectory(sdkRoots)) {
            candidates.addAll(GoSdkPathDiscoverer.scanFolder(sdkRoots));
        }
    }

    @Nullable
    public static Path findAsdfInstallsDir() {
        Path userHome;
        Path installsDir;
        Path primaryDir;
        String dataDir = EnvironmentUtil.getValue((String)"ASDF_DATA_DIR");
        if (dataDir != null && GoSdkPathDiscoverer.safeIsDirectory(primaryDir = Path.of(dataDir, new String[0])) && GoSdkPathDiscoverer.safeIsDirectory(installsDir = primaryDir.resolve("installs"))) {
            return installsDir;
        }
        if (!GoOsManager.isWindows() && GoSdkPathDiscoverer.safeIsDirectory(installsDir = (userHome = Path.of(SystemProperties.getUserHome(), new String[0])).resolve(".asdf/installs"))) {
            return installsDir;
        }
        return null;
    }

    private static Set<String> scanFolder(@NotNull Path folder) {
        if (folder == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(11);
        }
        HashSet<String> result = new HashSet<String>();
        try (Stream<Path> files = Files.list(folder);){
            files.forEach(candidate -> {
                Path goDir = candidate.resolve("go");
                VirtualFile sdkRoot = LocalFileSystem.getInstance().findFileByNioFile(goDir);
                if (GoSdkUtil.findVersionFile(sdkRoot, false) != null) {
                    result.add(goDir.toAbsolutePath().toString());
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    private static boolean safeIsDirectory(@NotNull Path dir) {
        if (dir == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(12);
        }
        try {
            return Files.isDirectory(dir, new LinkOption[0]);
        }
        catch (SecurityException se) {
            return false;
        }
        catch (Exception e) {
            LOG.debug("Failed to check directory existence: unexpected exception " + e.getClass().getSimpleName() + ": " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void collectGoToolchains(@Nullable Project project, @NotNull Set<String> candidates) {
        VirtualFile dependenciesRoot;
        if (candidates == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(13);
        }
        VirtualFile virtualFile = dependenciesRoot = project != null ? VgoUtil.getDependenciesRoot(project, null) : VfsUtil.findRelativeFile((VirtualFile)GoSdkUtil.getDefaultGoPath(), (String[])new String[]{"pkg", "mod"});
        if (dependenciesRoot == null) {
            return;
        }
        VirtualFile golangDir = dependenciesRoot.findChild("golang.org");
        if (golangDir == null || !golangDir.isDirectory()) {
            return;
        }
        for (VirtualFile child : golangDir.getChildren()) {
            if (!child.isDirectory() || !child.getName().startsWith("toolchain@v0.0.1-go") || GoSdkUtil.findVersionFile(child, false) == null) continue;
            candidates.add(child.getPath());
        }
    }

    @NotNull
    static Collection<String> suggestSdkPaths(@Nullable Project project) {
        Set<String> paths = GoSdkPathDiscoverer.suggestSdkPathsInner();
        ContainerUtil.addIfNotNull(paths, (Object)GoSdkUtil.suggestSdkDirectoryPathFromEnv());
        ContainerUtil.addIfNotNull(paths, (Object)EnvironmentUtil.getValue((String)"GOROOT"));
        GoSdkPathDiscoverer.collectAsdf(paths);
        GoSdkPathDiscoverer.collectGoToolchains(project, paths);
        List list = ContainerUtil.map(paths, GoSdkUtil::adjustSdkPath);
        if (list == null) {
            GoSdkPathDiscoverer.$$$reportNull$$$0(14);
        }
        return list;
    }

    @NotNull
    private static Set<String> suggestSdkPathsInner() {
        if (GoOsManager.isMac()) {
            return GoSdkPathDiscoverer.suggestMac();
        }
        if (GoOsManager.isLinux()) {
            return GoSdkPathDiscoverer.suggestUnix();
        }
        if (GoOsManager.isWindows()) {
            return GoSdkPathDiscoverer.suggestWindows();
        }
        return new HashSet<String>();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/sdk/combobox/GoSdkPathDiscoverer";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: 
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestUnix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestMac";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/sdk/combobox/GoSdkPathDiscoverer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestWindows";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkPaths";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addIfDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPathSafe";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "collectInLibs";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "collectInBinary";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectAsdf";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "scanFolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "safeIsDirectory";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectGoToolchains";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 6, 7, 8, 9, 10, 11, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

