/*
 * Decompiled with CFR 0.152.
 */
package com.goide.statistics;

import com.goide.index.GoImportPathToAliasIndexKt;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.statistics.errors.GoStatisticsWhiteListsService;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendorDirectoriesCollector;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.BooleanEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.LocalFileCustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoUserEnvironmentStatisticsCollector
extends ProjectUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("go.user.environment", 6);
    public static final StringEventField SDK_VERSION = new StringEventField("sdk_version"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{enum:devel}", "{regexp:(\\d+\\.?)*\\d+((beta|rc)\\d+)?}");
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/statistics/GoUserEnvironmentStatisticsCollector$1", "getValidationRule"));
        }
    };
    private static final StringEventField SDK_MAJOR_VERSION = EventFields.StringValidatedByRegexpReference((String)"sdk_major_version", (String)"version");
    private static final VarargEventId SDK = GROUP.registerVarargEvent("sdk", new EventField[]{SDK_VERSION, SDK_MAJOR_VERSION});
    private static final EventId1<Boolean> HAS_VENDOR = GROUP.registerEvent("has.vendor", (EventField)EventFields.Enabled);
    private static final String PACKAGE_IMPORT_PATH = "package_import_path";
    private static final String STD_PACKAGE_IMPORT_PATH = "std_package_import_path";
    private static final StringEventField PACKAGE_IMPORT_PATH_FIELD = new StringEventField("package_import_path"){

        @NotNull
        public List<String> getValidationRule() {
            List<String> list = List.of("{util#package_import_path}", "{util#std_package_import_path}");
            if (list == null) {
                2.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/goide/statistics/GoUserEnvironmentStatisticsCollector$2", "getValidationRule"));
        }
    };
    private static final BooleanEventField IS_STD_PACKAGE_IMPORT = EventFields.Boolean((String)"is_std_package_import");
    private static final Pattern BETA = Pattern.compile("^[0-9]+(\\.[0-9]+(\\.[0-9]+)?)?beta[0-9]+");
    private static final Pattern RC = Pattern.compile("^[0-9]+(\\.[0-9]+(\\.[0-9]+)?)?rc[0-9]+");
    private static final Pattern RELEASE = Pattern.compile("^[0-9]+(\\.[0-9]+(\\.[0-9]+)?)?");
    private static final EventId1<String> DEPENDENCY_MANAGER = GROUP.registerEvent("dependency.manager", (EventField)EventFields.String((String)"dependency_manager_name", List.of("Dep", "Glide", "RubiGo", "GoGradle", "Trash", "vgo", "GoDep")));
    private static final EventId2<String, Boolean> PACKAGE_IMPORT = GROUP.registerEvent("package.import", (EventField)PACKAGE_IMPORT_PATH_FIELD, (EventField)IS_STD_PACKAGE_IMPORT);

    public EventLogGroup getGroup() {
        return GROUP;
    }

    protected boolean requiresReadAccess() {
        return true;
    }

    protected boolean requiresSmartMode() {
        return true;
    }

    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        Collection<Module> goModules = GoSdkUtil.getGoModules(project);
        for (Module module : goModules) {
            GoUserEnvironmentStatisticsCollector.addSdk(project, result, module);
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                GoUserEnvironmentStatisticsCollector.addDependencyManager(result, contentRoot);
            }
            GoUserEnvironmentStatisticsCollector.addVendor(result, module);
        }
        GoUserEnvironmentStatisticsCollector.addImportedPackages(project, result, goModules);
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    private static void addSdk(@NotNull Project project, @NotNull Set<MetricEvent> result, @NotNull Module module) {
        String version;
        if (project == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(2);
        }
        if (result == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(3);
        }
        if (module == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(4);
        }
        String normalized = StringUtil.isNotEmpty((String)(version = GoSdkService.getInstance(project).getSdk(module).getVersion())) ? GoUserEnvironmentStatisticsCollector.normalizeVersion(version) : null;
        String major = StringUtil.nullize((String)GoSdkUtil.getSdkMajorVersion(normalized));
        if (normalized != null && major != null) {
            result.add(SDK.metric(new EventPair[]{SDK_VERSION.with((Object)normalized), SDK_MAJOR_VERSION.with((Object)major)}));
        }
    }

    @NotNull
    public static String normalizeVersion(@NotNull String version) {
        if (version == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(5);
        }
        if (version.startsWith("devel")) {
            return "devel";
        }
        String beta = GoUserEnvironmentStatisticsCollector.find(BETA, version);
        if (!beta.isEmpty()) {
            String string = beta;
            if (string == null) {
                GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(6);
            }
            return string;
        }
        String rc = GoUserEnvironmentStatisticsCollector.find(RC, version);
        if (!rc.isEmpty()) {
            String string = rc;
            if (string == null) {
                GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(7);
            }
            return string;
        }
        String release = GoUserEnvironmentStatisticsCollector.find(RELEASE, version);
        if (!release.isEmpty()) {
            String string = release;
            if (string == null) {
                GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(8);
            }
            return string;
        }
        return "other";
    }

    @NotNull
    private static String find(@NotNull Pattern pattern, @NotNull String version) {
        Matcher matcher;
        if (pattern == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(9);
        }
        if (version == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(10);
        }
        return (matcher = pattern.matcher(version)).find() ? matcher.group() : "";
    }

    private static void addDependencyManager(@NotNull Set<MetricEvent> result, @NotNull VirtualFile contentRoot) {
        VirtualFile goDeps;
        if (result == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(11);
        }
        if (contentRoot == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(12);
        }
        if (contentRoot.findChild("Gopkg.toml") != null || contentRoot.findChild("Gopkg.lock") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"Dep"));
        }
        if (contentRoot.findChild("glide.toml") != null || contentRoot.findChild("glide.lock") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"Glide"));
        }
        if (contentRoot.findChild("rubigo.toml") != null || contentRoot.findChild("rubigo.lock") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"RubiGo"));
        }
        if (contentRoot.findChild("build.gradle") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"GoGradle"));
        }
        if (contentRoot.findChild("vendor.conf") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"Trash"));
        }
        if (contentRoot.findChild("go.mod") != null) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"vgo"));
        }
        if ((goDeps = contentRoot.findChild("Godeps")) != null && goDeps.isDirectory()) {
            result.add(DEPENDENCY_MANAGER.metric((Object)"GoDep"));
        }
    }

    private static void addVendor(@NotNull Set<MetricEvent> result, @NotNull Module module) {
        if (result == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(13);
        }
        if (module == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(14);
        }
        if (!GoVendorDirectoriesCollector.getInstance(module.getProject()).getVendorDirectories(module).isEmpty()) {
            result.add(HAS_VENDOR.metric((Object)true));
        }
    }

    private static void addImportedPackages(@NotNull Project project, @NotNull Set<MetricEvent> packages, @NotNull Collection<Module> goModules) {
        if (project == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(15);
        }
        if (packages == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(16);
        }
        if (goModules == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(17);
        }
        if (goModules.isEmpty()) {
            return;
        }
        GlobalSearchScope scope = goModules.stream().map(module -> GoUtil.moduleScopeWithoutLibraries(project, module)).reduce(GlobalSearchScope::uniteWith).orElse(GlobalSearchScope.EMPTY_SCOPE);
        Set<String> thirdPartyWhitelist = GoStatisticsWhiteListsService.getInstance().getImportsSet();
        HashSet thirdPartyResults = new HashSet();
        Set<String> stdWhitelist = GoStatisticsWhiteListsService.getInstance().getStdImportsSet();
        HashSet stdResults = new HashSet();
        for (String importPath : GoImportPathToAliasIndexKt.getAllImportPaths(project)) {
            GoImportPathToAliasIndexKt.processAliasesByImportPath(scope, importPath, (FileBasedIndex.ValueProcessor<? super String>)((FileBasedIndex.ValueProcessor)(file2, alias) -> {
                String thirdParty = GoUserEnvironmentStatisticsCollector.findImportPathPrefix(thirdPartyWhitelist, importPath);
                if (StringUtil.isNotEmpty((String)thirdParty)) {
                    thirdPartyResults.add(thirdParty);
                    return false;
                }
                String std = GoUserEnvironmentStatisticsCollector.findImportPathPrefix(stdWhitelist, importPath);
                if (StringUtil.isNotEmpty((String)std)) {
                    stdResults.add(std);
                    return false;
                }
                return false;
            }));
        }
        for (String result : thirdPartyResults) {
            packages.add(PACKAGE_IMPORT.metric((Object)result, (Object)false));
        }
        for (String result : stdResults) {
            packages.add(PACKAGE_IMPORT.metric((Object)result, (Object)true));
        }
    }

    @Nullable
    public static String findImportPathPrefix(@NotNull Set<String> prefixes, @NotNull String importPath) {
        if (prefixes == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(18);
        }
        if (importPath == null) {
            GoUserEnvironmentStatisticsCollector.$$$reportNull$$$0(19);
        }
        if (prefixes.contains(importPath)) {
            return importPath;
        }
        for (int i = importPath.length() - 1; i >= 0; --i) {
            String prefix;
            if (importPath.charAt(i) != '/' || !prefixes.contains(prefix = importPath.substring(0, i))) continue;
            return prefix;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/statistics/GoUserEnvironmentStatisticsCollector";
                break;
            }
            case 3: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModules";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixes";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/statistics/GoUserEnvironmentStatisticsCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSdk";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "normalizeVersion";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addDependencyManager";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addVendor";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addImportedPackages";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findImportPathPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 8 -> new IllegalStateException(string);
        };
    }

    public static final class StdPackageImportPathValidationRule
    extends LocalFileCustomValidationRule {
        private StdPackageImportPathValidationRule() {
            super(GoUserEnvironmentStatisticsCollector.STD_PACKAGE_IMPORT_PATH, GoUserEnvironmentStatisticsCollector.class, "/statistics/std.packages.txt");
        }
    }

    public static final class PackageImportPathValidationRule
    extends LocalFileCustomValidationRule {
        private PackageImportPathValidationRule() {
            super(GoUserEnvironmentStatisticsCollector.PACKAGE_IMPORT_PATH, GoUserEnvironmentStatisticsCollector.class, "/statistics/awesome.go.packages.txt");
        }
    }
}

