/*
 * Decompiled with CFR 0.152.
 */
package com.goide.template.integration;

import com.goide.psi.GoElement;
import com.goide.psi.GoFile;
import com.goide.psi.GoType;
import com.goide.psi.GoVarDefinition;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoPackageUtil;
import com.goide.template.GoTemplateTokenSets;
import com.goide.template.integration.GoTemplateDotTypeHint;
import com.goide.template.psi.GoTemplateEmptyStatement;
import com.goide.template.psi.GoTemplateStatementList;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoTemplateUtil {
    @NonNls
    public static final String TYPE_HINT_PREFIX = "gotype:";

    public static void processBuiltinFunctions(@NotNull Project project, @NotNull PairProcessor<? super String, ? super GoElement> processor2) {
        if (project == null) {
            GoTemplateUtil.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            GoTemplateUtil.$$$reportNull$$$0(1);
        }
        GoPsiUtil.processMapEntries(GoTemplateUtil.findBuiltinFunctionsVar(project), processor2);
    }

    @Nullable
    private static GoVarDefinition findBuiltinFunctionsVar(@NotNull Project project) {
        if (project == null) {
            GoTemplateUtil.$$$reportNull$$$0(2);
        }
        Ref result = Ref.create();
        GoPackageUtil.processFilesInPackage("text/template", project, null, ResolveState.initial(), (Processor<? super PsiFile>)((Processor)file2 -> {
            GoVarDefinition varDefinition;
            if (file2 instanceof GoFile && (varDefinition = (GoVarDefinition)ContainerUtil.getFirstItem(((GoFile)((Object)file2)).getVars("builtins"))) != null) {
                result.set((Object)varDefinition);
                return false;
            }
            return true;
        }));
        return (GoVarDefinition)result.get();
    }

    @Nullable
    public static GoType getTypeFromHint(@NotNull Project project, @NotNull GoTemplateDotTypeHint hint) {
        String type;
        if (project == null) {
            GoTemplateUtil.$$$reportNull$$$0(3);
        }
        if (hint == null) {
            GoTemplateUtil.$$$reportNull$$$0(4);
        }
        return (type = hint.getType()) != null ? GoTypeUtil.findType(project, hint.getImportPath(), type) : null;
    }

    @Nullable
    public static GoTemplateDotTypeHint getDotTypeHint(@Nullable PsiElement element) {
        GoTemplateStatementList statementList = (GoTemplateStatementList)ObjectUtils.tryCast((Object)element, GoTemplateStatementList.class);
        if (statementList == null) {
            return null;
        }
        String hintText = GoTemplateUtil.findHintText(statementList);
        if (hintText != null) {
            return GoTemplateUtil.parseTypeHint(hintText);
        }
        return null;
    }

    @Nullable
    private static String findHintText(@NotNull GoTemplateStatementList statementList) {
        if (statementList == null) {
            GoTemplateUtil.$$$reportNull$$$0(5);
        }
        for (PsiElement child : statementList.getChildren()) {
            if (!(child instanceof GoTemplateEmptyStatement)) continue;
            for (PsiElement statementChild = child.getFirstChild(); statementChild != null; statementChild = statementChild.getNextSibling()) {
                String trimStart;
                if (GoTemplateTokenSets.COMMENT != statementChild.getNode().getElementType() || (trimStart = GoTemplateUtil.trimTypeHintCommentPrefix(statementChild.getText())) == null) continue;
                return StringUtil.trim((String)StringUtil.trimEnd((String)trimStart, (String)"*/"));
            }
        }
        return null;
    }

    @Nullable
    public static String trimTypeHintCommentPrefix(@NotNull String text) {
        String noCommentStart;
        if (text == null) {
            GoTemplateUtil.$$$reportNull$$$0(6);
        }
        if ((noCommentStart = StringUtil.trimStart((String)text, (String)"/*")).length() == text.length()) {
            return null;
        }
        String noSpaces = StringUtil.trimLeading((String)noCommentStart);
        String noPrefix = StringUtil.trimStart((String)noSpaces, (String)TYPE_HINT_PREFIX);
        if (noPrefix.length() == noSpaces.length()) {
            return null;
        }
        return StringUtil.trimLeading((String)noPrefix);
    }

    @Nullable
    public static GoTemplateDotTypeHint parseTypeHint(@Nullable String hintText) {
        if (hintText == null) {
            return null;
        }
        int lastDot = hintText.lastIndexOf(46);
        if (lastDot == -1) {
            return new GoTemplateDotTypeHint(hintText, null);
        }
        int slashAfterDot = hintText.indexOf(47, lastDot);
        return slashAfterDot != -1 ? new GoTemplateDotTypeHint(hintText, null) : new GoTemplateDotTypeHint(hintText.substring(0, lastDot), hintText.substring(lastDot + 1));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statementList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/goide/template/integration/GoTemplateUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processBuiltinFunctions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findBuiltinFunctionsVar";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTypeFromHint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findHintText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "trimTypeHintCommentPrefix";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

