/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.GoFileType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.util.GoPathScopeBase;
import com.goide.util.GoUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoPathProjectScope
extends GoPathScopeBase {
    @Nullable
    private final Module myContextModule;
    @Nullable
    private final VirtualFile myContextDirectory;

    public static GlobalSearchScope create(@NotNull PsiElement context) {
        if (context == null) {
            GoPathProjectScope.$$$reportNull$$$0(0);
        }
        return new GoPathProjectScope(context).intersectWith(GlobalSearchScope.allScope((Project)context.getProject()));
    }

    private GoPathProjectScope(@NotNull PsiElement context) {
        if (context == null) {
            GoPathProjectScope.$$$reportNull$$$0(1);
        }
        super(context.getProject());
        VirtualFile contextFile = context.getContainingFile().getVirtualFile();
        this.myContextDirectory = contextFile != null ? contextFile.getParent() : null;
        this.myContextModule = GoUtil.module(context);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            GoPathProjectScope.$$$reportNull$$$0(2);
        }
        if (!FileTypeRegistry.getInstance().isFileOfType(file2, (FileType)GoFileType.INSTANCE)) {
            return false;
        }
        if (this.myContextDirectory != null && this.myContextDirectory.equals(file2.getParent())) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.getProject()).findFile(file2);
        return psiFile != null && GoPsiImplUtil.allowed(psiFile, null, this.myContextModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoPathProjectScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "create";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

