/*
 * Decompiled with CFR 0.152.
 */
package com.goide.util;

import com.goide.inspections.GoInspectionUtil;
import com.goide.psi.GoCallExpr;
import com.goide.psi.GoExpression;
import com.goide.psi.GoFile;
import com.goide.psi.GoFunctionDeclaration;
import com.goide.psi.GoInterfaceType;
import com.goide.psi.GoNamedElement;
import com.goide.psi.GoNamedSignatureOwner;
import com.goide.psi.GoParameterDeclaration;
import com.goide.psi.GoReferenceExpression;
import com.goide.psi.GoSignature;
import com.goide.psi.GoType;
import com.goide.psi.GoTypeSpec;
import com.goide.psi.impl.GoLightType;
import com.goide.psi.impl.GoPsiImplUtil;
import com.goide.psi.impl.GoTypeUtil;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoUtil;
import com.goide.vendor.GoVendoringUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GoStdlibUtil {
    public static boolean implementsStringerOrError(@NotNull GoType type, @Nullable PsiElement context) {
        if (type == null) {
            GoStdlibUtil.$$$reportNull$$$0(0);
        }
        return ContainerUtil.exists(GoTypeUtil.getMethodSet(type, context), so -> {
            String name = so.getName();
            return ("String".equals(name) || "Error".equals(name)) && GoStdlibUtil.isNoArgStringReturningMethod(so, context);
        });
    }

    public static boolean implementsError(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && ContainerUtil.exists(GoTypeUtil.getMethodSet(type, context), so -> {
            String name = so.getName();
            return "Error".equals(name) && GoStdlibUtil.isNoArgStringReturningMethod(so, context);
        });
    }

    @Contract(value="null, _ -> false")
    public static boolean isStringMethod(@Nullable GoNamedSignatureOwner signatureOwner, @Nullable PsiElement context) {
        String name = signatureOwner != null ? signatureOwner.getName() : null;
        return "String".equals(name) && GoStdlibUtil.isNoArgStringReturningMethod(signatureOwner, context);
    }

    @Contract(value="null, _ -> false")
    public static boolean isNoArgStringReturningMethod(@Nullable GoNamedSignatureOwner signatureOwner, @Nullable PsiElement context) {
        if (signatureOwner instanceof GoFunctionDeclaration) {
            return false;
        }
        GoSignature signature = signatureOwner != null ? signatureOwner.getSignature() : null;
        return signature != null && signature.getParameters().getParameterDeclarationList().isEmpty() && GoTypeUtil.isString(signatureOwner.getResultType(), context);
    }

    public static boolean implementsFormatter(@Nullable GoType type, @Nullable PsiElement context) {
        return type != null && ContainerUtil.find(GoTypeUtil.getMethodSet(type, context), m -> GoStdlibUtil.isFormatMethod(m, context)) != null;
    }

    @Contract(value="null, _ -> false")
    private static boolean isFormatMethod(@Nullable GoNamedSignatureOwner signatureOwner, @Nullable PsiElement context) {
        if (signatureOwner == null || signatureOwner instanceof GoFunctionDeclaration) {
            return false;
        }
        if (!"Format".equals(signatureOwner.getName())) {
            return false;
        }
        if (!(signatureOwner.getResultType() instanceof GoLightType.LightVoidType)) {
            return false;
        }
        GoSignature signature = signatureOwner.getSignature();
        if (signature == null) {
            return false;
        }
        List<GoParameterDeclaration> params = signature.getParameters().getParameterDeclarationList();
        if (params.size() != 2) {
            return false;
        }
        GoParameterDeclaration sndParam = params.get(1);
        if (!GoTypeUtil.isRuneType(sndParam.getType(), context) || sndParam.getParamDefinitionList().size() > 1) {
            return false;
        }
        GoParameterDeclaration fstParam = params.get(0);
        if (fstParam.getParamDefinitionList().size() > 1) {
            return false;
        }
        GoType fstParamType = fstParam.getType();
        PsiElement resolve = fstParamType != null ? fstParamType.resolve(context) : null;
        return resolve instanceof GoTypeSpec && "State".equals(((GoTypeSpec)resolve).getName()) && GoInspectionUtil.isInSdkPackage(resolve, "fmt", context);
    }

    public static boolean isExitCall(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(1);
        }
        return GoStdlibUtil.isOsExit(callExpr) || GoStdlibUtil.isStdLibCall(callExpr, "runtime", "Goexit") || GoStdlibUtil.isStdLibCall(callExpr, "syscall", "Exit");
    }

    public static boolean isOsExit(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(2);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "os", "Exit");
    }

    public static boolean isTestingTerminatingCall(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(3);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "testing", "Fatal", "Fatalf", "Skip", "Skipf", "SkipNow", "FailNow");
    }

    public static boolean isTestingSkipCall(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(4);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "testing", "Skip", "Skipf", "SkipNow");
    }

    public static boolean isTestingT(@NotNull GoType type, @NotNull PsiElement context) {
        if (type == null) {
            GoStdlibUtil.$$$reportNull$$$0(5);
        }
        if (context == null) {
            GoStdlibUtil.$$$reportNull$$$0(6);
        }
        return GoStdlibUtil.isStdLibType(type, context, "testing", "T", true);
    }

    public static boolean isTestingB(@NotNull GoType type, @NotNull PsiElement context) {
        if (type == null) {
            GoStdlibUtil.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GoStdlibUtil.$$$reportNull$$$0(8);
        }
        return GoStdlibUtil.isStdLibType(type, context, "testing", "B", true);
    }

    public static boolean isLogTerminatingCall(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(9);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "log", "Fatal", "Fatalf", "Fatalln", "Panic", "Panicf", "Panicln");
    }

    public static boolean isErrorConstructor(@NotNull GoCallExpr callExpr) {
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(10);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "errors", "New") || GoStdlibUtil.isStdLibCall(callExpr, "fmt", "Errorf") || GoStdlibUtil.isPkgErrorsCall(callExpr, "New", "Errorf");
    }

    public static boolean isPkgErrorsCall(@NotNull GoCallExpr callExpr, String ... functionNames) {
        GoReferenceExpression ref;
        PsiElement identifier;
        if (callExpr == null) {
            GoStdlibUtil.$$$reportNull$$$0(11);
        }
        if (functionNames == null) {
            GoStdlibUtil.$$$reportNull$$$0(12);
        }
        PsiElement psiElement = identifier = (ref = (GoReferenceExpression)ObjectUtils.tryCast((Object)callExpr.getExpression(), GoReferenceExpression.class)) != null ? ref.getIdentifier() : null;
        if (identifier == null) {
            return false;
        }
        for (String functionName : functionNames) {
            if (!identifier.textMatches((CharSequence)functionName)) continue;
            GoFunctionDeclaration declaration = (GoFunctionDeclaration)ObjectUtils.tryCast((Object)ref.resolve(), GoFunctionDeclaration.class);
            GoFile file2 = declaration != null ? declaration.getContainingFile() : null;
            String importPath = file2 != null ? file2.getImportPath(GoVendoringUtil.isVendoringEnabled((PsiElement)file2)) : null;
            return "github.com/pkg/errors".equals(importPath);
        }
        return false;
    }

    public static boolean isUnsafeFunctionCall(@Nullable GoCallExpr callExpr) {
        return GoStdlibUtil.isUnsafeFunctionCall(callExpr, "unsafe", "Alignof", "Sizeof", "Offsetof");
    }

    public static boolean isUnsafeFunctionCall(@Nullable GoCallExpr callExpr, String ... functionNames) {
        if (functionNames == null) {
            GoStdlibUtil.$$$reportNull$$$0(13);
        }
        return GoStdlibUtil.isStdLibCall(callExpr, "unsafe", functionNames);
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isStdLibCall(@Nullable GoCallExpr callExpr, @NonNls @NotNull String importPath, String ... functionNames) {
        PsiElement identifier;
        if (importPath == null) {
            GoStdlibUtil.$$$reportNull$$$0(14);
        }
        if (functionNames == null) {
            GoStdlibUtil.$$$reportNull$$$0(15);
        }
        GoExpression expression = callExpr != null ? GoPsiImplUtil.unwrapParentheses(callExpr.getExpression()) : null;
        GoReferenceExpression ref = expression != null ? (GoReferenceExpression)ObjectUtils.tryCast((Object)expression, GoReferenceExpression.class) : null;
        PsiElement psiElement = identifier = ref != null ? ref.getIdentifier() : null;
        if (identifier == null) {
            return false;
        }
        for (String functionName : functionNames) {
            if (!identifier.textMatches((CharSequence)functionName)) continue;
            return GoInspectionUtil.isInSdkPackage(ref.resolve(), importPath, callExpr);
        }
        return false;
    }

    @Contract(value="null, _, _, _ -> false")
    public static boolean isStdLibType(@Nullable GoType type, @Nullable PsiElement context, @NotNull String importPath, @NotNull String typeName) {
        if (importPath == null) {
            GoStdlibUtil.$$$reportNull$$$0(16);
        }
        if (typeName == null) {
            GoStdlibUtil.$$$reportNull$$$0(17);
        }
        return GoStdlibUtil.isStdLibType(type, context, importPath, typeName, true);
    }

    @Contract(value="null, _, _, _, _ -> false")
    public static boolean isStdLibType(@Nullable GoType type, @Nullable PsiElement context, @NotNull @NonNls String importPath, @NotNull @NonNls String typeName, boolean unwrapPointer) {
        GoTypeSpec resolve;
        if (importPath == null) {
            GoStdlibUtil.$$$reportNull$$$0(18);
        }
        if (typeName == null) {
            GoStdlibUtil.$$$reportNull$$$0(19);
        }
        return (resolve = GoTypeUtil.findTypeSpec(type, context, unwrapPointer)) != null && typeName.equals(resolve.getName()) && GoInspectionUtil.isInSdkPackage(resolve, importPath, context);
    }

    public static boolean isStdLibNamedElement(@Nullable PsiElement element, @NotNull @NonNls String importPath, @NotNull @NonNls String name, @Nullable PsiElement context) {
        GoReferenceExpression ref;
        PsiElement resolved;
        if (importPath == null) {
            GoStdlibUtil.$$$reportNull$$$0(20);
        }
        if (name == null) {
            GoStdlibUtil.$$$reportNull$$$0(21);
        }
        if (element instanceof GoReferenceExpression && (resolved = (ref = (GoReferenceExpression)element).resolve()) instanceof GoNamedElement) {
            GoNamedElement namedElement = (GoNamedElement)resolved;
            return GoInspectionUtil.isInSdkPackage(namedElement, importPath, context) && name.equals(namedElement.getName());
        }
        return false;
    }

    @Nullable
    public static GoInterfaceType findInterface(@NotNull PsiElement context, @NotNull String packageName, @NotNull String interfaceName) {
        GlobalSearchScope scope;
        if (context == null) {
            GoStdlibUtil.$$$reportNull$$$0(22);
        }
        if (packageName == null) {
            GoStdlibUtil.$$$reportNull$$$0(23);
        }
        if (interfaceName == null) {
            GoStdlibUtil.$$$reportNull$$$0(24);
        }
        return (scope = GoStdlibUtil.findInterfacePackageScope(context, packageName)) != null ? GoTypeUtil.findInterface(context.getProject(), scope, interfaceName) : null;
    }

    @Nullable
    private static GlobalSearchScope findInterfacePackageScope(@NotNull PsiElement context, @NotNull String packageName) {
        Project project;
        VirtualFile srcDir;
        if (context == null) {
            GoStdlibUtil.$$$reportNull$$$0(25);
        }
        if (packageName == null) {
            GoStdlibUtil.$$$reportNull$$$0(26);
        }
        VirtualFile interfacePackage = (srcDir = GoSdkUtil.getSdkSources(project = context.getProject(), GoUtil.module((PsiElement)context.getContainingFile()))) != null ? srcDir.findChild(packageName) : null;
        return interfacePackage != null ? GlobalSearchScopesCore.directoryScope((Project)project, (VirtualFile)interfacePackage, (boolean)false) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpr";
                break;
            }
            case 6: 
            case 8: 
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionNames";
                break;
            }
            case 14: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceName";
                break;
            }
        }
        objectArray2[1] = "com/goide/util/GoStdlibUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "implementsStringerOrError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isExitCall";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isOsExit";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestingTerminatingCall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestingSkipCall";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestingT";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isTestingB";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isLogTerminatingCall";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "isErrorConstructor";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "isPkgErrorsCall";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnsafeFunctionCall";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdLibCall";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdLibType";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isStdLibNamedElement";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "findInterface";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "findInterfacePackageScope";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

