/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.vgo.VgoRootToModule;
import com.goide.vgo.VgoStatusTracker;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.internal.performanceTests.ProjectInitializationDiagnosticService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectAware;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectId;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectListener;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemProjectReloadContext;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemRefreshStatus;
import com.intellij.openapi.externalSystem.autoimport.ExternalSystemSettingsFilesReloadContext;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;

class VgoModulesAware
implements ExternalSystemProjectAware {
    public static final Logger LOG = Logger.getInstance((String)"#com.goide.vgo.go-modules-status");
    protected final VgoStatusTracker myTracker;
    protected final ExternalSystemProjectId myModuleId;
    protected final Module myModule;

    VgoModulesAware(VgoStatusTracker tracker) {
        this.myTracker = tracker;
        this.myModule = tracker.myModule;
        this.myModuleId = new ExternalSystemProjectId(VgoStatusTracker.VGO_MODULES_SYSTEM_ID, this.myModule.getModuleFilePath());
    }

    @NotNull
    public ExternalSystemProjectId getProjectId() {
        ExternalSystemProjectId externalSystemProjectId = this.myModuleId;
        if (externalSystemProjectId == null) {
            VgoModulesAware.$$$reportNull$$$0(0);
        }
        return externalSystemProjectId;
    }

    @NotNull
    public Set<String> getSettingsFiles() {
        Set set;
        try {
            LOG.debug("getSettingsFiles started");
            Set result = (Set)ReadAction.nonBlocking(() -> {
                try {
                    return this.myTracker.findAllGoModuleSettingsFiles();
                }
                catch (Exception e) {
                    LOG.debug("Exception in findAllGoModuleSettingsFiles", (Throwable)e);
                    throw e;
                }
            }).expireWith((Disposable)this.myTracker).submit((Executor)NonUrgentExecutor.getInstance()).then(files -> ContainerUtil.map2Set((Collection)files, VirtualFile::getPath)).blockingGet(10, TimeUnit.SECONDS);
            LOG.debug("Settings files: ", new Object[]{result});
            set = ContainerUtil.notNullize((Set)result);
        }
        catch (ExecutionException | TimeoutException e) {
            LOG.debug("Exception while getting settings files", (Throwable)e);
            Set<String> set2 = Collections.emptySet();
            if (set2 == null) {
                VgoModulesAware.$$$reportNull$$$0(2);
            }
            return set2;
        }
        if (set == null) {
            VgoModulesAware.$$$reportNull$$$0(1);
        }
        return set;
    }

    public void subscribe(final @NotNull ExternalSystemProjectListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            VgoModulesAware.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            VgoModulesAware.$$$reportNull$$$0(4);
        }
        MessageBus messageBus = this.myModule.getProject().getMessageBus();
        messageBus.connect(parentDisposable).subscribe(VgoStatusTracker.VgoUpdateProgressManager.UPDATE_PROGRESS_TOPIC, (Object)new VgoStatusTracker.VgoUpdateProgressManager.VgoModuleUpdateProgressListener(){

            @Override
            public void beforeRefresh(@NotNull Module module) {
                if (module == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (module == VgoModulesAware.this.myModule) {
                    listener2.onProjectReloadStart();
                }
            }

            @Override
            public void afterRefresh(@NotNull Module module, @NotNull ExternalSystemRefreshStatus status) {
                if (module == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (status == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (status != ExternalSystemRefreshStatus.SUCCESS) {
                    LOG.debug("afterRefresh status is ", new Object[]{status});
                }
                if (module == VgoModulesAware.this.myModule) {
                    listener2.onProjectReloadFinish(status);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "status";
                        break;
                    }
                }
                objectArray2[1] = "com/goide/vgo/VgoModulesAware$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeRefresh";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "afterRefresh";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        messageBus.connect(parentDisposable).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

            public void exitDumbMode() {
                LOG.debug("exitDumbMode started, running onSettingsFilesListChange");
                listener2.onSettingsFilesListChange();
            }
        });
    }

    public void reloadProject(@NotNull ExternalSystemProjectReloadContext context) {
        if (context == null) {
            VgoModulesAware.$$$reportNull$$$0(5);
        }
        ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myModule.getProject(), (String)"VgoStatusTracker.VgoModulesAware.reloadProject");
        ApplicationManager.getApplication().invokeAndWait(() -> ((FileDocumentManager)FileDocumentManager.getInstance()).saveAllDocuments());
        ExternalSystemSettingsFilesReloadContext files = context.getSettingsFilesContext();
        Set updatedFiles = files.getUpdated();
        if (context.getHasUndefinedModifications() || !files.getDeleted().isEmpty() || !files.getCreated().isEmpty() || ContainerUtil.exists((Iterable)updatedFiles, file2 -> file2.endsWith("go.work"))) {
            this.executeUpdate("go.vgo.all.modules.status.task", indicator -> this.updateDependenciesOfModules((Promise<Collection<VirtualFile>>)this.myTracker.nonBlockingReadAction(() -> this.myTracker.findAllGoModuleSettingsFiles()), vgoModules -> VgoModulesRegistry.getInstance(this.myModule.getProject()).updateAllModules(this.myModule, (Collection<VgoRootToModule>)vgoModules), (ProgressIndicatorEx)indicator));
            activityTracker.activityFinished();
            return;
        }
        this.executeUpdate(VgoStatusTracker.getTaskKey(updatedFiles), indicator -> this.updateDependenciesOfModules((Promise<Collection<VirtualFile>>)this.myTracker.nonBlockingReadAction(() -> this.findGoModuleSettingsFiles(updatedFiles)), vgoModules -> VgoModulesRegistry.getInstance(this.myModule.getProject()).updateModules(this.myModule, (Collection<VgoRootToModule>)vgoModules), (ProgressIndicatorEx)indicator));
        activityTracker.activityFinished();
    }

    private void executeUpdate(@NotNull String taskKey, @NotNull VgoStatusTracker.MyUpdater updater2) {
        if (taskKey == null) {
            VgoModulesAware.$$$reportNull$$$0(6);
        }
        if (updater2 == null) {
            VgoModulesAware.$$$reportNull$$$0(7);
        }
        ProgressIndicatorEx indicator = this.myTracker.myUpdateProgressManager.startUpdate(taskKey);
        ProjectInitializationDiagnosticService.ActivityTracker activityTracker = ProjectInitializationDiagnosticService.registerTracker((Project)this.myModule.getProject(), (String)"VgoStatusTracker.VgoModulesAware.executeUpdate");
        VgoModulesAware.executeOnPooledThread(() -> {
            ExternalSystemRefreshStatus status;
            if (this.myModule.isDisposed() || indicator.isCanceled()) {
                LOG.debug("executeUpdate cancelled, isDisposed = %s, indicator = %s".formatted(this.myModule.isDisposed(), indicator.isCanceled()));
                status = ExternalSystemRefreshStatus.CANCEL;
            } else {
                status = (ExternalSystemRefreshStatus)updater2.apply(indicator);
                LOG.debug("executeUpdate status is ", new Object[]{status});
            }
            this.myTracker.myUpdateProgressManager.finishUpdate(taskKey, indicator, status);
            activityTracker.activityFinished();
        });
    }

    @NotNull
    private ExternalSystemRefreshStatus updateDependenciesOfModules(@NotNull Promise<Collection<VirtualFile>> goModuleSettingsFiles, @NotNull Consumer<Collection<VgoRootToModule>> updateModulesInRegistry, @NotNull ProgressIndicatorEx indicator) {
        if (goModuleSettingsFiles == null) {
            VgoModulesAware.$$$reportNull$$$0(8);
        }
        if (updateModulesInRegistry == null) {
            VgoModulesAware.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            VgoModulesAware.$$$reportNull$$$0(10);
        }
        ExternalSystemRefreshStatus externalSystemRefreshStatus = this.myTracker.updateDependenciesOfModules(goModuleSettingsFiles, updateModulesInRegistry, indicator, true);
        if (externalSystemRefreshStatus == null) {
            VgoModulesAware.$$$reportNull$$$0(11);
        }
        return externalSystemRefreshStatus;
    }

    static void executeOnPooledThread(@NotNull Runnable runnable) {
        if (runnable == null) {
            VgoModulesAware.$$$reportNull$$$0(12);
        }
        if (ApplicationManager.getApplication().isHeadlessEnvironment() && !CoreProgressManager.shouldKeepTasksAsynchronousInHeadlessMode()) {
            runnable.run();
            return;
        }
        ApplicationManager.getApplication().executeOnPooledThread(runnable);
    }

    @NotNull
    protected List<VirtualFile> findGoModuleSettingsFiles(@NotNull Collection<String> paths) {
        List<VirtualFile> files;
        if (paths == null) {
            VgoModulesAware.$$$reportNull$$$0(13);
        }
        List<VirtualFile> list = (files = ContainerUtil.mapNotNull(paths, p -> VfsUtil.findFile((Path)Path.of(p, new String[0]), (boolean)false))).size() == paths.size() ? files : this.myTracker.findAllGoModuleSettingsFiles();
        if (list == null) {
            VgoModulesAware.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/VgoModulesAware";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskKey";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goModuleSettingsFiles";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateModulesInRegistry";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectId";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsFiles";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/VgoModulesAware";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDependenciesOfModules";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoModuleSettingsFiles";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "subscribe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "reloadProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "executeUpdate";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateDependenciesOfModules";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "executeOnPooledThread";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findGoModuleSettingsFiles";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8, 9, 10, 12, 13 -> new IllegalArgumentException(string);
        };
    }
}

