/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.util.GoGetPackageUtilKt;
import com.goide.vendor.GoVendorDirectoriesCollector;
import com.goide.vendor.GoVendoringUtil;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.imports.VgoScratchFileService;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.goide.vgo.project.VgoWorkspace;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoUtil {
    public static final String GO_MOD = "go.mod";
    public static final String GO_SUM = "go.sum";
    public static final String GO_WORK = "go.work";

    private static boolean isVgoModuleOrWorkspaceInner(@NotNull VirtualFile directory) {
        VirtualFile modFile;
        if (directory == null) {
            VgoUtil.$$$reportNull$$$0(0);
        }
        if ((modFile = directory.findChild(GO_MOD)) != null && !modFile.isDirectory()) {
            return true;
        }
        VirtualFile workFile = directory.findChild(GO_WORK);
        return workFile != null && !workFile.isDirectory();
    }

    @Contract(value="_, null -> null")
    public static VirtualFile findModuleRootSkippingVendor(@Nullable Module module, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        VirtualFile start = Optional.ofNullable(module).map(m -> GoVendoringUtil.findVendorDirForFile(file2, m)).map(VirtualFile::getParent).orElse(file2);
        return VgoUtil.findModuleRoot(start);
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findModuleRoot(@Nullable VirtualFile start) {
        for (VirtualFile parent = start; parent != null; parent = parent.getParent()) {
            if (!VgoUtil.isVgoModuleOrWorkspaceInner(parent)) continue;
            return parent;
        }
        return null;
    }

    public static boolean isGoModFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && GO_MOD.equals(file2.getName());
    }

    public static boolean isGoWorkFile(@Nullable VirtualFile file2) {
        return file2 != null && !file2.isDirectory() && GO_WORK.equals(file2.getName());
    }

    @Nullable
    public static VirtualFile getDependenciesRoot(@NotNull Project project, @Nullable Module module) {
        File gopathSrcRoot;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(1);
        }
        if (project.isDisposed()) {
            return null;
        }
        String userDefinedRootPath = VgoUtil.getUserDefinedDependenciesRootPath(project);
        if (userDefinedRootPath != null) {
            return VgoUtil.findFileSafe(userDefinedRootPath);
        }
        File defaultRoot = VgoUtil.getDefaultDependenciesRoot(project, module);
        if (defaultRoot != null) {
            VirtualFile vgo = VfsUtil.findFileByIoFile((File)defaultRoot, (boolean)false);
            if (vgo != null) {
                return vgo;
            }
            ApplicationManager.getApplication().invokeLater(() -> LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(defaultRoot), true, false, null));
        }
        return (gopathSrcRoot = VgoUtil.getDependenciesRootInGopathSrc(project, module)) != null ? VfsUtil.findFileByIoFile((File)gopathSrcRoot, (boolean)false) : null;
    }

    @Nullable
    public static String getDependenciesRootPath(@NotNull Project project, @Nullable Module module) {
        String userDefinedRoot;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(2);
        }
        if ((userDefinedRoot = VgoUtil.getUserDefinedDependenciesRootPath(project)) != null) {
            return userDefinedRoot;
        }
        File defaultRoot = VgoUtil.getDefaultDependenciesRoot(project, module);
        if (defaultRoot != null) {
            return defaultRoot.getPath();
        }
        File gopathSrcRoot = VgoUtil.getDependenciesRootInGopathSrc(project, module);
        return gopathSrcRoot != null ? gopathSrcRoot.getPath() : null;
    }

    @Nullable
    public static VirtualFile getUserDefinedDependenciesRoot(@NotNull Project project) {
        String path;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(3);
        }
        return (path = VgoUtil.getUserDefinedDependenciesRootPath(project)) != null ? VgoUtil.findFileSafe(path) : null;
    }

    @Nullable
    private static String getUserDefinedDependenciesRootPath(@NotNull Project project) {
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(4);
        }
        if (project.isDisposed() || !GoSdkService.getInstance(project).getSdk(null).supportsGoModCacheEnvironmentVariable()) {
            return null;
        }
        String pathFromSettings = VgoProjectSettings.getInstance(project).getGoModCache();
        return pathFromSettings != null ? pathFromSettings : EnvironmentUtil.getValue((String)VgoEnvironmentVariable.GOMODCACHE.getName());
    }

    @Nullable
    private static File getDefaultDependenciesRoot(@NotNull Project project, @Nullable Module module) {
        VirtualFile firstGoPath;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(5);
        }
        return (firstGoPath = (VirtualFile)ContainerUtil.getFirstItem(GoSdkUtil.getGoPathRoots(project, module))) != null && firstGoPath.isValid() ? new File(VfsUtilCore.virtualToIoFile((VirtualFile)firstGoPath), "pkg/mod") : null;
    }

    @Nullable
    private static File getDependenciesRootInGopathSrc(@NotNull Project project, @Nullable Module module) {
        VirtualFile firstGoPathSrc;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(6);
        }
        return (firstGoPathSrc = (VirtualFile)ContainerUtil.getFirstItem(GoSdkUtil.getGoPathSources(project, module, true))) != null && firstGoPathSrc.isValid() ? new File(VfsUtilCore.virtualToIoFile((VirtualFile)firstGoPathSrc), "mod") : null;
    }

    @Nullable
    private static VirtualFile findFileSafe(@NotNull String path) {
        Path nioPath;
        if (path == null) {
            VgoUtil.$$$reportNull$$$0(7);
        }
        return (nioPath = NioFiles.toPath((String)path)) != null ? VirtualFileManager.getInstance().findFileByNioPath(nioPath) : null;
    }

    @Nullable
    public static Pair.NonNull<VgoModule, VgoDependency> findModuleAndDependencyOfFile(@NotNull Project project, @NotNull VirtualFile contextFile) {
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(8);
        }
        if (contextFile == null) {
            VgoUtil.$$$reportNull$$$0(9);
        }
        return VgoUtil.findModuleAndDependencyOfFile(project, ModuleUtilCore.findModuleForFile((VirtualFile)contextFile, (Project)project), contextFile);
    }

    @Nullable
    public static Pair.NonNull<VgoModule, VgoDependency> findModuleAndDependencyOfFile(@NotNull Project project, @Nullable Module module, @NotNull VirtualFile contextFile) {
        VirtualFile moduleRoot;
        String importPath;
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(10);
        }
        if (contextFile == null) {
            VgoUtil.$$$reportNull$$$0(11);
        }
        if (GoSdkUtil.isInSdk(project, module, contextFile)) {
            return null;
        }
        VgoModulesRegistry modulesRegistry = VgoModulesRegistry.getInstance(project);
        if (ScratchUtil.isScratch((VirtualFile)contextFile) && (importPath = VgoScratchFileService.getInstance(project).getImportPath(contextFile)) != null) {
            for (VgoModule vgoModule : modulesRegistry.getModules()) {
                if (!importPath.equals(vgoModule.getImportPath())) continue;
                return Pair.createNonNull((Object)vgoModule, (Object)vgoModule);
            }
        }
        if ((moduleRoot = VgoUtil.findModuleRootSkippingVendor(module, contextFile)) != null && module != null) {
            VgoModule vgoModule = modulesRegistry.findVgoModuleByRoot(module, moduleRoot);
            if (vgoModule != null) {
                return Pair.createNonNull((Object)vgoModule, (Object)vgoModule);
            }
            VgoWorkspace workspace = modulesRegistry.findWorkspaceByRoot(module, moduleRoot);
            if (workspace != null && GoVendoringUtil.isVendoredFile(contextFile, module)) {
                return VgoUtil.findModuleAndDependencyInWorkspaceVendor(modulesRegistry, module, contextFile, workspace);
            }
        }
        return VgoUtil.findModuleAndDependencyContainingFile(modulesRegistry, contextFile, moduleRoot);
    }

    @Nullable
    private static Pair.NonNull<VgoModule, VgoDependency> findModuleAndDependencyInWorkspaceVendor(@NotNull VgoModulesRegistry modulesRegistry, @NotNull Module module, @NotNull VirtualFile contextFile, @NotNull VgoWorkspace workspace) {
        Optional<VgoModule> anyMainModule;
        if (modulesRegistry == null) {
            VgoUtil.$$$reportNull$$$0(12);
        }
        if (module == null) {
            VgoUtil.$$$reportNull$$$0(13);
        }
        if (contextFile == null) {
            VgoUtil.$$$reportNull$$$0(14);
        }
        if (workspace == null) {
            VgoUtil.$$$reportNull$$$0(15);
        }
        if ((anyMainModule = StreamEx.of(workspace.getMainModules()).map(VgoDependency::getRoot).nonNull().findFirst().map(root -> modulesRegistry.findVgoModuleByRoot(module, (VirtualFile)root))).isEmpty()) {
            return null;
        }
        VgoDependency vendorDependency = VgoUtil.findDependencyInWorkspaceVendor(workspace, contextFile);
        if (vendorDependency == null) {
            return null;
        }
        return Pair.createNonNull((Object)anyMainModule.get(), (Object)vendorDependency);
    }

    @Nullable
    private static VgoDependency findDependencyInWorkspaceVendor(@NotNull VgoWorkspace workspace, @NotNull VirtualFile file2) {
        VirtualFile vendorDir;
        if (workspace == null) {
            VgoUtil.$$$reportNull$$$0(16);
        }
        if (file2 == null) {
            VgoUtil.$$$reportNull$$$0(17);
        }
        if ((vendorDir = workspace.getRoot().findChild("vendor")) == null) {
            return null;
        }
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)vendorDir);
        if (relativePath == null) {
            return null;
        }
        String importPath = FileUtil.toCanonicalPath((String)relativePath);
        return workspace.getDependencies().stream().filter(d -> importPath.startsWith(d.getImportPath())).max(Comparator.comparingInt(d -> d.getImportPath().length())).orElse(null);
    }

    private static Pair.NonNull<VgoModule, VgoDependency> findModuleAndDependencyContainingFile(@NotNull VgoModulesRegistry modulesRegistry, @NotNull VirtualFile file2, @Nullable VirtualFile moduleRoot) {
        if (modulesRegistry == null) {
            VgoUtil.$$$reportNull$$$0(18);
        }
        if (file2 == null) {
            VgoUtil.$$$reportNull$$$0(19);
        }
        Collection<VgoModule> modules = modulesRegistry.getModules();
        if (moduleRoot != null) {
            String rootPath = PathUtil.toSystemIndependentName((String)moduleRoot.getPath());
            for (VgoModule vgoModule : modules) {
                VgoDependency dependencyAt = vgoModule.findDependencyAt(rootPath);
                if (dependencyAt == null) continue;
                return Pair.createNonNull((Object)vgoModule, (Object)dependencyAt);
            }
        } else {
            for (VgoModule vgoModule : modules) {
                for (VgoDependency dependency : vgoModule.getDependencies()) {
                    VirtualFile dependencyRoot = dependency.getRoot();
                    if (dependencyRoot == null || !VfsUtilCore.isAncestor((VirtualFile)dependencyRoot, (VirtualFile)file2, (boolean)false)) continue;
                    return Pair.createNonNull((Object)vgoModule, (Object)dependency);
                }
            }
        }
        return null;
    }

    public static void addDependencyToGoMod(@NotNull String importPath, @NotNull Project project, @NotNull VgoModule module) {
        if (importPath == null) {
            VgoUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(21);
        }
        if (module == null) {
            VgoUtil.$$$reportNull$$$0(22);
        }
        GoGetPackageUtilKt.addDependency(importPath, project, module.getRoot().getPath());
    }

    public static boolean anyVgoModuleHasVendor(@NotNull Module module) {
        if (module == null) {
            VgoUtil.$$$reportNull$$$0(23);
        }
        Collection<VgoModule> vgoModules = VgoModulesRegistry.getInstance(module.getProject()).getModules(module);
        Set<VirtualFile> vendors = GoVendorDirectoriesCollector.getInstance(module.getProject()).getVendorDirectories(module);
        Set vendorParents = ContainerUtil.map2Set(vendors, VirtualFile::getParent);
        return ContainerUtil.exists(vgoModules, vgoModule -> vendorParents.contains(vgoModule.getRoot()));
    }

    public static boolean isVendoringMode(@NotNull Project project) {
        if (project == null) {
            VgoUtil.$$$reportNull$$$0(24);
        }
        return VgoProjectSettings.getInstance(project).isAutoVendoringMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 12: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesRegistry";
                break;
            }
            case 13: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importPath";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/VgoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isVgoModuleOrWorkspaceInner";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependenciesRoot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependenciesRootPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserDefinedDependenciesRoot";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getUserDefinedDependenciesRootPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getDefaultDependenciesRoot";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getDependenciesRootInGopathSrc";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findFileSafe";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleAndDependencyOfFile";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleAndDependencyInWorkspaceVendor";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "findDependencyInWorkspaceVendor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "findModuleAndDependencyContainingFile";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "addDependencyToGoMod";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "anyVgoModuleHasVendor";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "isVendoringMode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

