/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo;

import com.goide.vgo.EditSystemGoEnvDialog;
import com.goide.vgo.EnvironmentVariable;
import com.goide.vgo.EnvironmentVariableSource;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.VgoUtilKt;
import com.goide.vgo.configuration.VgoEnvironmentVariable;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.intellij.ide.Region;
import com.intellij.ide.RegionSettings;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.PathKt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\b\u001a\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005\u001a\u001a\u0010\f\u001a\u00020\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\b\u001a\u0006\u0010\u000e\u001a\u00020\u0005\u001a\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0006\u0010\u0011\u001a\u00020\u0010\u001a\u0016\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0080@\u00a2\u0006\u0002\u0010\u0013\"\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"getVariableFromEnvironment", "Lcom/goide/vgo/EnvironmentVariable;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "getVariableFromSystemEnvironment", "readGoEnv", "", "writeGoEnvVariable", "", "value", "writeGoEnv", "envs", "getGoEnvPath", "needToPatchGoProxyInChina", "", "isMainlandChinaRegion", "showGoEnvEditorDialog", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.go.impl"})
@SourceDebugExtension(value={"SMAP\nVgoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VgoUtil.kt\ncom/goide/vgo/VgoUtilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,147:1\n1#2:148\n19#3:149\n216#4,2:150\n13#5:152\n*S KotlinDebug\n*F\n+ 1 VgoUtil.kt\ncom/goide/vgo/VgoUtilKt\n*L\n55#1:149\n69#1:150,2\n146#1:152\n*E\n"})
public final class VgoUtilKt {
    @NotNull
    private static final Logger LOG;

    @Nullable
    public static final EnvironmentVariable getVariableFromEnvironment(@Nullable Project project, @NotNull String name) {
        String projectEnvValue;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (project != null && (projectEnvValue = VgoProjectSettings.getInstance(project).getEnvironment().get(name)) != null) {
            LOG.info("Using environment variable '" + name + "' from project settings: " + projectEnvValue);
            return new EnvironmentVariable(name, projectEnvValue, EnvironmentVariableSource.PROJECT);
        }
        return VgoUtilKt.getVariableFromSystemEnvironment(name);
    }

    @Nullable
    public static final EnvironmentVariable getVariableFromSystemEnvironment(@NotNull String name) {
        String valueFromGoEnv;
        Map<String, String> props;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String valueFromSystemEnv = EnvironmentUtil.getValue((String)name);
        if (valueFromSystemEnv != null) {
            LOG.info("Using environment variable '" + name + "' from system environment: " + valueFromSystemEnv);
            return new EnvironmentVariable(name, valueFromSystemEnv, EnvironmentVariableSource.SYSTEM);
        }
        Map<String, String> map = props = VgoUtilKt.readGoEnv();
        String string = valueFromGoEnv = map != null ? map.get(name) : null;
        if (valueFromGoEnv != null) {
            LOG.info("Using environment variable '" + name + "' from Go environment file '" + VgoUtilKt.getGoEnvPath() + "': " + valueFromGoEnv);
            return new EnvironmentVariable(name, valueFromGoEnv, EnvironmentVariableSource.GO_ENVIRONMENT);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final Map<String, String> readGoEnv() {
        Path path = Paths.get(VgoUtilKt.getGoEnvPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path goConfig = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(goConfig, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        Properties props = new Properties();
        Object object = goConfig;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedReader(new InputStreamReader(Files.newInputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedReader it = (BufferedReader)object;
            boolean bl = false;
            props.load(it);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Map $this$asSafely$iv = MapsKt.toMap((Map)props);
        boolean $i$f$asSafely = false;
        Map map = $this$asSafely$iv;
        if (!(map instanceof Map)) {
            map = null;
        }
        return map;
    }

    public static final void writeGoEnvVariable(@NotNull String name, @NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Map map = VgoUtilKt.readGoEnv();
        if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
            map = new LinkedHashMap();
        }
        Map props = map;
        props.put(name, value2);
        VgoUtilKt.writeGoEnv(props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeGoEnv(@NotNull Map<String, String> envs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        Path path = Paths.get(VgoUtilKt.getGoEnvPath(), new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path goConfig = path;
        PathKt.createParentDirectories((Path)goConfig);
        Object object = goConfig;
        OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            Map<String, String> $this$forEach$iv = envs;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl2 = false;
                String key = entry.getKey();
                String value2 = entry.getValue();
                it.write(key + "=" + value2);
                it.newLine();
            }
            it.flush();
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    @NotNull
    public static final String getGoEnvPath() {
        String string = System.getenv("GOENV");
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (SystemInfoRt.isMac) {
            String[] stringArray = new String[]{SystemProperties.getUserHome(), "Library", "Application Support", "go", "env"};
            String string2 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"join(...)");
            return string2;
        }
        if (SystemInfoRt.isWindows) {
            String[] stringArray = new String[]{System.getenv("APPDATA"), "go", "env"};
            String string3 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"join(...)");
            return string3;
        }
        if (SystemInfoRt.isUnix) {
            string = System.getenv("XDG_CONFIG_HOME");
            if (string != null) {
                String it = string;
                boolean bl = false;
                String[] stringArray = new String[]{it, "go", "env"};
                String string4 = FileUtil.join((String[])stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
                return string4;
            }
            String[] stringArray = new String[]{SystemProperties.getUserHome(), ".config", "go", "env"};
            String string5 = FileUtil.join((String[])stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"join(...)");
            return string5;
        }
        return "";
    }

    public static final boolean needToPatchGoProxyInChina(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        boolean enabled = AdvancedSettings.Companion.getBoolean("go.automatic.goproxy.switch");
        if (!enabled) {
            return false;
        }
        VgoProjectSettings vgoProjectSettings = VgoProjectSettings.getInstance(project);
        Intrinsics.checkNotNullExpressionValue((Object)vgoProjectSettings, (String)"getInstance(...)");
        VgoProjectSettings vgoProjectSettings2 = vgoProjectSettings;
        if (!vgoProjectSettings2.isIntegrationEnabled()) {
            return false;
        }
        String string = VgoEnvironmentVariable.GOPROXY.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        EnvironmentVariable systemGoProxy = VgoUtilKt.getVariableFromEnvironment(project, string);
        if (systemGoProxy != null) {
            return false;
        }
        return VgoUtilKt.isMainlandChinaRegion();
    }

    public static final boolean isMainlandChinaRegion() {
        return switch (WhenMappings.$EnumSwitchMapping$0[RegionSettings.getRegion().ordinal()]) {
            case 1 -> true;
            case 2 -> Intrinsics.areEqual((Object)Locale.CHINA.getCountry(), (Object)Locale.getDefault().getCountry());
            default -> false;
        };
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object showGoEnvEditorDialog(@NotNull Project project, @NotNull Continuation<? super Boolean> $completion) {
        if (!($completion instanceof showGoEnvEditorDialog.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                boolean Z$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return VgoUtilKt.showGoEnvEditorDialog(null, (Continuation<? super Boolean>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.L$0 = project;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, String>>, Object>(null){
                    int label;

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Map map = VgoUtilKt.readGoEnv();
                                if (map == null || (map = MapsKt.toMutableMap(map)) == null) {
                                    map = new LinkedHashMap<K, V>();
                                }
                                return map;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl22:
                // 2 sources

                currentEnv = (Map)v0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentEnv);
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Pair<? extends EditSystemGoEnvDialog, ? extends Boolean>>, Object>(project, (Map<String, String>)currentEnv, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ Map<String, String> $currentEnv;
                    {
                        this.$project = $project;
                        this.$currentEnv = $currentEnv;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                EditSystemGoEnvDialog dialog = new EditSystemGoEnvDialog(this.$project, this.$currentEnv);
                                return TuplesKt.to((Object)((Object)dialog), (Object)Boxing.boxBoolean((boolean)dialog.showAndGet()));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Pair<EditSystemGoEnvDialog, Boolean>> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl35
            }
            case 2: {
                currentEnv = (Map)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl35:
                // 2 sources

                var3_7 = (Pair)v1;
                dialog = (EditSystemGoEnvDialog)var3_7.component1();
                applyGoEnv = (Boolean)var3_7.component2();
                if (applyGoEnv) {
                    envs = dialog.getEnvs();
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)currentEnv);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)dialog);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable(envs);
                    $continuation.Z$0 = applyGoEnv;
                    $continuation.label = 3;
                    v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(envs, null){
                        int label;
                        final /* synthetic */ Map<String, String> $envs;
                        {
                            this.$envs = $envs;
                            super(2, $completion);
                        }

                        public final Object invokeSuspend(Object $result) {
                            IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    VgoUtilKt.writeGoEnv(this.$envs);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value2, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    if (v2 == var9_4) {
                        return var9_4;
                    }
                }
                ** GOTO lbl58
            }
            case 3: {
                applyGoEnv = $continuation.Z$0;
                envs = (Map)$continuation.L$3;
                dialog = (EditSystemGoEnvDialog)$continuation.L$2;
                currentEnv = (Map)$continuation.L$1;
                project = (Project)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl58:
                // 2 sources

                return Boxing.boxBoolean((boolean)(applyGoEnv != false));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VgoUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Region.values().length];
            try {
                nArray[Region.CHINA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Region.NOT_SET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

