/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.highlighting;

import com.goide.highlighting.GoAnnotationHolder;
import com.goide.highlighting.errors.GoSpecCheckerUtil;
import com.goide.i18n.GoBundle;
import com.goide.inspections.core.GoInspectionMessage;
import com.goide.inspections.core.GoInspectionMessageWithI18n;
import com.goide.psi.impl.GoPsiUtil;
import com.goide.quickfix.GoDeleteQuickFix;
import com.goide.quickfix.GoShowSdkConfigurableFix;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkVersion;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.mod.inspections.VgoWorkspaceUseDirectivesMergeInspection;
import com.goide.vgo.mod.psi.VgoGoDebugDirective;
import com.goide.vgo.mod.psi.VgoGoVersionDirective;
import com.goide.vgo.mod.psi.VgoIgnoreDirective;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoReplacement;
import com.goide.vgo.mod.psi.VgoRetractDirective;
import com.goide.vgo.mod.psi.VgoRetractSpec;
import com.goide.vgo.mod.psi.VgoToolDirective;
import com.goide.vgo.mod.psi.VgoToolchainDirective;
import com.goide.vgo.mod.psi.VgoTypes;
import com.goide.vgo.mod.psi.VgoVersionRange;
import com.goide.vgo.mod.psi.VgoVisitor;
import com.goide.vgo.mod.psi.impl.VgoOnlyModFileDirective;
import com.goide.vgo.mod.psi.impl.VgoOnlyWorkFileDirective;
import com.goide.vgo.mod.psi.impl.VgoReference;
import com.goide.vgo.mod.quickfix.VgoRunWhyCommandIntention;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoDependencyImpl;
import com.goide.vgo.project.VgoModule;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder unwrappedHolder) {
        if (element == null) {
            VgoAnnotator.$$$reportNull$$$0(0);
        }
        if (unwrappedHolder == null) {
            VgoAnnotator.$$$reportNull$$$0(1);
        }
        if (element.isValid()) {
            GoAnnotationHolder holder = new GoAnnotationHolder(unwrappedHolder);
            PsiFile file2 = element.getContainingFile();
            if (file2 != null && "go.work".equals(file2.getName())) {
                element.accept((PsiElementVisitor)new WorkFileVisitor(holder));
                element.accept((PsiElementVisitor)new VgoWorkspaceUseDirectivesMergeInspection(holder));
            } else {
                element.accept((PsiElementVisitor)new ModFileVisitor(holder));
            }
        }
    }

    @Nullable
    public static VgoModule findVgoModuleFrom(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        Project project;
        if (element == null) {
            VgoAnnotator.$$$reportNull$$$0(2);
        }
        if (!VgoProjectSettings.getInstance(project = element.getProject()).isIntegrationEnabled()) {
            return null;
        }
        Module module = GoUtil.module(element);
        if (module == null) {
            return null;
        }
        PsiFile file2 = element.getContainingFile();
        VirtualFile virtualFile2 = virtualFile = file2 != null ? file2.getOriginalFile().getVirtualFile() : null;
        if (virtualFile == null) {
            return null;
        }
        Pair.NonNull<VgoModule, VgoDependency> pair = VgoUtil.findModuleAndDependencyOfFile(project, module, virtualFile);
        return pair != null ? (VgoModule)pair.first : null;
    }

    @Nullable
    public static PsiFileSystemItem resolveFileReference(@NotNull VgoModuleSpec moduleSpec) {
        FileReference reference;
        if (moduleSpec == null) {
            VgoAnnotator.$$$reportNull$$$0(3);
        }
        return (reference = (FileReference)ContainerUtil.find((Object[])moduleSpec.getReferences(), ref -> ref instanceof VgoReference)) != null ? reference.getFileReferenceSet().resolve() : null;
    }

    public static boolean hasResolvableFileReference(@NotNull VgoModuleSpec moduleSpec) {
        if (moduleSpec == null) {
            VgoAnnotator.$$$reportNull$$$0(4);
        }
        return VgoAnnotator.resolveFileReference(moduleSpec) != null;
    }

    @Nullable
    private static String getKnownDependencyPath(@NotNull VgoModule vgoModule, @NotNull VgoModuleSpec moduleSpec) {
        if (vgoModule == null) {
            VgoAnnotator.$$$reportNull$$$0(5);
        }
        if (moduleSpec == null) {
            VgoAnnotator.$$$reportNull$$$0(6);
        }
        String modulePath = moduleSpec.getIdentifier().getText();
        VgoReplacement replacement = (VgoReplacement)ObjectUtils.tryCast((Object)moduleSpec.getParent(), VgoReplacement.class);
        boolean isReplacementPath = replacement != null && !modulePath.equals(replacement.getSource().getIdentifier().getText());
        VgoDependency dependency = (VgoDependency)ContainerUtil.find(vgoModule.getDependencies(), (Condition)(isReplacementPath ? dep -> VgoAnnotator.isDependencyReplacedWith(dep, modulePath) : dep -> Objects.equals(dep.getImportPath(), modulePath)));
        return (String)ObjectUtils.doIfNotNull((Object)dependency, dep -> dep.getImportPath());
    }

    private static boolean isDependencyReplacedWith(VgoDependency dependency, String replacementModuleName) {
        VgoDependencyImpl impl;
        if (dependency instanceof VgoDependencyImpl && (impl = (VgoDependencyImpl)dependency).getReplace() != null) {
            return Objects.equals(impl.getReplace().getImportPath(), replacementModuleName);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unwrappedHolder";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpec";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModule";
                break;
            }
        }
        objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "findVgoModuleFrom";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveFileReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasResolvableFileReference";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getKnownDependencyPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class WorkFileVisitor
    extends MyVgoBaseVisitor {
        private static final GoDeleteQuickFix DELETE_PROHIBITED_DIRECTIVE_FIX = new GoDeleteQuickFix(() -> GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.statement", (Object[])new Object[0])}), VgoOnlyModFileDirective.class);

        private WorkFileVisitor(@NotNull GoAnnotationHolder holder) {
            if (holder == null) {
                WorkFileVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        @Override
        public void visitOnlyModFileDirective(@NotNull VgoOnlyModFileDirective o) {
            if (o == null) {
                WorkFileVisitor.$$$reportNull$$$0(1);
            }
            super.visitOnlyModFileDirective(o);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.work.error.prohibited.directive");
            GoSpecCheckerUtil.withQuickFix(this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message), DELETE_PROHIBITED_DIRECTIVE_FIX, o, message).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoAnnotator$WorkFileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOnlyModFileDirective";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class ModFileVisitor
    extends MyVgoBaseVisitor {
        private static final GoDeleteQuickFix DELETE_MODULE_DIRECTIVE_FIX = new GoDeleteQuickFix(() -> GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.module.statement", (Object[])new Object[0])}), VgoTypes.MODULE_DIRECTIVE);
        private static final GoDeleteQuickFix DELETE_PROHIBITED_DIRECTIVE_FIX = new GoDeleteQuickFix(() -> GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.statement", (Object[])new Object[0])}), VgoOnlyWorkFileDirective.class);

        private ModFileVisitor(@NotNull GoAnnotationHolder holder) {
            if (holder == null) {
                ModFileVisitor.$$$reportNull$$$0(0);
            }
            super(holder);
        }

        @Override
        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                ModFileVisitor.$$$reportNull$$$0(1);
            }
            super.visitFile(psiFile);
            this.checkModuleStatementUniqueness(psiFile);
        }

        private void checkModuleStatementUniqueness(PsiFile file2) {
            VgoModuleDirective[] directives = (VgoModuleDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, VgoModuleDirective.class);
            if (directives == null) {
                GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.no.module.statement");
                if (GoPsiUtil.isWhiteSpaceOrCommentOrEmpty((PsiElement)file2)) {
                    this.myHolder.newErrorAnnotation(TextRange.EMPTY_RANGE, (GoInspectionMessage)message).fileLevel().create();
                } else {
                    this.myHolder.newErrorAnnotation(TextRange.EMPTY_RANGE, (GoInspectionMessage)message).create();
                }
                return;
            }
            if (directives.length == 1) {
                return;
            }
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.multiple.module.statements");
            for (VgoModuleDirective moduleDirective : directives) {
                GoSpecCheckerUtil.withQuickFix(this.myHolder.newErrorAnnotation(moduleDirective, (GoInspectionMessage)message), DELETE_MODULE_DIRECTIVE_FIX, moduleDirective, message).create();
            }
        }

        @Override
        public void visitOnlyWorkFileDirective(@NotNull VgoOnlyWorkFileDirective o) {
            if (o == null) {
                ModFileVisitor.$$$reportNull$$$0(2);
            }
            super.visitOnlyWorkFileDirective(o);
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.prohibited.directive");
            GoSpecCheckerUtil.withQuickFix(this.myHolder.newErrorAnnotation(o, (GoInspectionMessage)message), DELETE_PROHIBITED_DIRECTIVE_FIX, o, message).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoAnnotator$ModFileVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitOnlyWorkFileDirective";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyVgoBaseVisitor
    extends VgoVisitor {
        private static final GoDeleteQuickFix DELETE_VERSION_DIRECTIVE_FIX = new GoDeleteQuickFix(() -> GoBundle.message((String)"go.fix.delete.name", (Object[])new Object[]{GoBundle.message((String)"go.terms.version.statement", (Object[])new Object[0])}), VgoTypes.GO_VERSION_DIRECTIVE);
        protected final GoAnnotationHolder myHolder;

        private MyVgoBaseVisitor(@NotNull GoAnnotationHolder holder) {
            if (holder == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(0);
            }
            this.myHolder = holder;
        }

        public void visitFile(@NotNull PsiFile psiFile) {
            if (psiFile == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(1);
            }
            super.visitFile(psiFile);
            this.checkGoVersionStatementUniqueness(psiFile);
        }

        @Override
        public void visitModuleSpec(@NotNull VgoModuleSpec o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(2);
            }
            super.visitModuleSpec(o);
            this.addGoModWhyIntention(o);
        }

        @Override
        public void visitRetractDirective(@NotNull VgoRetractDirective o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(3);
            }
            super.visitRetractDirective(o);
            if (!GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o)).supportsRetractDirective()) {
                this.markUnsupportedDirective(o.getRetract(), GoSdk.RETRACT_DIRECTIVE_VERSION);
                return;
            }
            for (VgoRetractSpec spec : o.getRetractSpecList()) {
                VgoVersionRange range = spec.getVersionRange();
                if (range == null || range.getVersions().size() == 2) continue;
                this.myHolder.newErrorAnnotation(range, (GoInspectionMessage)GoInspectionMessageWithI18n.message("go.go.mod.retract.wrong.range.format")).create();
            }
        }

        @Override
        public void visitToolchainDirective(@NotNull VgoToolchainDirective o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(4);
            }
            super.visitToolchainDirective(o);
            if (!GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o)).supportsToolchains()) {
                this.markUnsupportedDirective(o.getToolchain(), GoSdk.TOOLCHAINS_VERSION);
            }
        }

        private void checkGoVersionStatementUniqueness(PsiFile file2) {
            VgoGoVersionDirective[] directives = (VgoGoVersionDirective[])PsiTreeUtil.getChildrenOfType((PsiElement)file2, VgoGoVersionDirective.class);
            if (directives == null || directives.length < 2) {
                return;
            }
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.multiple.version.statements");
            for (VgoGoVersionDirective goVersionDirective : directives) {
                GoSpecCheckerUtil.withQuickFix(this.myHolder.newErrorAnnotation(goVersionDirective, (GoInspectionMessage)message), DELETE_VERSION_DIRECTIVE_FIX, goVersionDirective, message).create();
            }
        }

        private void addGoModWhyIntention(@NotNull VgoModuleSpec moduleSpec) {
            VgoModule vgoModule;
            if (moduleSpec == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(5);
            }
            if ((vgoModule = VgoAnnotator.findVgoModuleFrom(moduleSpec)) == null) {
                return;
            }
            String knownReplacedDependencyPath = VgoAnnotator.getKnownDependencyPath(vgoModule, moduleSpec);
            if (knownReplacedDependencyPath != null) {
                this.myHolder.newSilentInfoAnnotation(moduleSpec).withFix((IntentionAction)new VgoRunWhyCommandIntention(knownReplacedDependencyPath)).create();
            }
        }

        @Override
        public void visitGoDebugDirective(@NotNull VgoGoDebugDirective o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(6);
            }
            super.visitGoDebugDirective(o);
            if (!GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o)).supportsGoDebugDirectiveInGoModFile()) {
                this.markUnsupportedDirective(o.getGodebug(), GoSdk.GODEBUG_DIRECTIVE_VERSION);
            }
        }

        @Override
        public void visitToolDirective(@NotNull VgoToolDirective o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(7);
            }
            super.visitToolDirective(o);
            if (!GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o)).supportsToolDirective()) {
                this.markUnsupportedDirective(o.getTool(), GoSdk.TOOL_DIRECTIVE_VERSION);
            }
        }

        @Override
        public void visitIgnoreDirective(@NotNull VgoIgnoreDirective o) {
            if (o == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(8);
            }
            super.visitIgnoreDirective(o);
            if (!GoSdkService.getInstance(o.getProject()).getSdk(GoUtil.module(o)).supportsIgnoreDirective()) {
                this.markUnsupportedDirective(o.getIgnore(), GoSdk.IGNORE_DIRECTIVE_VERSION);
            }
        }

        private void markUnsupportedDirective(@NotNull PsiElement keyword, @NotNull GoSdkVersion minVersion) {
            if (keyword == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(9);
            }
            if (minVersion == null) {
                MyVgoBaseVisitor.$$$reportNull$$$0(10);
            }
            GoInspectionMessageWithI18n message = GoInspectionMessageWithI18n.message("go.go.mod.error.annotator.directive.not.supported", keyword.getText(), minVersion.toString());
            GoSpecCheckerUtil.withQuickFix(this.myHolder.newErrorAnnotation(keyword, (GoInspectionMessage)message), new GoShowSdkConfigurableFix(), keyword, message).create();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleSpec";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "keyword";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "minVersion";
                    break;
                }
            }
            objectArray2[1] = "com/goide/vgo/mod/highlighting/VgoAnnotator$MyVgoBaseVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitFile";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitModuleSpec";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitRetractDirective";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitToolchainDirective";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addGoModWhyIntention";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitGoDebugDirective";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitToolDirective";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitIgnoreDirective";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[2] = "markUnsupportedDirective";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

