/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.intentions;

import com.goide.GoTypes;
import com.goide.intentions.GoBaseIntentionAction;
import com.goide.refactor.util.GoRefactoringUtil;
import com.goide.vgo.mod.intentions.merge.VgoDirectiveMerge;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J!\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00162\u0006\u0010\u0017\u001a\u00020\u000eH$J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u000e*\u00020\u000eH\u0004J\u0014\u0010\u0019\u001a\u00020\b*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u000eH\u0004R\u0018\u0010\u001b\u001a\u00020\b*\u00020\u000e8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001d"}, d2={"Lcom/goide/vgo/mod/intentions/VgoBaseMergeDirectivesIntention;", "Lcom/goide/intentions/GoBaseIntentionAction;", "<init>", "()V", "getText", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isAvailable", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "element", "Lcom/intellij/psi/PsiElement;", "invoke", "", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "findRelevantDirectives", "", "contextElement", "findClosestDirectiveParent", "canBeMergedWith", "targetDirective", "isTrivia", "(Lcom/intellij/psi/PsiElement;)Z", "intellij.go.impl"})
public abstract class VgoBaseMergeDirectivesIntention
extends GoBaseIntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFamilyName(...)");
        return string;
    }

    @Override
    public boolean isAvailable(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return super.isAvailable(project, editor, element) && this.findRelevantDirectives(element).iterator().hasNext();
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        List<PsiElement> directives = this.findRelevantDirectives(element);
        if (!directives.iterator().hasNext()) {
            return;
        }
        GoRefactoringUtil.withVerticalScrollingSaved(editor, () -> VgoBaseMergeDirectivesIntention.invoke$lambda$0(directives, project));
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        PsiElement psiElement = this.getElement(editor, psiFile);
        if (psiElement == null) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiElement contextElement = psiElement;
        List<PsiElement> directives = this.findRelevantDirectives(contextElement);
        if (!directives.iterator().hasNext()) {
            IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
            return intentionPreviewInfo;
        }
        PsiElement result = new VgoDirectiveMerge(directives, project).getPreview();
        return (IntentionPreviewInfo)new IntentionPreviewInfo.CustomDiff(psiFile.getFileType(), "", result.getText());
    }

    @NotNull
    protected abstract List<PsiElement> findRelevantDirectives(@NotNull PsiElement var1);

    @Nullable
    protected final PsiElement findClosestDirectiveParent(@NotNull PsiElement $this$findClosestDirectiveParent) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestDirectiveParent, (String)"<this>");
        Class<? extends PsiElement>[] classArray = VgoDirectiveMerge.Companion.getSupportedDirectives();
        return PsiTreeUtil.getParentOfType((PsiElement)$this$findClosestDirectiveParent, (Class[])Arrays.copyOf(classArray, classArray.length));
    }

    protected final boolean canBeMergedWith(@NotNull PsiElement $this$canBeMergedWith, @NotNull PsiElement targetDirective) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeMergedWith, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)targetDirective, (String)"targetDirective");
        return VgoDirectiveMerge.Companion.isSupportedFor($this$canBeMergedWith, targetDirective);
    }

    protected final boolean isTrivia(@NotNull PsiElement $this$isTrivia) {
        Intrinsics.checkNotNullParameter((Object)$this$isTrivia, (String)"<this>");
        return $this$isTrivia instanceof PsiWhiteSpace || $this$isTrivia instanceof PsiComment || $this$isTrivia.getNode().getElementType() == GoTypes.SEMICOLON;
    }

    private static final void invoke$lambda$0(List $directives, Project $project) {
        new VgoDirectiveMerge($directives, $project).perform();
    }
}

