/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.psi.impl;

import com.goide.vgo.mod.VgoLanguage;
import com.goide.vgo.mod.psi.VgoExcludeDirective;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoGoVersionDirective;
import com.goide.vgo.mod.psi.VgoModuleDirective;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.mod.psi.VgoReplaceDirective;
import com.goide.vgo.mod.psi.VgoRequireDirective;
import com.goide.vgo.mod.psi.VgoRetractDirective;
import com.goide.vgo.mod.psi.VgoTypes;
import com.goide.vgo.mod.psi.VgoUseDirective;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoElementFactory {
    private VgoElementFactory() {
    }

    @Nullable
    public static VgoModuleSpec createModuleSpec(@NotNull Project project, @NonNls @NotNull String dependencyText) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(0);
        }
        if (dependencyText == null) {
            VgoElementFactory.$$$reportNull$$$0(1);
        }
        VgoFile file2 = VgoElementFactory.createFileFromText(project, "module name\nreplace (\n" + dependencyText + "\n)");
        return (VgoModuleSpec)PsiTreeUtil.findChildOfType((PsiElement)file2, VgoModuleSpec.class);
    }

    @Nullable
    public static VgoModuleDirective createModuleDirective(@NotNull Project project, @NonNls @NotNull String moduleName) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            VgoElementFactory.$$$reportNull$$$0(3);
        }
        VgoFile file2 = VgoElementFactory.createFileFromText(project, "module " + moduleName);
        return (VgoModuleDirective)PsiTreeUtil.findChildOfType((PsiElement)file2, VgoModuleDirective.class);
    }

    @NotNull
    public static VgoGoVersionDirective createGoVersionDirective(@NotNull Project project, @NotNull String goVersion) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(4);
        }
        if (goVersion == null) {
            VgoElementFactory.$$$reportNull$$$0(5);
        }
        VgoFile file2 = VgoElementFactory.createFileFromText(project, "module name\ngo " + goVersion);
        VgoGoVersionDirective vgoGoVersionDirective = Objects.requireNonNull((VgoGoVersionDirective)PsiTreeUtil.findChildOfType((PsiElement)file2, VgoGoVersionDirective.class));
        if (vgoGoVersionDirective == null) {
            VgoElementFactory.$$$reportNull$$$0(6);
        }
        return vgoGoVersionDirective;
    }

    @NotNull
    public static VgoUseDirective createUseDirective(@NotNull Project project, @NotNull Collection<String> moduleSpecs) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(7);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(8);
        }
        return VgoElementFactory.createDirective(VgoTypes.USE, VgoUseDirective.class, moduleSpecs, project);
    }

    @NotNull
    public static VgoRequireDirective createRequireDirective(@NotNull Project project, @NotNull Collection<String> moduleSpecs) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(9);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(10);
        }
        return VgoElementFactory.createDirective(VgoTypes.REQUIRE, VgoRequireDirective.class, moduleSpecs, project);
    }

    @NotNull
    public static VgoReplaceDirective createReplaceDirective(@NotNull Project project, @NotNull Collection<String> replacements) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(11);
        }
        if (replacements == null) {
            VgoElementFactory.$$$reportNull$$$0(12);
        }
        return VgoElementFactory.createDirective(VgoTypes.REPLACE, VgoReplaceDirective.class, replacements, project);
    }

    @NotNull
    public static VgoExcludeDirective createExcludeDirective(@NotNull Project project, @NotNull Collection<String> moduleSpecs) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(13);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(14);
        }
        return VgoElementFactory.createDirective(VgoTypes.EXCLUDE, VgoExcludeDirective.class, moduleSpecs, project);
    }

    @NotNull
    public static VgoRetractDirective createRetractDirective(@NotNull Project project, @NotNull Collection<String> moduleSpecs) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(15);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(16);
        }
        return VgoElementFactory.createDirective(VgoTypes.RETRACT, VgoRetractDirective.class, moduleSpecs, project);
    }

    @NotNull
    public static String createUseDirective(@NotNull Collection<String> moduleSpecs) {
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(17);
        }
        return VgoElementFactory.buildDirectiveText(VgoTypes.USE, moduleSpecs);
    }

    @NotNull
    private static <T extends PsiElement> T createDirective(@NotNull IElementType elementType, @NotNull Class<T> directiveClass, @NotNull Collection<String> moduleSpecs, @NotNull Project project) {
        if (elementType == null) {
            VgoElementFactory.$$$reportNull$$$0(18);
        }
        if (directiveClass == null) {
            VgoElementFactory.$$$reportNull$$$0(19);
        }
        if (moduleSpecs == null) {
            VgoElementFactory.$$$reportNull$$$0(20);
        }
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(21);
        }
        String directiveText = VgoElementFactory.buildDirectiveText(elementType, moduleSpecs);
        VgoFile file2 = VgoElementFactory.createFileFromText(project, directiveText);
        PsiElement psiElement = Objects.requireNonNull(PsiTreeUtil.findChildOfType((PsiElement)file2, directiveClass));
        if (psiElement == null) {
            VgoElementFactory.$$$reportNull$$$0(22);
        }
        return (T)psiElement;
    }

    @NotNull
    private static String buildDirectiveText(@NotNull IElementType elementType, @NotNull Collection<String> specTexts) {
        if (elementType == null) {
            VgoElementFactory.$$$reportNull$$$0(23);
        }
        if (specTexts == null) {
            VgoElementFactory.$$$reportNull$$$0(24);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(elementType).append(' ');
        if (specTexts.size() == 1) {
            sb.append((String)ContainerUtil.getOnlyItem(specTexts));
        } else {
            sb.append("(\n");
            for (String spec : specTexts) {
                sb.append('\t').append(spec).append('\n');
            }
            sb.append(')');
        }
        String string = sb.toString();
        if (string == null) {
            VgoElementFactory.$$$reportNull$$$0(25);
        }
        return string;
    }

    @NotNull
    public static PsiElement createIdentifier(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(26);
        }
        if (text == null) {
            VgoElementFactory.$$$reportNull$$$0(27);
        }
        PsiElement psiElement = Objects.requireNonNull(VgoElementFactory.createFileFromText(project, "module %s".formatted(text)).getLastChild().getLastChild());
        if (psiElement == null) {
            VgoElementFactory.$$$reportNull$$$0(28);
        }
        return psiElement;
    }

    @NotNull
    public static String quoteModuleSpecIfNeeded(@NotNull String moduleSpec) {
        if (moduleSpec == null) {
            VgoElementFactory.$$$reportNull$$$0(29);
        }
        if (moduleSpec.startsWith("\"")) {
            String string = moduleSpec;
            if (string == null) {
                VgoElementFactory.$$$reportNull$$$0(30);
            }
            return string;
        }
        String string = StringUtil.containsAnyChar((String)moduleSpec, (String)" ,[]\t\n\r") ? StringUtil.wrapWithDoubleQuote((String)moduleSpec) : moduleSpec;
        if (string == null) {
            VgoElementFactory.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    public static VgoFile createFileFromText(@NotNull Project project, @NonNls @NotNull String text) {
        if (project == null) {
            VgoElementFactory.$$$reportNull$$$0(32);
        }
        if (text == null) {
            VgoElementFactory.$$$reportNull$$$0(33);
        }
        VgoFile vgoFile = (VgoFile)PsiFileFactory.getInstance((Project)project).createFileFromText("go.mod", (Language)VgoLanguage.INSTANCE, (CharSequence)text);
        if (vgoFile == null) {
            VgoElementFactory.$$$reportNull$$$0(34);
        }
        return vgoFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 22, 25, 28, 30, 31, 34 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyText";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "goVersion";
                break;
            }
            case 6: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/psi/impl/VgoElementFactory";
                break;
            }
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpecs";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directiveClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specTexts";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/psi/impl/VgoElementFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createGoVersionDirective";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createDirective";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDirectiveText";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIdentifier";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "quoteModuleSpecIfNeeded";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSpec";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDirective";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createGoVersionDirective";
                break;
            }
            case 6: 
            case 22: 
            case 25: 
            case 28: 
            case 30: 
            case 31: 
            case 34: {
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createUseDirective";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createRequireDirective";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createReplaceDirective";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createExcludeDirective";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createRetractDirective";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDirective";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "buildDirectiveText";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createIdentifier";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "quoteModuleSpecIfNeeded";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createFileFromText";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 22, 25, 28, 30, 31, 34 -> new IllegalStateException(string);
        };
    }
}

