/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.mod.quickfix;

import com.goide.codeInsight.imports.GoImportOptimizer;
import com.goide.i18n.GoBundle;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.util.GoExecutor;
import com.goide.util.GoHistoryProcessListener;
import com.goide.util.GoUtil;
import com.goide.vgo.VgoIntegrationManager;
import com.goide.vgo.VgoStatusTracker;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.project.VgoModuleOrWorkspace;
import com.goide.vgo.project.VgoWorkspace;
import com.goide.vgo.project.VgoWorkspaceModule;
import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VgoSyncDependencyFix
implements HighPriorityAction,
LocalQuickFix {
    private final Project myProject;
    @NotNull
    private final VgoModuleOrWorkspace myModuleOrWorkspace;
    @NotNull
    private final Action myAction;

    public VgoSyncDependencyFix(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(0);
        }
        if (moduleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(1);
        }
        this(project, moduleOrWorkspace, Action.SYNC);
    }

    public VgoSyncDependencyFix(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace, @NotNull Action action) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(2);
        }
        if (moduleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(3);
        }
        if (action == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myModuleOrWorkspace = moduleOrWorkspace;
        this.myAction = action;
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getName() {
        String string = this.myAction.getPresentableName(this.myProject, this.myModuleOrWorkspace);
        if (string == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = GoBundle.message((String)"go.settings.modules.sync.dependencies.fix.family.name", (Object[])new Object[0]);
        if (string == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(9);
        }
        if (project.isDisposed()) {
            return;
        }
        PsiElement element = descriptor.getPsiElement();
        if (element != null && element.isValid()) {
            VgoSyncDependencyFix.applyFix(project, GoUtil.module(element), this.myModuleOrWorkspace, this.getName(), this.myAction);
        }
    }

    public static void applyFix(@NotNull Project project, @Nullable Module module, @NotNull VgoModuleOrWorkspace moduleOrWorkspace, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String presentableName, @NotNull Action action) {
        VirtualFile moduleRoot;
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(10);
        }
        if (moduleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(11);
        }
        if (presentableName == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(12);
        }
        if (action == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(13);
        }
        if ((moduleRoot = moduleOrWorkspace.getRoot()).isValid()) {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            if (!sdk.isValid()) {
                return;
            }
            VgoStatusTracker.startExplicitModuleCacheUpdate(module);
            GoImportOptimizer.disableImportOptimization();
            FileDocumentManager.getInstance().saveAllDocuments();
            CommandProcessor.getInstance().runUndoTransparentAction(() -> {
                List<Command> commands = action.getCommands(project, moduleOrWorkspace);
                VgoSyncDependencyFix.executeCommands(project, module, moduleOrWorkspace, presentableName, new GoHistoryProcessListener(), commands, () -> {
                    VgoStatusTracker.finishExplicitModuleCacheUpdate(module);
                    GoImportOptimizer.enableImportOptimization();
                    VgoSyncDependencyFix.syncModules(project, module, moduleOrWorkspace, action == Action.VENDOR || action == Action.SYNC, true);
                });
            });
        }
    }

    private static void executeCommands(@NotNull Project project, @Nullable Module module, @NotNull VgoModuleOrWorkspace vgoModuleOrWorkspace, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String presentableName, @NotNull GoHistoryProcessListener listener2, @NotNull List<Command> commands, @NotNull Runnable onFinish) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(14);
        }
        if (vgoModuleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(15);
        }
        if (presentableName == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(16);
        }
        if (listener2 == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(17);
        }
        if (commands == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(18);
        }
        if (onFinish == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(19);
        }
        if (commands.isEmpty()) {
            onFinish.run();
            return;
        }
        VirtualFile moduleRoot = vgoModuleOrWorkspace.getRoot();
        Command command = commands.get(0);
        boolean singleCommand = commands.size() == 1;
        VgoSyncDependencyFix.makeExecutor(project, module, moduleRoot, presentableName).withParameters(command.getSubcommands()).showNotifications(false, singleCommand).executeWithProgress(true, true, listener2, VgoSyncDependencyFix.commandKey(moduleRoot), result -> {
            if (!singleCommand && result.status == GoExecutor.ExecutionResult.Status.SUCCEEDED) {
                VgoSyncDependencyFix.executeCommands(project, module, vgoModuleOrWorkspace, presentableName, listener2, ContainerUtil.subList((List)commands, (int)1), onFinish);
            } else {
                onFinish.run();
            }
        });
    }

    private static GoExecutor makeExecutor(@NotNull Project project, @Nullable Module module, @NotNull VirtualFile moduleRoot, @Nls(capitalization=Nls.Capitalization.Sentence) @NotNull String presentableName) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(20);
        }
        if (moduleRoot == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(21);
        }
        if (presentableName == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(22);
        }
        return GoExecutor.in(project, module).withPresentableName(presentableName).withWorkDirectory(moduleRoot.getPath()).withPtyEnabled(false).withPrintingOutputAsStatus();
    }

    @NotNull
    private static String commandKey(@NotNull VirtualFile moduleRoot) {
        if (moduleRoot == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(23);
        }
        String string = "vgo.sync.command.executor.key." + moduleRoot.getPath();
        if (string == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(24);
        }
        return string;
    }

    public static boolean shouldUpdateVendor(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(25);
        }
        if (moduleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(26);
        }
        return VgoUtil.isVendoringMode(project) && moduleOrWorkspace.hasVendor(project);
    }

    public static void syncModules(@NotNull Project project, @Nullable Module module, @NotNull VirtualFile moduleRoot, boolean shouldUpdateVendor, boolean async) {
        VirtualFile vendor;
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(27);
        }
        if (moduleRoot == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(28);
        }
        if (shouldUpdateVendor && (vendor = moduleRoot.findChild("vendor")) != null && vendor.isValid()) {
            VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{vendor});
            return;
        }
        if (async) {
            VirtualFileManager.getInstance().asyncRefresh(() -> VgoSyncDependencyFix.scheduleUpdatingDependencies(project, module, moduleRoot));
        } else {
            VirtualFileManager.getInstance().syncRefresh();
            VgoSyncDependencyFix.scheduleUpdatingDependencies(project, module, moduleRoot);
        }
    }

    public static void syncModules(@NotNull Project project, @Nullable Module module, @NotNull VgoModuleOrWorkspace vgoModuleOrWorkspace, boolean shouldUpdateVendor, boolean async) {
        VirtualFile virtualFile;
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(29);
        }
        if (vgoModuleOrWorkspace == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(30);
        }
        if (vgoModuleOrWorkspace instanceof VgoWorkspaceModule) {
            VgoWorkspaceModule workspaceModule = (VgoWorkspaceModule)vgoModuleOrWorkspace;
            virtualFile = workspaceModule.getWorkspace().getRoot();
        } else {
            virtualFile = vgoModuleOrWorkspace.getRoot();
        }
        VirtualFile root = virtualFile;
        VgoSyncDependencyFix.syncModules(project, module, root, shouldUpdateVendor, async);
    }

    static void scheduleUpdatingDependencies(@NotNull Project project, @Nullable Module module, VirtualFile ... moduleRoots) {
        if (project == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(31);
        }
        if (moduleRoots == null) {
            VgoSyncDependencyFix.$$$reportNull$$$0(32);
        }
        if (project.isDisposed() || module != null && module.isDisposed()) {
            return;
        }
        VgoStatusTracker tracker = VgoIntegrationManager.getInstance(project).getTracker(module);
        if (tracker != null) {
            List settingsFiles = ContainerUtil.mapNotNull((Object[])moduleRoots, moduleRoot -> (VirtualFile)ObjectUtils.chooseNotNull((Object)moduleRoot.findChild("go.work"), (Object)moduleRoot.findChild("go.mod")));
            tracker.scheduleUpdatingDependencies(settingsFiles, false);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 11: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrWorkspace";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: 
            case 7: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 12: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 15: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vgoModuleOrWorkspace";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commands";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onFinish";
                break;
            }
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoot";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "commandKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
            case 6: 
            case 7: 
            case 24: {
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "executeCommands";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "makeExecutor";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commandKey";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "shouldUpdateVendor";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "syncModules";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUpdatingDependencies";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 24 -> new IllegalStateException(string);
        };
    }

    public static enum Action {
        TIDY,
        VENDOR,
        DOWNLOAD,
        SYNC;


        @NotNull
        @Nls(capitalization=Nls.Capitalization.Sentence)
        public String getPresentableName(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
            if (project == null) {
                Action.$$$reportNull$$$0(0);
            }
            if (moduleOrWorkspace == null) {
                Action.$$$reportNull$$$0(1);
            }
            List<Command> commands = this.getCommands(project, moduleOrWorkspace);
            String joined = Strings.join(commands, Command::getPresentableName, (String)", ");
            String string = GoBundle.message((String)"go.settings.modules.sync.dependencies.fix.text", (Object[])new Object[]{joined});
            if (string == null) {
                Action.$$$reportNull$$$0(2);
            }
            return string;
        }

        private List<Command> getCommands(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
            if (project == null) {
                Action.$$$reportNull$$$0(3);
            }
            if (moduleOrWorkspace == null) {
                Action.$$$reportNull$$$0(4);
            }
            boolean shouldUpdateVendor = this != SYNC ? this == VENDOR : VgoSyncDependencyFix.shouldUpdateVendor(project, moduleOrWorkspace);
            return shouldUpdateVendor ? Action.makeVendorSyncCommands(project, moduleOrWorkspace) : Action.makeModuleCacheSyncCommands(moduleOrWorkspace);
        }

        @NotNull
        private static List<Command> makeVendorSyncCommands(@NotNull Project project, @NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
            if (project == null) {
                Action.$$$reportNull$$$0(5);
            }
            if (moduleOrWorkspace == null) {
                Action.$$$reportNull$$$0(6);
            }
            if (moduleOrWorkspace instanceof VgoWorkspaceModule || moduleOrWorkspace instanceof VgoWorkspace) {
                List<Command> list = List.of(Command.WORKSPACE_VENDOR);
                if (list == null) {
                    Action.$$$reportNull$$$0(7);
                }
                return list;
            }
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(null);
            List<Command> list = sdk.doesModTidyDuringModVendor() ? List.of(Command.VENDOR) : List.of(Command.TIDY, Command.VENDOR);
            if (list == null) {
                Action.$$$reportNull$$$0(8);
            }
            return list;
        }

        @NotNull
        private static List<Command> makeModuleCacheSyncCommands(@NotNull VgoModuleOrWorkspace moduleOrWorkspace) {
            if (moduleOrWorkspace == null) {
                Action.$$$reportNull$$$0(9);
            }
            List<Command> list = moduleOrWorkspace instanceof VgoWorkspaceModule || moduleOrWorkspace instanceof VgoWorkspace ? List.of(Command.TIDY, Command.DOWNLOAD) : List.of(Command.TIDY);
            if (list == null) {
                Action.$$$reportNull$$$0(10);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 7, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleOrWorkspace";
                    break;
                }
                case 2: 
                case 7: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix$Action";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix$Action";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeVendorSyncCommands";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeModuleCacheSyncCommands";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 2: 
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getCommands";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "makeVendorSyncCommands";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "makeModuleCacheSyncCommands";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 7, 8, 10 -> new IllegalStateException(string);
            };
        }
    }

    public static enum Command {
        TIDY("mod", "tidy"),
        VENDOR("mod", "vendor"),
        WORKSPACE_VENDOR("work", "vendor"),
        DOWNLOAD("mod", "download");

        @NotNull
        @NlsSafe
        private final List<String> mySubcommands;

        private Command(String ... subcommands) {
            if (subcommands == null) {
                Command.$$$reportNull$$$0(0);
            }
            this.mySubcommands = Arrays.asList(subcommands);
        }

        @NotNull
        public Collection<String> getSubcommands() {
            List<String> list = this.mySubcommands;
            if (list == null) {
                Command.$$$reportNull$$$0(1);
            }
            return list;
        }

        @NotNull
        @NlsSafe
        public String getPresentableName() {
            String string = "go " + Strings.join(this.getSubcommands(), (String)" ");
            if (string == null) {
                Command.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "subcommands";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix$Command";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/goide/vgo/mod/quickfix/VgoSyncDependencyFix$Command";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSubcommands";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }
}

