/*
 * Decompiled with CFR 0.152.
 */
package com.goide.vgo.project;

import com.goide.project.GoRootsProvider;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.GoSdkUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.configuration.VgoProjectSettings;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VgoRootsProvider
implements GoRootsProvider {
    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathRoots(@Nullable Project project, @Nullable Module module) {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            VgoRootsProvider.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathSourcesRoots(@Nullable Project project, @Nullable Module module) {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            VgoRootsProvider.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getGoPathBinRoots(@Nullable Project project, @Nullable Module module) {
        List<VirtualFile> list = Collections.emptyList();
        if (list == null) {
            VgoRootsProvider.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean isExternal() {
        return false;
    }

    @Override
    @NotNull
    public ThreeState indexGoPathSources(@NotNull Project project) {
        if (project == null) {
            VgoRootsProvider.$$$reportNull$$$0(3);
        }
        ThreeState threeState = VgoProjectSettings.getInstance(project).isIntegrationEnabled() ? ThreeState.NO : ThreeState.UNSURE;
        if (threeState == null) {
            VgoRootsProvider.$$$reportNull$$$0(4);
        }
        return threeState;
    }

    @Override
    @Nullable
    public Collection<VirtualFile> getVendorDirectoriesInResolveScope(@NotNull Project project, @Nullable Module module, @Nullable VirtualFile file2) {
        if (project == null) {
            VgoRootsProvider.$$$reportNull$$$0(5);
        }
        if (file2 == null || module == null || !VgoProjectSettings.getInstance(project).isIntegrationEnabled() || !VgoUtil.isVendoringMode(project)) {
            return null;
        }
        if (GoSdkUtil.isInSdk(project, module, file2)) {
            GoSdk sdk = GoSdkService.getInstance(project).getSdk(module);
            VirtualFile sdkRoot = Objects.requireNonNull(sdk.getSrcDir());
            List<VirtualFile> vendors = GoSdkUtil.collectVendorDirectories(file2, Collections.singleton(sdkRoot));
            if (vendors.isEmpty()) {
                return vendors;
            }
            if (sdkRoot.findChild("go.mod") == null) {
                return vendors;
            }
            return vendors.subList(0, 1);
        }
        Collection<VgoModule> vgoModules = VgoModulesRegistry.getInstance(project).getModules(module);
        Set vgoModuleRoots = ContainerUtil.map2Set(vgoModules, VgoModule::getRoot);
        List<VirtualFile> vendors = GoSdkUtil.collectVendorDirectories(file2, vgoModuleRoots);
        VirtualFile vendorInClosestParentModule = (VirtualFile)ContainerUtil.find(vendors, vendor -> vgoModuleRoots.contains(vendor.getParent()));
        return ContainerUtil.createMaybeSingletonSet((Object)vendorInClosestParentModule);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/vgo/project/VgoRootsProvider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathRoots";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathSourcesRoots";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGoPathBinRoots";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/vgo/project/VgoRootsProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "indexGoPathSources";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "indexGoPathSources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getVendorDirectoriesInResolveScope";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 5 -> new IllegalArgumentException(string);
        };
    }
}

