/*
 * Decompiled with CFR 0.152.
 */
package com.goide.watchers;

import com.goide.GoEnvironmentUtil;
import com.goide.GoFileType;
import com.goide.formatter.settings.GoCodeStyleSettings;
import com.goide.sdk.GoSdkUtil;
import com.goide.watchers.GoConflictingActionsOnSaveNotificationManager;
import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.plugins.watcher.model.ApplicationTasksOptions;
import com.intellij.plugins.watcher.model.ProjectTasksOptions;
import com.intellij.plugins.watcher.model.TaskOptions;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00020\u00100\rH\u0002\u001a \u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\r*\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u001c\u0010\u0013\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u001c\u0010\u0016\u001a\u00020\u0002*\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a$\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00020\u0019H\u0002\"$\u0010\u0000\u001a\u0015\u0012\f\u0012\n \u0003*\u0004\u0018\u00010\u00020\u00020\u0001\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001a"}, d2={"FORMATTERS_CONFLICT_OCCURRED_KEY", "Lcom/intellij/openapi/util/KeyWithDefaultValue;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getFORMATTERS_CONFLICT_OCCURRED_KEY", "()Lcom/intellij/openapi/util/KeyWithDefaultValue;", "checkFormatterAndWatchersSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "disableGoFmtOnSaveActions", "getConflictingFileWatchers", "Lkotlin/sequences/Sequence;", "Lcom/intellij/plugins/watcher/model/TaskOptions;", "filterEnabledOnGoFiles", "Lcom/intellij/openapi/util/Pair;", "filterKnownFormatters", "isGoFmtWatcher", "isWritingWatcherWithName", "programName", "", "checkProgramExists", "checkProgramNameOnWindowsIfNeeded", "predicate", "Lkotlin/Function1;", "intellij.go.watchers"})
@SourceDebugExtension(value={"SMAP\nGoFileWatchersDeprecationStartupActivity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoFileWatchersDeprecationStartupActivity.kt\ncom/goide/watchers/GoFileWatchersDeprecationStartupActivityKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,164:1\n30#2,2:165\n1#3:167\n*S KotlinDebug\n*F\n+ 1 GoFileWatchersDeprecationStartupActivity.kt\ncom/goide/watchers/GoFileWatchersDeprecationStartupActivityKt\n*L\n70#1:165,2\n*E\n"})
public final class GoFileWatchersDeprecationStartupActivityKt {
    @NotNull
    private static final KeyWithDefaultValue<Boolean> FORMATTERS_CONFLICT_OCCURRED_KEY;

    @NotNull
    public static final KeyWithDefaultValue<Boolean> getFORMATTERS_CONFLICT_OCCURRED_KEY() {
        return FORMATTERS_CONFLICT_OCCURRED_KEY;
    }

    private static final void checkFormatterAndWatchersSettings(Project project) {
        block2: {
            CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)project).getCustomSettings(GoCodeStyleSettings.class);
            Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
            GoCodeStyleSettings settings = (GoCodeStyleSettings)customCodeStyleSettings;
            if (!settings.RUN_GO_FMT_ON_REFORMAT) {
                return;
            }
            TaskOptions conflictingWatcher = (TaskOptions)SequencesKt.firstOrNull(GoFileWatchersDeprecationStartupActivityKt.getConflictingFileWatchers(project));
            boolean hasConflictingWatchers = conflictingWatcher != null;
            FORMATTERS_CONFLICT_OCCURRED_KEY.set((UserDataHolder)project, (Object)hasConflictingWatchers);
            TaskOptions taskOptions = conflictingWatcher;
            if (taskOptions == null) break block2;
            TaskOptions it = taskOptions;
            boolean bl = false;
            GoFileWatchersDeprecationStartupActivityKt.disableGoFmtOnSaveActions(project);
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GoConflictingActionsOnSaveNotificationManager> serviceClass$iv = GoConflictingActionsOnSaveNotificationManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            GoConflictingActionsOnSaveNotificationManager goConflictingActionsOnSaveNotificationManager = (GoConflictingActionsOnSaveNotificationManager)object;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            goConflictingActionsOnSaveNotificationManager.notify(string);
        }
    }

    private static final void disableGoFmtOnSaveActions(Project project) {
        CustomCodeStyleSettings customCodeStyleSettings = CodeStyle.getSettings((Project)project).getCustomSettings(GoCodeStyleSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)customCodeStyleSettings, (String)"getCustomSettings(...)");
        GoCodeStyleSettings goCodeStyleSettings = (GoCodeStyleSettings)customCodeStyleSettings;
        goCodeStyleSettings.RUN_GO_FMT_ON_REFORMAT = false;
        CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
    }

    @NotNull
    public static final Sequence<TaskOptions> getConflictingFileWatchers(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ProjectTasksOptions projectFileWatcherOptions = ProjectTasksOptions.getInstance((Project)project);
        if (!projectFileWatcherOptions.containWatcherWithFileType((FileType)GoFileType.INSTANCE)) {
            return SequencesKt.emptySequence();
        }
        ApplicationTasksOptions applicationFileWatcherOptions = ApplicationTasksOptions.getInstance();
        List list = projectFileWatcherOptions.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTasks(...)");
        Sequence sequence = CollectionsKt.asSequence((Iterable)list);
        List list2 = applicationFileWatcherOptions.getTasks();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getTasks(...)");
        Sequence allFileWatchers = SequencesKt.plus((Sequence)sequence, (Sequence)CollectionsKt.asSequence((Iterable)list2));
        return GoFileWatchersDeprecationStartupActivityKt.filterKnownFormatters(GoFileWatchersDeprecationStartupActivityKt.filterEnabledOnGoFiles((Sequence<? extends Pair<TaskOptions, Boolean>>)allFileWatchers), project);
    }

    private static final Sequence<TaskOptions> filterEnabledOnGoFiles(Sequence<? extends Pair<TaskOptions, Boolean>> $this$filterEnabledOnGoFiles) {
        return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)SequencesKt.filter($this$filterEnabledOnGoFiles, GoFileWatchersDeprecationStartupActivityKt::filterEnabledOnGoFiles$lambda$0), GoFileWatchersDeprecationStartupActivityKt::filterEnabledOnGoFiles$lambda$1), GoFileWatchersDeprecationStartupActivityKt::filterEnabledOnGoFiles$lambda$2);
    }

    private static final Sequence<TaskOptions> filterKnownFormatters(Sequence<? extends TaskOptions> $this$filterKnownFormatters, Project project) {
        return SequencesKt.filter($this$filterKnownFormatters, arg_0 -> GoFileWatchersDeprecationStartupActivityKt.filterKnownFormatters$lambda$0(project, arg_0));
    }

    private static final boolean isGoFmtWatcher(TaskOptions $this$isGoFmtWatcher, Project project) {
        boolean isGoProgram = Intrinsics.areEqual((Object)$this$isGoFmtWatcher.getProgram(), (Object)"$GoExecPath$") || GoFileWatchersDeprecationStartupActivityKt.checkProgramExists($this$isGoFmtWatcher, project, "go");
        String string = $this$isGoFmtWatcher.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArguments(...)");
        char[] cArray = new char[]{' '};
        boolean firstArgumentIsFmt = Intrinsics.areEqual((Object)CollectionsKt.firstOrNull((List)StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null)), (Object)"fmt");
        return isGoProgram && firstArgumentIsFmt;
    }

    private static final boolean isWritingWatcherWithName(TaskOptions $this$isWritingWatcherWithName, Project project, String programName) {
        boolean isValidProgram = GoFileWatchersDeprecationStartupActivityKt.checkProgramExists($this$isWritingWatcherWithName, project, programName);
        String string = $this$isWritingWatcherWithName.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArguments(...)");
        char[] cArray = new char[]{' '};
        boolean hasWritingArgument = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null).contains("-w");
        return isValidProgram && hasWritingArgument;
    }

    private static final boolean checkProgramExists(TaskOptions $this$checkProgramExists, Project project, String programName) {
        Lazy isValidProgramInGopath = LazyKt.lazy(() -> GoFileWatchersDeprecationStartupActivityKt.checkProgramExists$lambda$0(programName, $this$checkProgramExists, project));
        Lazy isValidAbsolutePath = LazyKt.lazy(() -> GoFileWatchersDeprecationStartupActivityKt.checkProgramExists$lambda$1(programName, $this$checkProgramExists));
        return (Boolean)isValidProgramInGopath.getValue() != false || (Boolean)isValidAbsolutePath.getValue() != false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkProgramNameOnWindowsIfNeeded(String programName, Function1<? super String, Boolean> predicate) {
        if ((Boolean)predicate.invoke((Object)programName) != false) return true;
        String string = GoEnvironmentUtil.getBinaryFileNameForPath(programName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBinaryFileNameForPath(...)");
        if ((Boolean)predicate.invoke((Object)string) == false) return false;
        return true;
    }

    private static final boolean filterEnabledOnGoFiles$lambda$0(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object object = it.second;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
        return (Boolean)object;
    }

    private static final boolean filterEnabledOnGoFiles$lambda$1(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)((TaskOptions)it.first).getFileType(), (Object)GoFileType.INSTANCE);
    }

    private static final TaskOptions filterEnabledOnGoFiles$lambda$2(Pair it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (TaskOptions)it.first;
    }

    private static final boolean filterKnownFormatters$lambda$0(Project $project, TaskOptions it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return GoFileWatchersDeprecationStartupActivityKt.isGoFmtWatcher(it, $project) || GoFileWatchersDeprecationStartupActivityKt.isWritingWatcherWithName(it, $project, "gofmt") || GoFileWatchersDeprecationStartupActivityKt.isWritingWatcherWithName(it, $project, "goimports") || GoFileWatchersDeprecationStartupActivityKt.isWritingWatcherWithName(it, $project, "gofumpt");
    }

    private static final boolean checkProgramExists$lambda$0(String $programName, TaskOptions $this_checkProgramExists, Project $project) {
        return GoFileWatchersDeprecationStartupActivityKt.checkProgramNameOnWindowsIfNeeded($programName, (Function1<? super String, Boolean>)((Function1)arg_0 -> GoFileWatchersDeprecationStartupActivityKt.checkProgramExists$lambda$0$0($this_checkProgramExists, $project, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkProgramExists$lambda$0$0(TaskOptions $this_checkProgramExists, Project $project, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)$this_checkProgramExists.getProgram(), (Object)it)) return false;
        VirtualFile virtualFile = GoSdkUtil.findExecutableInGoPath(it, $project, null);
        if (virtualFile == null) return false;
        if (!virtualFile.isValid()) return false;
        return true;
    }

    private static final boolean checkProgramExists$lambda$1(String $programName, TaskOptions $this_checkProgramExists) {
        return GoFileWatchersDeprecationStartupActivityKt.checkProgramNameOnWindowsIfNeeded($programName, (Function1<? super String, Boolean>)((Function1)arg_0 -> GoFileWatchersDeprecationStartupActivityKt.checkProgramExists$lambda$1$0($this_checkProgramExists, $programName, arg_0)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean checkProgramExists$lambda$1$0(TaskOptions $this_checkProgramExists, String $programName, String it) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = $this_checkProgramExists.getProgram();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProgram(...)");
        Path path2 = Paths.get(string, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path it2 = path = path2;
        boolean bl = false;
        if (!it2.isAbsolute()) return false;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) return false;
        if (!Files.isExecutable(it2)) return false;
        boolean bl2 = true;
        if (!bl2) return false;
        Path path3 = path;
        Path path4 = path3;
        if (path4 == null) return false;
        it2 = path4;
        boolean bl3 = false;
        Path path5 = it2.getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"getFileName(...)");
        if (!Intrinsics.areEqual((Object)((Object)path5).toString(), (Object)$programName)) return false;
        return true;
    }

    public static final /* synthetic */ void access$checkFormatterAndWatchersSettings(Project project) {
        GoFileWatchersDeprecationStartupActivityKt.checkFormatterAndWatchersSettings(project);
    }

    static {
        KeyWithDefaultValue keyWithDefaultValue = KeyWithDefaultValue.create((String)"go.file.watchers.deprecation.notification.shown", (Object)false);
        Intrinsics.checkNotNullExpressionValue((Object)keyWithDefaultValue, (String)"create(...)");
        FORMATTERS_CONFLICT_OCCURRED_KEY = keyWithDefaultValue;
    }
}

