/*
 * Decompiled with CFR 0.152.
 */
package com.goide.wizard;

import com.goide.configuration.GoSdkSettingUI;
import com.goide.sdk.GoSdk;
import com.goide.sdk.GoSdkService;
import com.goide.sdk.combobox.GoBasedSdkChooserCombo;
import com.goide.sdk.combobox.GoSdkChooserCombo;
import com.goide.wizard.GoNewProjectSettings;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.ui.panel.PanelGridBuilder;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.GeneratorPeerImpl;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.util.ui.UI;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GoProjectGeneratorPeer<T extends GoNewProjectSettings>
extends GeneratorPeerImpl<T>
implements ProjectGeneratorPeer<T> {
    @NlsSafe
    protected static final String SDK_LABEL_TEXT = "GOROOT:";
    @Nullable
    private LabeledComponent<TextFieldWithBrowseButton> myLocationComponent;
    private GoSdkChooserCombo mySdkCombo;

    @NotNull
    public JPanel createSettingsPanel(@NotNull Disposable parentDisposable, @Nullable LabeledComponent<TextFieldWithBrowseButton> locationComponent) {
        if (parentDisposable == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(0);
        }
        this.myLocationComponent = locationComponent;
        JPanel jPanel = this.createSettingsPanel(parentDisposable, locationComponent, this.createSdkChooserCombo(parentDisposable), null);
        if (jPanel == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    protected abstract JPanel createSettingsPanel(@NotNull Disposable var1, @Nullable LabeledComponent<TextFieldWithBrowseButton> var2, @Nullable GoSdkChooserCombo var3, @Nullable Project var4);

    @NotNull
    public JPanel createModuleSettingsPanel(@NotNull Disposable parentDisposable, @Nullable Project project) {
        if (parentDisposable == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(2);
        }
        GoSdkChooserCombo sdkCombo = project == null || !GoSdkService.getInstance(project).getSdk(null).isValid() ? this.createSdkChooserCombo(parentDisposable) : null;
        JPanel jPanel = this.createSettingsPanel(parentDisposable, null, sdkCombo, project);
        if (jPanel == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    protected static PanelGridBuilder createGridPanel(@Nullable LabeledComponent<TextFieldWithBrowseButton> locationComponent, @Nullable GoSdkChooserCombo sdkCombo) {
        PanelGridBuilder grid = UI.PanelFactory.grid();
        if (locationComponent != null) {
            grid = grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)locationComponent.getComponent()).withLabel(GoProjectGeneratorPeer.getLocationComponentLabelText(locationComponent)));
        }
        if (sdkCombo != null) {
            grid = grid.add((PanelBuilder)UI.PanelFactory.panel((JComponent)((Object)sdkCombo)).withLabel(SDK_LABEL_TEXT));
        }
        PanelGridBuilder panelGridBuilder = grid;
        if (panelGridBuilder == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(4);
        }
        return panelGridBuilder;
    }

    @NlsContexts.Label
    @NotNull
    public static String getLocationComponentLabelText(@NotNull LabeledComponent<TextFieldWithBrowseButton> locationComponent) {
        if (locationComponent == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(5);
        }
        String string = StringUtil.trimEnd((String)locationComponent.getText(), (char)':') + ":";
        if (string == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    private GoSdkChooserCombo createSdkChooserCombo(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(7);
        }
        this.mySdkCombo = new GoSdkChooserCombo(() -> this.getProjectPath(), sdk -> true, this.createValidator(), new GoSdk[0]);
        Disposer.register((Disposable)parentDisposable, (Disposable)this.mySdkCombo);
        GoSdkChooserCombo goSdkChooserCombo = this.mySdkCombo;
        if (goSdkChooserCombo == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(8);
        }
        return goSdkChooserCombo;
    }

    @NotNull
    private GoBasedSdkChooserCombo.Validator<GoSdk> createValidator() {
        final GoBasedSdkChooserCombo.Validator<GoSdk> validator = this.getSdkValidator();
        final GoBasedSdkChooserCombo.Validator<GoSdk> wslValidator = GoSdkSettingUI.createWslSdkValidator(() -> this.getProjectPath());
        return new GoBasedSdkChooserCombo.Validator<GoSdk>(this){

            @Override
            public ValidationResult validate(@NotNull GoSdk sdk) {
                ValidationResult wslResult;
                if (sdk == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !(wslResult = wslValidator.validate(sdk)).isOk() ? wslResult : validator.validate(sdk);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdk", "com/goide/wizard/GoProjectGeneratorPeer$1", "validate"));
            }
        };
    }

    @Nullable
    private String getProjectPath() {
        TextFieldWithBrowseButton textField = this.myLocationComponent != null ? (TextFieldWithBrowseButton)this.myLocationComponent.getComponent() : null;
        return textField != null ? textField.getText() : null;
    }

    protected GoBasedSdkChooserCombo.Validator<GoSdk> getSdkValidator() {
        return sdk -> ValidationResult.OK;
    }

    protected GoSdk getSdkFromCombo() {
        return this.mySdkCombo != null ? (GoSdk)this.mySdkCombo.getSdk() : GoSdk.NULL;
    }

    public void registerValidators(@NotNull Runnable checkValid) {
        if (checkValid == null) {
            GoProjectGeneratorPeer.$$$reportNull$$$0(9);
        }
        this.mySdkCombo.addChangedListener(e -> checkValid.run());
    }

    public void switchToValidSdk() {
        if (this.mySdkCombo == null) {
            return;
        }
        GoBasedSdkChooserCombo.Validator<GoSdk> validator = this.mySdkCombo.getValidator();
        ValidationResult result = validator.validate((GoSdk)this.mySdkCombo.getSdk());
        if (!result.isOk()) {
            this.mySdkCombo.selectFirstNotNullSdk();
        }
    }

    @Nullable
    public ValidationInfo validate() {
        GoBasedSdkChooserCombo.Validator<GoSdk> validator;
        ValidationResult result;
        if (this.mySdkCombo != null && !(result = (validator = this.mySdkCombo.getValidator()).validate((GoSdk)this.mySdkCombo.getSdk())).isOk()) {
            return new ValidationInfo(result.getErrorMessage());
        }
        return super.validate();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/goide/wizard/GoProjectGeneratorPeer";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locationComponent";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkValid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/goide/wizard/GoProjectGeneratorPeer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSettingsPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleSettingsPanel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createGridPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationComponentLabelText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createSdkChooserCombo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSettingsPanel";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createModuleSettingsPanel";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLocationComponentLabelText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createSdkChooserCombo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerValidators";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 4, 6, 8 -> new IllegalStateException(string);
        };
    }
}

