/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.structure;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.actions.ActionStatus;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.util.common.CollectionFun;
import com.intellij.database.view.DataSourceNode;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.structure.DvForestActionService;
import com.intellij.database.view.structure.DvTreeNodeRank;
import com.intellij.database.view.structure.forest.DvFolder;
import com.intellij.database.view.structure.forest.DvForest;
import com.intellij.database.view.structure.forest.DvForestService;
import com.intellij.database.view.structure.forest.DvNiceFolder;
import com.intellij.database.view.structure.forest.ShiftDirection;
import com.intellij.ide.actions.NonTrivialActionGroup;
import com.intellij.ide.ui.newItemPopup.NewItemPopupUtil;
import com.intellij.ide.ui.newItemPopup.NewItemSimplePopupPanel;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001d2\u00020\u0001:\t\u001d\u001e\u001f !\"#$%B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\rH\u0004J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0013H&J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0011H&J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004\u0082\u0001\u0002&'\u00a8\u0006("}, d2={"Lcom/intellij/database/view/structure/DvForestAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "checkAvailability", "Lcom/intellij/database/actions/ActionStatus;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "adjustPresentation", "actionPerformed", "fromTheToolbar", "", "determineSelection", "Lcom/intellij/database/view/structure/DvForestAction$Selection;", "project", "Lcom/intellij/openapi/project/Project;", "checkApplicability", "selection", "performAction", "fromToolbar", "forest", "Lcom/intellij/database/view/structure/forest/DvForest;", "Lcom/intellij/database/view/DataSourceNode;", "Companion", "Selection", "ShiftGroup", "CreateNewFolder", "ForestNodeShiftAction", "ForestNodeShiftUpAction", "ForestNodeShiftDownAction", "ForestNodeShiftLeftAction", "ForestNodeShiftRightAction", "Lcom/intellij/database/view/structure/DvForestAction$CreateNewFolder;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,228:1\n1#2:229\n30#3,2:230\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction\n*L\n105#1:230,2\n*E\n"})
public abstract sealed class DvForestAction
extends DumbAwareAction {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger ourLog;

    private DvForestAction() {
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation2 = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"getPresentation(...)");
        Presentation presentation3 = presentation2;
        if (this.fromTheToolbar(e)) {
            presentation3.setEnabledAndVisible(true);
            this.adjustPresentation(e);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        ActionStatus actionStatus = DatabaseContextFun.fromDatabaseTree(dc) ? this.checkAvailability(dc) : ActionStatus.HIDDEN;
        Presentation $this$update_u24lambda_u240 = presentation = presentation3;
        boolean bl = false;
        $this$update_u24lambda_u240.setVisible(actionStatus.visible);
        $this$update_u24lambda_u240.setEnabled(actionStatus.enabled);
        if (actionStatus.visible) {
            this.adjustPresentation(e);
        }
    }

    @NotNull
    protected final ActionStatus checkAvailability(@NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        Project project = DatabaseContextFun.getProject(dc);
        if (project == null) {
            return ActionStatus.HIDDEN;
        }
        Project project2 = project;
        Selection selection = this.determineSelection(project2, dc);
        if (!selection.getHasFolders() && !selection.getHasDataSources() || selection.getOther()) {
            return ActionStatus.HIDDEN;
        }
        return this.checkApplicability(selection);
    }

    protected void adjustPresentation(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean fromToolbar = this.fromTheToolbar(e);
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext dc = dataContext;
        if (!fromToolbar && !DatabaseContextFun.fromDatabaseTree(dc)) {
            return;
        }
        Selection selection = this.determineSelection(project2, dc);
        if (!fromToolbar) {
            ActionStatus status = this.checkApplicability(selection);
            if (!status.enabled) {
                return;
            }
        }
        this.performAction(project2, selection, dc, fromToolbar);
    }

    private final boolean fromTheToolbar(AnActionEvent e) {
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPlace(...)");
        return StringsKt.endsWith$default((String)string, (String)"DatabaseViewToolbar", (boolean)false, (int)2, null);
    }

    @NotNull
    protected final Selection determineSelection(@NotNull Project project, @NotNull DataContext dc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
        ArrayList<BasicNode> folders = new ArrayList<BasicNode>();
        ArrayList<BasicNode> dataSources = new ArrayList<BasicNode>();
        boolean other = false;
        for (BasicNode node : DatabaseContextFun.getSelectedNodes(dc)) {
            BasicNode basicNode = node;
            if (basicNode instanceof DvNiceFolder) {
                folders.add(node);
                continue;
            }
            if (basicNode instanceof DataSourceNode) {
                dataSources.add(node);
                continue;
            }
            other = true;
        }
        return new Selection(project, (Collection<DvNiceFolder>)folders, (Collection<DataSourceNode>)dataSources, other);
    }

    @NotNull
    public abstract ActionStatus checkApplicability(@NotNull Selection var1);

    public abstract void performAction(@NotNull Project var1, @NotNull Selection var2, @NotNull DataContext var3, boolean var4);

    @NotNull
    protected final DvForest<DataSourceNode> forest(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<DvForestService> serviceClass$iv = DvForestService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((DvForestService)object).getForest();
    }

    @NotNull
    public static final Logger getOurLog() {
        return Companion.getOurLog();
    }

    public /* synthetic */ DvForestAction(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Logger logger = Logger.getInstance(DvForestAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ourLog = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$Companion;", "", "<init>", "()V", "ourLog", "Lcom/intellij/openapi/diagnostic/Logger;", "getOurLog$annotations", "getOurLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getOurLog() {
            return ourLog;
        }

        @JvmStatic
        public static /* synthetic */ void getOurLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$CreateNewFolder;", "Lcom/intellij/database/view/structure/DvForestAction;", "<init>", "()V", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "selection", "Lcom/intellij/database/view/structure/DvForestAction$Selection;", "adjustPresentation", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "performAction", "project", "Lcom/intellij/openapi/project/Project;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "fromToolbar", "", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction$CreateNewFolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,228:1\n1#2:229\n30#3,2:230\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction$CreateNewFolder\n*L\n176#1:230,2\n*E\n"})
    public static final class CreateNewFolder
    extends DvForestAction {
        public CreateNewFolder() {
            super(null);
        }

        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Selection selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Selection $this$checkApplicability_u24lambda_u240 = selection;
            boolean bl = false;
            boolean ok2 = $this$checkApplicability_u24lambda_u240.getFolders().size() <= 1 && !$this$checkApplicability_u24lambda_u240.getHasDataSources() && !$this$checkApplicability_u24lambda_u240.getOther();
            return ok2 ? ActionStatus.ENABLED : ActionStatus.DISABLED;
        }

        @Override
        protected void adjustPresentation(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setText(DatabaseBundle.message((String)"action.DatabaseView.CreateNewFolder.textInsideGroupNew", (Object[])new Object[0]));
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection, @NotNull DataContext dc, boolean fromToolbar) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            DvNiceFolder parentFolder = fromToolbar ? null : (selection.getHasFolders() ? (DvNiceFolder)CollectionsKt.firstOrNull((Iterable)selection.getFolders()) : null);
            String newNameLemma = "New Folder";
            Object newName = newNameLemma;
            DvNiceFolder dvNiceFolder = parentFolder;
            DvFolder theParentFolder = dvNiceFolder != null ? (DvFolder)dvNiceFolder : (DvFolder)this.forest(project).getRoot();
            Set siblingNames = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)theParentFolder.getInnerFolders()), CreateNewFolder::performAction$lambda$0));
            int i = 0;
            while (siblingNames.contains(newName)) {
                newName = newNameLemma + " " + ++i;
            }
            NewItemSimplePopupPanel contentPanel = new NewItemSimplePopupPanel(true);
            JTextField nameField = contentPanel.getTextField();
            nameField.setText((String)newName);
            nameField.selectAll();
            String string = DatabaseBundle.message((String)"forest.dialog.createNewFolder.title", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            JBPopup popup2 = NewItemPopupUtil.createNewItemPopup((String)title, (JComponent)((JComponent)contentPanel), (JComponent)nameField);
            contentPanel.setApplyAction(arg_0 -> CreateNewFolder.performAction$lambda$2(arg_0 -> CreateNewFolder.performAction$lambda$1(nameField, popup2, project, theParentFolder, arg_0), arg_0));
            popup2.showInBestPositionFor(dc);
        }

        private static final String performAction$lambda$0(DvNiceFolder it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getName();
        }

        private static final Unit performAction$lambda$1(JTextField $nameField, JBPopup $popup, Project $project, DvFolder $theParentFolder, InputEvent e) {
            String string = $nameField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String newName = ((Object)StringsKt.trim((CharSequence)string)).toString();
            $popup.closeOk(e);
            ComponentManager $this$service$iv = (ComponentManager)$project;
            boolean $i$f$service = false;
            Class<DvForestActionService> serviceClass$iv = DvForestActionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((DvForestActionService)object).createNewFolder($theParentFolder, newName, true);
            return Unit.INSTANCE;
        }

        private static final void performAction$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u0082\u0001\u0004\u001a\u001b\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "Lcom/intellij/database/view/structure/DvForestAction;", "direction", "Lcom/intellij/database/view/structure/forest/ShiftDirection;", "keyCode", "", "<init>", "(Lcom/intellij/database/view/structure/forest/ShiftDirection;I)V", "getDirection", "()Lcom/intellij/database/view/structure/forest/ShiftDirection;", "checkApplicability", "Lcom/intellij/database/actions/ActionStatus;", "selection", "Lcom/intellij/database/view/structure/DvForestAction$Selection;", "checkShiftApplicability", "", "performAction", "", "project", "Lcom/intellij/openapi/project/Project;", "dc", "Lcom/intellij/openapi/actionSystem/DataContext;", "fromToolbar", "setShortcutSet", "shortcutSet", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftDownAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftLeftAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftRightAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftUpAction;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDvForestAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,228:1\n30#2,2:229\n30#2,2:231\n*S KotlinDebug\n*F\n+ 1 DvForestAction.kt\ncom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction\n*L\n198#1:229,2\n205#1:231,2\n*E\n"})
    public static abstract sealed class ForestNodeShiftAction
    extends DvForestAction
    permits ForestNodeShiftDownAction, ForestNodeShiftLeftAction, ForestNodeShiftRightAction, ForestNodeShiftUpAction {
        @NotNull
        private final ShiftDirection direction;

        private ForestNodeShiftAction(ShiftDirection direction, int keyCode) {
            super(null);
            this.direction = direction;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(keyCode, 576)));
        }

        @NotNull
        public final ShiftDirection getDirection() {
            return this.direction;
        }

        @Override
        @NotNull
        public ActionStatus checkApplicability(@NotNull Selection selection) {
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            return selection.isEmpty() || selection.getOther() ? ActionStatus.HIDDEN : (this.checkShiftApplicability(selection) ? ActionStatus.ENABLED : ActionStatus.DISABLED);
        }

        private final boolean checkShiftApplicability(Selection selection) {
            boolean fs = selection.getHasFolders();
            boolean ds = selection.getHasDataSources();
            ComponentManager $this$service$iv = (ComponentManager)selection.getProject();
            boolean $i$f$service = false;
            Class<DvForestActionService> serviceClass$iv = DvForestActionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DvForestActionService actionService = (DvForestActionService)object;
            return fs && !ds && actionService.canShiftFolders(selection.getFolders(), this.direction) || ds && !fs && actionService.canShiftDataSources(selection.getDataSources(), this.direction);
        }

        @Override
        public void performAction(@NotNull Project project, @NotNull Selection selection, @NotNull DataContext dc, boolean fromToolbar) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
            Intrinsics.checkNotNullParameter((Object)dc, (String)"dc");
            if (!this.checkShiftApplicability(selection)) {
                return;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DvForestActionService> serviceClass$iv = DvForestActionService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            DvForestActionService forestActionService = (DvForestActionService)object;
            try {
                if (selection.getHasFolders()) {
                    forestActionService.shiftFolders(selection.getFolders(), this.direction);
                } else if (selection.getHasDataSources()) {
                    forestActionService.shiftDataSources(selection.getDataSources(), this.direction);
                }
            }
            catch (Exception e) {
                Companion.getOurLog().debug("Cannot shift " + selection + " " + this.direction, (Throwable)e);
            }
        }

        public void setShortcutSet(@NotNull ShortcutSet shortcutSet) {
            Intrinsics.checkNotNullParameter((Object)shortcutSet, (String)"shortcutSet");
            if (shortcutSet instanceof CustomShortcutSet) {
                super.setShortcutSet(shortcutSet);
            }
        }

        public /* synthetic */ ForestNodeShiftAction(ShiftDirection direction, int keyCode, DefaultConstructorMarker $constructor_marker) {
            this(direction, keyCode);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftDownAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftDownAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftDownAction() {
            super(ShiftDirection.shiftSiblingsDown, 40, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftLeftAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftLeftAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftLeftAction() {
            super(ShiftDirection.shiftLevelUp, 37, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftRightAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftRightAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftRightAction() {
            super(ShiftDirection.shiftLevelDown, 39, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftUpAction;", "Lcom/intellij/database/view/structure/DvForestAction$ForestNodeShiftAction;", "<init>", "()V", "intellij.database.impl"})
    public static final class ForestNodeShiftUpAction
    extends ForestNodeShiftAction {
        public ForestNodeShiftUpAction() {
            super(ShiftDirection.shiftSiblingsUp, 38, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\u000f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\nH\u00c6\u0003J=\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$Selection;", "", "project", "Lcom/intellij/openapi/project/Project;", "folders", "", "Lcom/intellij/database/view/structure/forest/DvNiceFolder;", "dataSources", "Lcom/intellij/database/view/DataSourceNode;", "other", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;Ljava/util/Collection;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFolders", "()Ljava/util/Collection;", "getDataSources", "getOther", "()Z", "hasFolders", "getHasFolders", "hasDataSources", "getHasDataSources", "isEmpty", "toString", "", "component1", "component2", "component3", "component4", "copy", "equals", "hashCode", "", "intellij.database.impl"})
    public static final class Selection {
        @NotNull
        private final Project project;
        @NotNull
        private final Collection<DvNiceFolder> folders;
        @NotNull
        private final Collection<DataSourceNode> dataSources;
        private final boolean other;

        public Selection(@NotNull Project project, @NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            this.project = project;
            this.folders = folders;
            this.dataSources = dataSources;
            this.other = other;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final Collection<DvNiceFolder> getFolders() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> getDataSources() {
            return this.dataSources;
        }

        public final boolean getOther() {
            return this.other;
        }

        public final boolean getHasFolders() {
            return !this.folders.isEmpty();
        }

        public final boolean getHasDataSources() {
            return !this.dataSources.isEmpty();
        }

        public final boolean isEmpty() {
            return !this.getHasFolders() && !this.getHasDataSources() && !this.other;
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder;
            StringBuilder $this$toString_u24lambda_u240 = stringBuilder = new StringBuilder();
            boolean bl = false;
            if (this.getHasFolders()) {
                $this$toString_u24lambda_u240.append(this.folders.size()).append(" folders");
            }
            if (this.getHasFolders() && this.getHasDataSources()) {
                $this$toString_u24lambda_u240.append(" and ");
            }
            if (this.getHasDataSources()) {
                $this$toString_u24lambda_u240.append(this.dataSources.size()).append(" data sources");
            }
            if (this.isEmpty()) {
                $this$toString_u24lambda_u240.append("nothing");
            }
            return stringBuilder.toString();
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final Collection<DvNiceFolder> component2() {
            return this.folders;
        }

        @NotNull
        public final Collection<DataSourceNode> component3() {
            return this.dataSources;
        }

        public final boolean component4() {
            return this.other;
        }

        @NotNull
        public final Selection copy(@NotNull Project project, @NotNull Collection<DvNiceFolder> folders, @NotNull Collection<DataSourceNode> dataSources, boolean other) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(folders, (String)"folders");
            Intrinsics.checkNotNullParameter(dataSources, (String)"dataSources");
            return new Selection(project, folders, dataSources, other);
        }

        public static /* synthetic */ Selection copy$default(Selection selection, Project project, Collection collection, Collection collection2, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                project = selection.project;
            }
            if ((n & 2) != 0) {
                collection = selection.folders;
            }
            if ((n & 4) != 0) {
                collection2 = selection.dataSources;
            }
            if ((n & 8) != 0) {
                bl = selection.other;
            }
            return selection.copy(project, collection, collection2, bl);
        }

        public int hashCode() {
            int result2 = this.project.hashCode();
            result2 = result2 * 31 + ((Object)this.folders).hashCode();
            result2 = result2 * 31 + ((Object)this.dataSources).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.other);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Selection)) {
                return false;
            }
            Selection selection = (Selection)other;
            if (!Intrinsics.areEqual((Object)this.project, (Object)selection.project)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.folders, selection.folders)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.dataSources, selection.dataSources)) {
                return false;
            }
            return this.other == selection.other;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/database/view/structure/DvForestAction$ShiftGroup;", "Lcom/intellij/ide/actions/NonTrivialActionGroup;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.database.impl"})
    public static final class ShiftGroup
    extends NonTrivialActionGroup
    implements DumbAware {
        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.update(e);
            Presentation presentation = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
            Presentation p = presentation;
            if (!p.isVisible()) {
                return;
            }
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            Set<DvTreeNodeRank> ranks = DatabaseContextFun.getSelectedTreeNodeRanks(dataContext);
            p.setEnabledAndVisible(CollectionFun.containsOnly((Collection)ranks, (Object)DvTreeNodeRank.TL_FOLDER) || CollectionFun.containsOnly((Collection)ranks, (Object)DvTreeNodeRank.TL_ROOT));
        }
    }
}

