/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u001f\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0015R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/vcs/log/graph/utils/DfsWalk;", "", "startNodes", "", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "<init>", "(Ljava/util/Collection;Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;Lcom/intellij/vcs/log/graph/utils/Flags;)V", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "(Ljava/util/Collection;Lcom/intellij/vcs/log/graph/api/LinearGraph;)V", "stack", "Lit/unimi/dsi/fastutil/ints/IntArrayList;", "walk", "", "goDown", "", "consumer", "Lkotlin/Function1;", "intellij.platform.vcs.log.graph.impl"})
public final class DfsWalk {
    @NotNull
    private final Collection<Integer> startNodes;
    @NotNull
    private final LiteLinearGraph graph;
    @NotNull
    private final Flags visited;
    @NotNull
    private final IntArrayList stack;

    public DfsWalk(@NotNull Collection<Integer> startNodes, @NotNull LiteLinearGraph graph, @NotNull Flags visited) {
        Intrinsics.checkNotNullParameter(startNodes, (String)"startNodes");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        Intrinsics.checkNotNullParameter((Object)visited, (String)"visited");
        this.startNodes = startNodes;
        this.graph = graph;
        this.visited = visited;
        this.stack = new IntArrayList();
    }

    public DfsWalk(@NotNull Collection<Integer> startNodes, @NotNull LinearGraph linearGraph) {
        Intrinsics.checkNotNullParameter(startNodes, (String)"startNodes");
        Intrinsics.checkNotNullParameter((Object)linearGraph, (String)"linearGraph");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(linearGraph);
        Intrinsics.checkNotNullExpressionValue((Object)liteLinearGraph, (String)"asLiteLinearGraph(...)");
        this(startNodes, liteLinearGraph, new BitSetFlags(linearGraph.nodesCount()));
    }

    public final void walk(boolean goDown, @NotNull Function1<? super Integer, Boolean> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterator<Integer> iterator = this.startNodes.iterator();
        while (iterator.hasNext()) {
            int start = ((Number)iterator.next()).intValue();
            if (start < 0 || this.visited.get(start)) continue;
            this.visited.set(start, true);
            if (!((Boolean)consumer.invoke((Object)start)).booleanValue()) {
                return;
            }
            DfsUtilKt.access$walk(start, this.stack, arg_0 -> DfsWalk.walk$lambda$0(this, goDown, consumer, arg_0));
        }
    }

    private static final int walk$lambda$0(DfsWalk this$0, boolean $goDown, Function1 $consumer, int currentNode) {
        for (Integer downNode : this$0.graph.getNodes(currentNode, $goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
            Flags flags = this$0.visited;
            Intrinsics.checkNotNull((Object)downNode);
            if (flags.get(downNode)) continue;
            this$0.visited.set(downNode, true);
            if (!((Boolean)$consumer.invoke((Object)downNode)).booleanValue()) {
                return -10;
            }
            return downNode;
        }
        return -1;
    }
}

