/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.editor;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.terraform.template.TftplBundle;
import com.intellij.terraform.template.editor.TfConsiderFileATemplateFix;
import com.intellij.terraform.template.editor.TfIgnoreTemplateCandidateFix;
import com.intellij.terraform.template.editor.TfRemoveFileTypeAssociationIntentionKt;
import com.intellij.terraform.template.model.TemplateFuncVariableCollectorKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.intellij.terraform.runtime.TfProjectSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/terraform/template/editor/MaybeTfTemplateInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "isPossibleTemplateFile", "file", "Lcom/intellij/psi/PsiFile;", "intellij.terraform.template"})
public final class MaybeTfTemplateInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                VirtualFile virtualFile = holder.getFile().getVirtualFile();
                if (virtualFile == null || TfRemoveFileTypeAssociationIntentionKt.isFileWithAlreadyOverriddenTemplateType(virtualFile)) break block2;
                Project project = holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                TfProjectSettings tfProjectSettings = TfProjectSettings.Companion.getInstance(project);
                String string = virtualFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                if (tfProjectSettings.isIgnoredTemplateCandidate(string)) break block2;
                PsiFile psiFile = holder.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
                if (this.isPossibleTemplateFile(psiFile)) break block3;
            }
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new PsiElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitFile(PsiFile psiFile) {
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                PsiElement psiElement = (PsiElement)psiFile;
                String string = TftplBundle.INSTANCE.message("inspection.possible.template.name", new Object[0]);
                LocalQuickFix[] localQuickFixArray = new LocalQuickFix[2];
                VirtualFile virtualFile = psiFile.getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                localQuickFixArray[0] = new TfConsiderFileATemplateFix(virtualFile);
                localQuickFixArray[1] = new TfIgnoreTemplateCandidateFix((SmartPsiElementPointer<PsiFile>)SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)psiFile)));
                this.$holder.registerProblem(psiElement, string, localQuickFixArray);
            }
        };
    }

    private final boolean isPossibleTemplateFile(PsiFile file) {
        return SequencesKt.any(TemplateFuncVariableCollectorKt.findTemplateUsage(file));
    }
}

