/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terraform.template.editor;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.file.exclude.OverrideFileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.terraform.template.TftplBundle;
import com.intellij.terraform.template.editor.TfRemoveFileTypeAssociationIntentionKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J$\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J%\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/terraform/template/editor/TfRemoveFileTypeAssociationIntention;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "<init>", "()V", "startInWriteAction", "", "getFamilyName", "", "getText", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.terraform.template"})
public final class TfRemoveFileTypeAssociationIntention
implements IntentionAction {
    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        return TftplBundle.INSTANCE.message("inspection.possible.template.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return TftplBundle.INSTANCE.message("inspection.possible.template.remove.association.fix.name", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null) return false;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        if (!TfRemoveFileTypeAssociationIntentionKt.isFileWithAlreadyOverriddenTemplateType(virtualFile)) return false;
        return true;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (psiFile == null) {
            return;
        }
        OverrideFileTypeManager.getInstance().removeFile(psiFile.getVirtualFile());
        TemplateDataLanguageMappings.getInstance((Project)project).setMapping(psiFile.getVirtualFile(), null);
    }
}

