/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;
import org.jetbrains.letsPlot.core.plot.base.scale.transform.Transforms;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 (2\u00020\u0001:\u0001(BW\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0014J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#H\u0016J \u0010$\u001a\u00020\u00012\u0016\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016J \u0010&\u001a\u00020\u00012\u0016\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003H\u0016R\u0014\u0010\t\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u0010\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R$\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR$\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000e\u00a8\u0006)"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "xLim", "Lkotlin/Pair;", "", "yLim", "xReversed", "", "yReversed", "flipped", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "(Lkotlin/Pair;Lkotlin/Pair;ZZZLorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;)V", "getFlipped", "()Z", "isLinear", "isPolar", "getProjection", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "getXLim", "()Lkotlin/Pair;", "getXReversed", "getYLim", "getYReversed", "adjustDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "dataDomain", "adjustXYDomains", "xDomain", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yDomain", "createCoordinateMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "withXlimOverride", "xlimOverride", "withYlimOverride", "ylimOverride", "Companion", "plot-builder"})
public abstract class CoordProviderBase
implements CoordProvider {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Pair<Double, Double> xLim;
    @NotNull
    private final Pair<Double, Double> yLim;
    private final boolean xReversed;
    private final boolean yReversed;
    private final boolean flipped;
    @NotNull
    private final Projection projection;
    private final boolean isLinear;
    private final boolean isPolar;

    public CoordProviderBase(@NotNull Pair<Double, Double> xLim, @NotNull Pair<Double, Double> yLim, boolean xReversed, boolean yReversed, boolean flipped, @NotNull Projection projection) {
        Intrinsics.checkNotNullParameter(xLim, (String)"xLim");
        Intrinsics.checkNotNullParameter(yLim, (String)"yLim");
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.xLim = xLim;
        this.yLim = yLim;
        this.xReversed = xReversed;
        this.yReversed = yReversed;
        this.flipped = flipped;
        this.projection = projection;
        this.isLinear = !this.projection.getNonlinear();
    }

    public /* synthetic */ CoordProviderBase(Pair pair2, Pair pair3, boolean bl, boolean bl2, boolean bl3, Projection projection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            projection = ProjectionsKt.identity();
        }
        this((Pair<Double, Double>)pair2, (Pair<Double, Double>)pair3, bl, bl2, bl3, projection);
    }

    @NotNull
    protected final Pair<Double, Double> getXLim() {
        return this.xLim;
    }

    @NotNull
    protected final Pair<Double, Double> getYLim() {
        return this.yLim;
    }

    protected final boolean getXReversed() {
        return this.xReversed;
    }

    protected final boolean getYReversed() {
        return this.yReversed;
    }

    @Override
    public boolean getFlipped() {
        return this.flipped;
    }

    @NotNull
    protected final Projection getProjection() {
        return this.projection;
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    public boolean isPolar() {
        return this.isPolar;
    }

    @Override
    @NotNull
    public CoordProvider withXlimOverride(@NotNull Pair<Double, Double> xlimOverride) {
        Intrinsics.checkNotNullParameter(xlimOverride, (String)"xlimOverride");
        if (xlimOverride.getFirst() == null && xlimOverride.getSecond() == null) {
            return this;
        }
        Pair newXLim = org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase$Companion.mergeRanges$default(Companion, xlimOverride, this.xLim, this.xReversed, false, null, 16, null);
        return this.with((Pair<Double, Double>)newXLim, this.yLim, this.xReversed, this.yReversed, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordProvider withYlimOverride(@NotNull Pair<Double, Double> ylimOverride) {
        Intrinsics.checkNotNullParameter(ylimOverride, (String)"ylimOverride");
        if (ylimOverride.getFirst() == null && ylimOverride.getSecond() == null) {
            return this;
        }
        Pair newYLim = org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase$Companion.mergeRanges$default(Companion, ylimOverride, this.yLim, this.yReversed, false, null, 16, null);
        return this.with(this.xLim, (Pair<Double, Double>)newYLim, this.xReversed, this.yReversed, this.getFlipped());
    }

    @Override
    @NotNull
    public final DoubleRectangle adjustDomain(@NotNull DoubleRectangle dataDomain) {
        Intrinsics.checkNotNullParameter((Object)dataDomain, (String)"dataDomain");
        Pair pair2 = CoordProviderBase.Companion.mergeRanges((Pair<Double, Double>)this.xLim, (Pair<Double, Double>)dataDomain.xRange().toPair(), this.xReversed, true, (Function0<String>)adjustDomain.xRange.1.INSTANCE);
        Intrinsics.checkNotNull((Object)pair2, (String)"null cannot be cast to non-null type kotlin.Pair<kotlin.Double, kotlin.Double>");
        Pair xRange2 = pair2;
        Pair pair3 = CoordProviderBase.Companion.mergeRanges((Pair<Double, Double>)this.yLim, (Pair<Double, Double>)dataDomain.yRange().toPair(), this.yReversed, true, (Function0<String>)adjustDomain.yRange.1.INSTANCE);
        Intrinsics.checkNotNull((Object)pair3, (String)"null cannot be cast to non-null type kotlin.Pair<kotlin.Double, kotlin.Double>");
        Pair yRange2 = pair3;
        return this.adjustXYDomains(new DoubleSpan(((Number)xRange2.getFirst()).doubleValue(), ((Number)xRange2.getSecond()).doubleValue()), new DoubleSpan(((Number)yRange2.getFirst()).doubleValue(), ((Number)yRange2.getSecond()).doubleValue()));
    }

    @NotNull
    protected DoubleRectangle adjustXYDomains(@NotNull DoubleSpan xDomain, @NotNull DoubleSpan yDomain) {
        Intrinsics.checkNotNullParameter((Object)xDomain, (String)"xDomain");
        Intrinsics.checkNotNullParameter((Object)yDomain, (String)"yDomain");
        DoubleRectangle dataDomain = new DoubleRectangle(xDomain, yDomain);
        DoubleRectangle validDomain = this.projection.validDomain().intersect(dataDomain);
        if (validDomain == null || !(validDomain.getHeight() > 0.0) || !(validDomain.getWidth() > 0.0)) {
            throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("Can't create a valid domain.\n                |  data bbox: " + dataDomain + "\n                |  x-lim: " + this.xLim + "\n                |  y-lim: " + this.yLim + "\n            "), null, (int)1, null));
        }
        return validDomain;
    }

    @Override
    @NotNull
    public CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        return CoordinatesMapper.Companion.create(adjustedDomain, clientSize, this.projection, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordinateSystem createCoordinateSystem(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        return CoordProvider.DefaultImpls.createCoordinateSystem(this, adjustedDomain, clientSize);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jh\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0016\u0010\u0006\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0016\u0010\u0007\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase$Companion;", "", "()V", "mergeRanges", "Lkotlin/Pair;", "", "r0", "r1", "reversed", "", "checkRange", "errorMessagePrefix", "Lkotlin/Function0;", "", "plot-builder"})
    @SourceDebugExtension(value={"SMAP\nCoordProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordProviderBase.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
    private static final class Companion {
        private Companion() {
        }

        private final Pair<Double, Double> mergeRanges(Pair<Double, Double> r0, Pair<Double, Double> r1, boolean reversed, boolean checkRange, Function0<String> errorMessagePrefix) {
            Double second;
            Double d;
            Double first;
            Pair<Double, Double> norm0 = org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase$Companion.mergeRanges$unReverse(r0, reversed);
            Pair<Double, Double> norm1 = org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase$Companion.mergeRanges$unReverse(r1, reversed);
            Double d2 = (Double)norm0.getFirst();
            if (d2 == null) {
                d2 = first = (Double)norm1.getFirst();
            }
            if ((d = (Double)norm0.getSecond()) == null) {
                d = second = (Double)norm1.getSecond();
            }
            if (first != null && second != null && checkRange && !(first < second)) {
                boolean bl = false;
                String string = (String)errorMessagePrefix.invoke() + " : " + r0 + " and " + r1;
                throw new IllegalArgumentException(string.toString());
            }
            return org.jetbrains.letsPlot.core.plot.builder.coord.CoordProviderBase$Companion.mergeRanges$reReverse((Pair<Double, Double>)new Pair((Object)first, (Object)second), reversed);
        }

        static /* synthetic */ Pair mergeRanges$default(Companion companion, Pair pair2, Pair pair3, boolean bl, boolean bl2, Function0 function0, int n, Object object) {
            if ((n & 0x10) != 0) {
                function0 = mergeRanges.1.INSTANCE;
            }
            return companion.mergeRanges((Pair<Double, Double>)pair2, (Pair<Double, Double>)pair3, bl, bl2, (Function0<String>)function0);
        }

        private static final Pair<Double, Double> mergeRanges$unReverse(Pair<Double, Double> range, boolean reversed) {
            Pair<Double, Double> pair2;
            if (reversed) {
                Double second;
                Double d;
                Double d2;
                Double d3 = (Double)range.getFirst();
                if (d3 != null) {
                    double it = ((Number)d3).doubleValue();
                    boolean bl = false;
                    d2 = Transforms.INSTANCE.getREVERSE().applyInverse(it);
                } else {
                    d2 = null;
                }
                Double first = d2;
                Double d4 = (Double)range.getSecond();
                if (d4 != null) {
                    double it = ((Number)d4).doubleValue();
                    boolean bl = false;
                    d = Transforms.INSTANCE.getREVERSE().applyInverse(it);
                } else {
                    d = second = null;
                }
                pair2 = first != null && second != null ? new DoubleSpan(first, second).toPair() : new Pair<Double, Double>((Object)first, (Object)second);
            } else {
                pair2 = range;
            }
            return pair2;
        }

        private static final Pair<Double, Double> mergeRanges$reReverse(Pair<Double, Double> range, boolean unReversed) {
            Pair<Double, Double> pair2;
            if (unReversed) {
                Double second;
                Double d;
                Double d2;
                Double d3 = (Double)range.getFirst();
                if (d3 != null) {
                    double it = ((Number)d3).doubleValue();
                    boolean bl = false;
                    d2 = Transforms.INSTANCE.getREVERSE().apply(it);
                } else {
                    d2 = null;
                }
                Double first = d2;
                Double d4 = (Double)range.getSecond();
                if (d4 != null) {
                    double it = ((Number)d4).doubleValue();
                    boolean bl = false;
                    d = Transforms.INSTANCE.getREVERSE().apply(it);
                } else {
                    d = second = null;
                }
                pair2 = first != null && second != null ? new DoubleSpan(first, second).toPair() : new Pair<Double, Double>((Object)first, (Object)second);
            } else {
                pair2 = range;
            }
            return pair2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

