/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.Abstract2DArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.SubarraysShouldHaveSameSize;
import org.assertj.core.error.array2d.Array2dElementShouldBeDeepEqual;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Int2DArrays;

public class Int2DArrayAssert
extends Abstract2DArrayAssert<Int2DArrayAssert, int[][], Integer> {
    protected Int2DArrays int2dArrays = Int2DArrays.instance();
    private final Failures failures = Failures.instance();

    public Int2DArrayAssert(int[][] actual) {
        super(actual, Int2DArrayAssert.class);
    }

    @Override
    public Int2DArrayAssert isDeepEqualTo(int[][] expected) {
        if (this.actual == expected) {
            return (Int2DArrayAssert)this.myself;
        }
        this.isNotNull();
        if (expected.length != ((int[][])this.actual).length) {
            throw this.failures.failure((AssertionInfo)this.info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(this.actual, expected, ((int[][])this.actual).length, expected.length));
        }
        for (int i = 0; i < ((int[][])this.actual).length; ++i) {
            int[] actualSubArray = ((int[][])this.actual)[i];
            int[] expectedSubArray = expected[i];
            if (actualSubArray == expectedSubArray) continue;
            if (actualSubArray == null) {
                throw this.failures.failure((AssertionInfo)this.info, ShouldNotBeNull.shouldNotBeNull("actual[" + i + "]"));
            }
            if (expectedSubArray.length != actualSubArray.length) {
                throw this.failures.failure(this.info, SubarraysShouldHaveSameSize.subarraysShouldHaveSameSize(this.actual, expected, actualSubArray, actualSubArray.length, expectedSubArray, expectedSubArray.length, i), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
            for (int j = 0; j < actualSubArray.length; ++j) {
                if (actualSubArray[j] == expectedSubArray[j]) continue;
                throw this.failures.failure(this.info, Array2dElementShouldBeDeepEqual.elementShouldBeEqual(actualSubArray[j], expectedSubArray[j], i, j), this.info.representation().toStringOf(this.actual), this.info.representation().toStringOf(expected));
            }
        }
        return (Int2DArrayAssert)this.myself;
    }

    @Override
    public Int2DArrayAssert isEqualTo(Object expected) {
        return (Int2DArrayAssert)super.isEqualTo(expected);
    }

    @Override
    public void isNullOrEmpty() {
        this.int2dArrays.assertNullOrEmpty(this.info, (int[][])this.actual);
    }

    @Override
    public void isEmpty() {
        this.int2dArrays.assertEmpty(this.info, (int[][])this.actual);
    }

    @Override
    public Int2DArrayAssert isNotEmpty() {
        this.int2dArrays.assertNotEmpty(this.info, (int[][])this.actual);
        return (Int2DArrayAssert)this.myself;
    }

    @Override
    public Int2DArrayAssert hasDimensions(int expectedFirstDimension, int expectedSecondDimension) {
        this.int2dArrays.assertHasDimensions(this.info, (int[][])this.actual, expectedFirstDimension, expectedSecondDimension);
        return (Int2DArrayAssert)this.myself;
    }

    @Override
    public Int2DArrayAssert hasNumberOfRows(int expected) {
        this.int2dArrays.assertNumberOfRows(this.info, (int[][])this.actual, expected);
        return (Int2DArrayAssert)this.myself;
    }

    @Override
    public Int2DArrayAssert hasSameDimensionsAs(Object array) {
        this.int2dArrays.assertHasSameDimensionsAs(this.info, (int[][])this.actual, array);
        return (Int2DArrayAssert)this.myself;
    }

    public Int2DArrayAssert contains(int[] value, Index index) {
        this.int2dArrays.assertContains(this.info, (int[][])this.actual, value, index);
        return (Int2DArrayAssert)this.myself;
    }

    public Int2DArrayAssert doesNotContain(int[] value, Index index) {
        this.int2dArrays.assertDoesNotContain(this.info, (int[][])this.actual, value, index);
        return (Int2DArrayAssert)this.myself;
    }
}

