/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\u001a\u0016\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u001a\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"nodeMemoryLimitFlag", "", "sanitizeNodeMemoryRegistryOptions", "key", "value", "addNodeMemoryLimitFlag", "", "commandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "serviceName", "memoryLimit", "", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSNodeServiceMemoryOptions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSNodeServiceMemoryOptions.kt\ncom/intellij/lang/javascript/service/JSNodeServiceMemoryOptionsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,24:1\n774#2:25\n865#2,2:26\n*S KotlinDebug\n*F\n+ 1 JSNodeServiceMemoryOptions.kt\ncom/intellij/lang/javascript/service/JSNodeServiceMemoryOptionsKt\n*L\n12#1:25\n12#1:26,2\n*E\n"})
public final class JSNodeServiceMemoryOptionsKt {
    @NotNull
    private static final String nodeMemoryLimitFlag = "--max_old_space_size";

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sanitizeNodeMemoryRegistryOptions(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!StringsKt.isBlank((CharSequence)value)) {
            void $this$filterTo$iv$iv;
            List list = ParametersListUtil.parse((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parse(...)");
            List params = list;
            Iterable $this$filter$iv = params;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!(!StringsKt.startsWith$default((String)it, (String)nodeMemoryLimitFlag, (boolean)false, (int)2, null))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List safeParams = (List)destination$iv$iv;
            if (safeParams.size() != params.size()) {
                JSLanguageServiceQueue.Holder.LOGGER.warn("Registry option '" + key + "' contains '--max_old_space_size' flag, it will be ignored. You may safely remove it and configure memory in the Settings");
            }
            String string = ParametersListUtil.join((List)safeParams);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"join(...)");
            return string;
        }
        return value;
    }

    public static final void addNodeMemoryLimitFlag(@NotNull TargetedCommandLineBuilder commandLineBuilder, @NotNull String serviceName, int memoryLimit) {
        Intrinsics.checkNotNullParameter((Object)commandLineBuilder, (String)"commandLineBuilder");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        JSLanguageServiceUtil.addNodeProcessArguments(commandLineBuilder, serviceName, "--max_old_space_size=" + memoryLimit);
    }
}

