/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter;

import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.LanguageLineWrapPositionStrategy;
import com.intellij.openapi.editor.LineWrapPositionStrategy;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy;", "Lcom/intellij/openapi/editor/LineWrapPositionStrategy;", "<init>", "()V", "calculateWrapPosition", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "startOffset", "endOffset", "maxPreferredOffset", "allowToBeyondMaxPreferredOffset", "", "isSoftWrap", "Companion", "intellij.javascript.psi.impl"})
public final class JSLineWrapPositionStrategy
implements LineWrapPositionStrategy {
    @NotNull
    private static final Companion Companion = new Companion(null);

    public int calculateWrapPosition(@NotNull Document document, @Nullable Project project, int startOffset, int endOffset, int maxPreferredOffset, boolean allowToBeyondMaxPreferredOffset, boolean isSoftWrap) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (isSoftWrap) {
            LineWrapPositionStrategy lineWrapPositionStrategy = LanguageLineWrapPositionStrategy.INSTANCE.getDefaultImplementation();
            Intrinsics.checkNotNullExpressionValue((Object)lineWrapPositionStrategy, (String)"getDefaultImplementation(...)");
            LineWrapPositionStrategy implementation = lineWrapPositionStrategy;
            return implementation.calculateWrapPosition(document, project, startOffset, endOffset, maxPreferredOffset, allowToBeyondMaxPreferredOffset, true);
        }
        return JSLineWrapPositionStrategy.Companion.calcWrapPosition(document, project, maxPreferredOffset);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u0005H\u0002J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/lang/javascript/formatter/JSLineWrapPositionStrategy$Companion;", "", "<init>", "()V", "calcWrapPosition", "", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "wrapOffset", "getElementToWrapAsText", "Lcom/intellij/psi/PsiElement;", "element", "getCommentWrapPos", "elementToWrap", "intellij.javascript.psi.impl"})
    private static final class Companion {
        private Companion() {
        }

        private final int calcWrapPosition(Document document, Project project, int wrapOffset) {
            if (project != null) {
                PsiElement currElement;
                PsiElement elementToWrap;
                PsiFile file;
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
                if (documentManager.isUncommited(document)) {
                    documentManager.commitDocument(document);
                }
                if ((file = documentManager.getPsiFile(document)) != null && (elementToWrap = this.getElementToWrapAsText(currElement = file.findElementAt(wrapOffset))) != null) {
                    return this.getCommentWrapPos(elementToWrap, wrapOffset);
                }
            }
            return -1;
        }

        private final PsiElement getElementToWrapAsText(PsiElement element) {
            if (element != null) {
                IElementType iElementType = element.getNode().getElementType();
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
                IElementType elementType = iElementType;
                if (element instanceof PsiComment || elementType == JSTokenTypes.STRING_LITERAL || elementType == JSDocTokenTypes.DOC_COMMENT_DATA && PsiTreeUtilKt.getElementType((PsiElement)element.getParent()) != JSDocTokenTypes.DOC_TAG_TYPE) {
                    return element;
                }
            }
            return null;
        }

        private final int getCommentWrapPos(PsiElement elementToWrap, int wrapOffset) {
            CharSequence charSequence = elementToWrap.getNode().getChars();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
            CharSequence chars = charSequence;
            int startOffset = elementToWrap.getTextRange().getStartOffset();
            int lastSpaceStart = -1;
            int prev = 0;
            for (int i = 0; i < chars.length() && i < wrapOffset - startOffset; ++i) {
                char c = chars.charAt(i);
                if ((c == ' ' || c == '\t') && prev != 32 && prev != 9) {
                    lastSpaceStart = i;
                }
                prev = c;
            }
            if (lastSpaceStart > 2) {
                return startOffset + lastSpaceStart;
            }
            return -1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

