/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.yaml.helm.fileTypes;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.yaml.helm.YamlHelmBundle;
import com.intellij.yaml.helm.fileTypes.HelmFileType;
import com.intellij.yaml.helm.lang.HelmYamlLanguage;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.helm.UtilKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/yaml/helm/fileTypes/HelmYamlFileType;", "Lcom/intellij/yaml/helm/fileTypes/HelmFileType;", "<init>", "()V", "isMyFileType", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getName", "", "getDescription", "getDefaultExtension", "getIcon", "Ljavax/swing/Icon;", "getCharset", "content", "", "intellij.yaml.helm"})
public final class HelmYamlFileType
extends HelmFileType {
    private HelmYamlFileType() {
        super(HelmYamlLanguage.Companion.getInstance());
    }

    public boolean isMyFileType(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.hasYamlExtension((VirtualFile)file) && UtilKt.isHelmTemplateFile((VirtualFile)file);
    }

    @NotNull
    public String getName() {
        return "Helm YAML template";
    }

    @NotNull
    public String getDescription() {
        return YamlHelmBundle.Companion.message("filetype.HelmYaml.description", new Object[0]);
    }

    @NotNull
    public String getDefaultExtension() {
        return "yaml";
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.FileTypes.Yaml;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Yaml");
        return icon;
    }

    @NotNull
    public String getCharset(@NotNull VirtualFile file, @NotNull byte[] content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        return "UTF-8";
    }
}

