/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar;

import com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar.KubernetesFloatingToolbarUtilsKt;
import com.intellij.clouds.kubernetes.frontend.i18n.KubernetesFrontendBundle;
import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.frontend.FrontendKubernetesApiProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.impl.ExpandableComboAction;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesContextSwitcherAction;", "Lcom/intellij/openapi/wm/impl/ExpandableComboAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "event", "intellij.clouds.kubernetes.frontend"})
public final class KubernetesContextSwitcherAction
extends ExpandableComboAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            KubernetesContextSwitcherAction $this$update_u24lambda_u240 = this;
            boolean bl = false;
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        KubernetesApiProviderInterface k8sApiProvider = FrontendKubernetesApiProvider.Companion.getInstance(project2);
        Context currentContext = k8sApiProvider.getSelectedContext();
        if (currentContext == null) {
            Set contexts = k8sApiProvider.getConfiguredContexts();
            if (contexts.isEmpty()) {
                e.getPresentation().setEnabledAndVisible(false);
            } else {
                e.getPresentation().setText(KubernetesFrontendBundle.INSTANCE.message("floating.toolbar.current.cluster.not.set.expandable.combobox.action.text", new Object[0]), false);
                e.getPresentation().setDescription(null);
                e.getPresentation().setEnabledAndVisible(true);
            }
        } else {
            String fullName = currentContext.getName();
            String shortName = KubernetesFloatingToolbarUtilsKt.shortenIfNeed(fullName, 25, 10);
            e.getPresentation().setText(shortName, false);
            e.getPresentation().setDescription(fullName);
            e.getPresentation().setEnabledAndVisible(true);
        }
    }

    @Nullable
    public JBPopup createPopup(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Project project = event.getProject();
        if (project == null) {
            return null;
        }
        Project project2 = project;
        DefaultActionGroup group = new DefaultActionGroup();
        Set contexts = FrontendKubernetesApiProvider.Companion.getInstance(project2).getConfiguredContexts();
        if (contexts.isEmpty()) {
            return null;
        }
        Context currentContext = FrontendKubernetesApiProvider.Companion.getInstance(project2).getSelectedContext();
        for (Context context : contexts) {
            AnAction action2 = new AnAction(context, currentContext, project2){
                final /* synthetic */ Context $context;
                final /* synthetic */ Context $currentContext;
                final /* synthetic */ Project $project;
                {
                    this.$context = $context;
                    this.$currentContext = $currentContext;
                    this.$project = $project;
                    this.getTemplatePresentation().setText($context.getName(), false);
                }

                public ActionUpdateThread getActionUpdateThread() {
                    return ActionUpdateThread.BGT;
                }

                public void update(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (Intrinsics.areEqual((Object)this.$context, (Object)this.$currentContext)) {
                        e.getPresentation().setIcon(AllIcons.Actions.Checked);
                    }
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FrontendKubernetesApiProvider.Companion.getInstance(this.$project).setContextToSettings(this.$context);
                }
            };
            group.add(action2);
        }
        JBPopupFactory factory = JBPopupFactory.getInstance();
        return (JBPopup)factory.createActionGroupPopup(null, (ActionGroup)group, event.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 10, null, null);
    }
}

