/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clouds.kubernetes.frontend.editor.floatingToolbar;

import com.intellij.clouds.kubernetes.frontend.i18n.KubernetesFrontendBundle;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.frontend.FrontendKubernetesApiProvider;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesFloatingToolbarApplyAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "intellij.clouds.kubernetes.frontend"})
@SourceDebugExtension(value={"SMAP\nKubernetesFloatingToolbarApplyAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFloatingToolbarApplyAction.kt\ncom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesFloatingToolbarApplyAction\n+ 2 actionUtils.kt\ncom/intellij/kubernetes/view/ui/actions/ActionUtilsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n55#2:70\n55#2:72\n13#3:71\n*S KotlinDebug\n*F\n+ 1 KubernetesFloatingToolbarApplyAction.kt\ncom/intellij/clouds/kubernetes/frontend/editor/floatingToolbar/KubernetesFloatingToolbarApplyAction\n*L\n24#1:70\n65#1:72\n46#1:71\n*E\n"})
public final class KubernetesFloatingToolbarApplyAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"getPresentation(...)");
        Presentation presentation2 = presentation;
        Project project = e.getProject();
        if (project == null) {
            KubernetesFloatingToolbarApplyAction $this$update_u24lambda_u240 = this;
            boolean bl = false;
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Project project2 = project;
        AnActionEvent $this$virtualFile$iv = e;
        boolean $i$f$getVirtualFile = false;
        VirtualFile virtualFile = (VirtualFile)$this$virtualFile$iv.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        String defaultActionName = KubernetesFrontendBundle.INSTANCE.message("action.Kubernetes.Floating.Toolbar.Apply.text", new Object[0]);
        KubernetesApiProviderInterface k8sApiProvider = FrontendKubernetesApiProvider.Companion.getInstance(project2);
        Context currentContext = k8sApiProvider.getSelectedContext();
        if (currentContext == null) {
            Object[] objectArray = new Object[]{defaultActionName};
            presentation2.setText(KubernetesFrontendBundle.INSTANCE.message("floating.toolbar.set.current.cluster.to.perform.something.action.description", objectArray));
            presentation2.setEnabled(false);
            presentation2.setVisible(true);
            return;
        }
        KubernetesApiModelInterface apiModel = k8sApiProvider.findModel(currentContext);
        if (apiModel == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(KubernetesFloatingToolbarApplyAction.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find k8s api model for the current context: " + currentContext);
            presentation2.setEnabledAndVisible(false);
            return;
        }
        presentation2.setText(defaultActionName);
        presentation2.setDescription(null);
        presentation2.setEnabledAndVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        KubernetesApiProviderInterface k8sApiProvider = FrontendKubernetesApiProvider.Companion.getInstance(project2);
        Context context = k8sApiProvider.getSelectedContext();
        if (context == null) {
            return;
        }
        Context currentContext = context;
        KubernetesApiModelInterface kubernetesApiModelInterface = k8sApiProvider.findModel(currentContext);
        if (kubernetesApiModelInterface == null) {
            return;
        }
        KubernetesApiModelInterface apiModel = kubernetesApiModelInterface;
        FileDocumentManager.getInstance().saveAllDocuments();
        AnActionEvent $this$virtualFile$iv = e;
        boolean $i$f$getVirtualFile = false;
        VirtualFile virtualFile = (VirtualFile)$this$virtualFile$iv.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        apiModel.scheduleApply(CollectionsKt.listOf((Object)virtualFile2));
    }
}

