/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.makefile.toolWindow;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SlowOperations;
import com.jetbrains.lang.makefile.toolWindow.MakefileFileNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileTargetNode;
import com.jetbrains.lang.makefile.toolWindow.MakefileTreeNode;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J@\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/lang/makefile/toolWindow/MakefileCellRenderer;", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "rootDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "customizeCellRenderer", "", "tree", "Ljavax/swing/JTree;", "value", "", "selected", "", "expanded", "leaf", "row", "", "hasFocus", "intellij.makefile"})
public final class MakefileCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final Project project;
    @Nullable
    private final VirtualFile rootDir;

    public MakefileCellRenderer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.rootDir = ProjectUtil.guessProjectDir((Project)this.project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void customizeCellRenderer(@NotNull JTree tree2, @NotNull Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        MakefileTreeNode cfr_ignored_0 = (MakefileTreeNode)value;
        this.setIcon(((MakefileTreeNode)value).getIcon());
        if (value instanceof MakefileTargetNode && ((Boolean)ReadAction.compute(() -> MakefileCellRenderer.customizeCellRenderer$lambda$0(value))).booleanValue()) {
            this.append(((MakefileTargetNode)value).getName(), SimpleTextAttributes.REGULAR_ITALIC_ATTRIBUTES);
        } else {
            this.append(((MakefileTreeNode)value).getName());
            if (value instanceof MakefileFileNode && !this.project.isDisposed()) {
                VirtualFile virtualFile;
                AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.knownIssue((String)"CPP-41044");
                Throwable throwable = null;
                try {
                    VirtualFile virtualFile2;
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    if ((VirtualFile)ReadAction.compute(() -> MakefileCellRenderer.customizeCellRenderer$lambda$1$0(value)) == null) {
                        return;
                    }
                    virtualFile = virtualFile2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                VirtualFile file = virtualFile;
                if (this.rootDir != null) {
                    String relativePath;
                    String string = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)this.rootDir);
                    if (string == null) {
                        String string2 = file.getPath();
                        string = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                    }
                    if (StringsKt.isBlank((CharSequence)(relativePath = string))) {
                        return;
                    }
                    this.append(" ");
                    this.append(relativePath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                }
            }
        }
    }

    private static final Boolean customizeCellRenderer$lambda$0(Object $value) {
        return ((MakefileTargetNode)$value).isSpecialTarget();
    }

    private static final VirtualFile customizeCellRenderer$lambda$1$0(Object $value) {
        PsiFile psiFile = ((MakefileFileNode)$value).getPsiFile();
        return psiFile != null && (psiFile = psiFile.getContainingDirectory()) != null ? psiFile.getVirtualFile() : null;
    }
}

