/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.actions;

import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointersKt;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.actions.ImportProviderService;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010H\u0016J\r\u0010\u0011\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0012H\u0016J3\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0096\u0002J2\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0003H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/actions/AddProviderAction;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lcom/intellij/psi/PsiElement;", "<init>", "(Lcom/intellij/psi/PsiElement;)V", "generatePreview", "Lcom/intellij/codeInsight/intention/preview/IntentionPreviewInfo;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiFile", "Lcom/intellij/psi/PsiFile;", "getText", "", "Lcom/intellij/codeInspection/util/IntentionName;", "getFamilyName", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "invoke", "", "startElement", "endElement", "isAvailable", "", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nAddProviderAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AddProviderAction.kt\norg/intellij/terraform/config/actions/AddProviderAction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,173:1\n1#2:174\n30#3,2:175\n*S KotlinDebug\n*F\n+ 1 AddProviderAction.kt\norg/intellij/terraform/config/actions/AddProviderAction\n*L\n66#1:175,2\n*E\n"})
public final class AddProviderAction
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public AddProviderAction(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(element);
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        List<BlockType> possibleTypes;
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
                PsiElement psiElement = this.getStartElement();
                object = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
                if (object == null || (object = SmartPointersKt.createSmartPointer((PsiElement)((PsiElement)object))) == null) break block4;
                List<BlockType> it = object;
                boolean bl = false;
                List<BlockType> list = TfModelHelper.INSTANCE.getAllTypesForBlockByIdentifier((SmartPsiElementPointer<HCLBlock>)it);
                object = list;
                if (list != null) break block5;
            }
            object = CollectionsKt.emptyList();
        }
        if ((possibleTypes = object).size() == 1) {
            IntentionPreviewInfo intentionPreviewInfo = super.generatePreview(project, editor, psiFile);
            Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"generatePreview(...)");
            return intentionPreviewInfo;
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)intentionPreviewInfo, (String)"EMPTY");
        return intentionPreviewInfo;
    }

    @NotNull
    public String getText() {
        String string = HCLBundle.message("action.AddProviderAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = HCLBundle.message("action.AddProviderAction.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        if (editor != null && startElement instanceof HCLBlock) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<ImportProviderService> serviceClass$iv = ImportProviderService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            ((ImportProviderService)object).scheduleAddProvider(editor, (SmartPsiElementPointer<HCLBlock>)SmartPointersKt.createSmartPointer((PsiElement)startElement));
        }
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        return editor != null && UtilKt.isTerraformCompatiblePsiFile(psiFile) && startElement instanceof HCLBlock && ((HCLBlock)startElement).getNameElements().length >= 2;
    }
}

