/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/codeinsight/QuoteInsertHandler;", "Lcom/intellij/codeInsight/completion/BasicInsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "isCharAtCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "c", "", "intellij.terraform"})
public final class QuoteInsertHandler
extends BasicInsertHandler<LookupElement> {
    @NotNull
    public static final QuoteInsertHandler INSTANCE = new QuoteInsertHandler();

    private QuoteInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Editor editor = context.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        Editor editor2 = editor;
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile file = psiFile;
        PsiElement element = file.findElementAt(context.getStartOffset());
        Character c = null;
        if (element instanceof HCLStringLiteral) {
            var7_7 = ((HCLStringLiteral)element).getNode().getFirstChildNode().getElementType();
            if (Intrinsics.areEqual((Object)var7_7, (Object)HCLElementTypes.SINGLE_QUOTED_STRING)) {
                c = Character.valueOf('\'');
            } else if (Intrinsics.areEqual((Object)var7_7, (Object)HCLElementTypes.DOUBLE_QUOTED_STRING)) {
                c = Character.valueOf('\"');
            }
        } else {
            PsiElement psiElement = element;
            IElementType iElementType = psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : (var7_7 = null);
            if (Intrinsics.areEqual((Object)var7_7, (Object)HCLElementTypes.SINGLE_QUOTED_STRING)) {
                c = Character.valueOf('\'');
            } else if (Intrinsics.areEqual((Object)var7_7, (Object)HCLElementTypes.DOUBLE_QUOTED_STRING)) {
                c = Character.valueOf('\"');
            }
        }
        if (c == null) {
            return;
        }
        if (context.getCompletionChar() == c.charValue()) {
            return;
        }
        Project project = editor2.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        if (!this.isCharAtCaret(editor2, c.charValue())) {
            EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)String.valueOf(c.charValue()));
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor2.getDocument());
        } else {
            editor2.getCaretModel().moveToOffset(editor2.getCaretModel().getOffset() + 1);
        }
    }

    private final boolean isCharAtCaret(Editor editor, char c) {
        int startOffset = editor.getCaretModel().getOffset();
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        return document2.getTextLength() > startOffset && document2.getCharsSequence().charAt(startOffset) == c;
    }
}

