/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Hint;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ObjectType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ReferenceHint;
import org.intellij.terraform.config.model.SetType;
import org.intellij.terraform.config.model.TupleType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hil.codeinsight.ReferenceCompletionHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJ$\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/codeinsight/ResourcePropertyInsertHandler;", "Lcom/intellij/codeInsight/completion/BasicInsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "getPlaceholderValue", "Lkotlin/Pair;", "", "", "type", "Lorg/intellij/terraform/config/model/HclType;", "getProposedValueFromModelAndHint", "property", "Lorg/intellij/terraform/config/model/PropertyType;", "module", "Lorg/intellij/terraform/config/model/Module;", "isNextIsEqual", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nResourcePropertyInsertHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcePropertyInsertHandler.kt\norg/intellij/terraform/config/codeinsight/ResourcePropertyInsertHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1#2:91\n1#2:102\n1#2:115\n11879#3,9:92\n13805#3:101\n13806#3:103\n11888#3:104\n1617#4,9:105\n1869#4:114\n1870#4:116\n1626#4:117\n*S KotlinDebug\n*F\n+ 1 ResourcePropertyInsertHandler.kt\norg/intellij/terraform/config/codeinsight/ResourcePropertyInsertHandler\n*L\n68#1:102\n70#1:115\n68#1:92,9\n68#1:101\n68#1:103\n68#1:104\n70#1:105,9\n70#1:114\n70#1:116\n70#1:117\n*E\n"})
public final class ResourcePropertyInsertHandler
extends BasicInsertHandler<LookupElement> {
    @NotNull
    public static final ResourcePropertyInsertHandler INSTANCE = new ResourcePropertyInsertHandler();

    private ResourcePropertyInsertHandler() {
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Project project;
        Editor editor;
        block11: {
            Pair<String, Integer> pair;
            Pair<String, Integer> pair2;
            block13: {
                Object obj;
                block12: {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)item, (String)"item");
                    Editor editor2 = context.getEditor();
                    Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"getEditor(...)");
                    editor = editor2;
                    Project project2 = context.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                    project = project2;
                    PsiElement element = context.getFile().findElementAt(context.getStartOffset());
                    if (element instanceof HCLIdentifier || element instanceof HCLStringLiteral) {
                        if (this.isNextIsEqual(element)) {
                            return;
                        }
                    } else {
                        PsiElement psiElement = element;
                        if (HCLTokenTypes.IDENTIFYING_LITERALS.contains(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null)) {
                            PsiElement psiElement2 = element;
                            if (this.isNextIsEqual((PsiElement)(psiElement2 != null ? psiElement2.getParent() : null))) {
                                return;
                            }
                        }
                    }
                    if (StringsKt.contains$default((CharSequence)" =", (char)context.getCompletionChar(), (boolean)false, (int)2, null)) {
                        context.setAddCompletionChar(false);
                    }
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" = ");
                    Object object = item.getObject();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
                    obj = object;
                    if (!(obj instanceof PropertyType)) break block11;
                    HCLElement hCLElement = (HCLElement)PsiTreeUtil.getParentOfType((PsiElement)element, HCLElement.class);
                    Object module = hCLElement != null ? ExtensionsKt.getTerraformModule(hCLElement) : null;
                    pair2 = module;
                    if (pair2 == null) break block12;
                    Pair<String, Integer> it = pair2;
                    boolean bl = false;
                    Pair<String, Integer> pair3 = INSTANCE.getProposedValueFromModelAndHint((PropertyType)obj, (Module)module);
                    pair2 = pair3;
                    if (pair3 != null) break block13;
                }
                pair2 = this.getPlaceholderValue(((PropertyType)obj).getType());
            }
            if ((pair = pair2) != null) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)((String)pair.getFirst()));
                EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)((Number)pair.getSecond()).intValue());
            }
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
    }

    @Nullable
    public final Pair<String, Integer> getPlaceholderValue(@NotNull HclType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        HclType hclType = type;
        return Intrinsics.areEqual((Object)hclType, (Object)Types.INSTANCE.getString()) ? new Pair((Object)"\"\"", (Object)-1) : (hclType instanceof MapType || hclType instanceof ObjectType ? new Pair((Object)"{}", (Object)-1) : (hclType instanceof ListType || hclType instanceof SetType || hclType instanceof TupleType ? new Pair((Object)"[]", (Object)-1) : null));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Pair<String, Integer> getProposedValueFromModelAndHint(@NotNull PropertyType property, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Hint hint = property.getHint();
        if (hint instanceof ReferenceHint) {
            Iterable $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            String[] stringArray = ((ReferenceHint)hint).getHint();
            boolean $i$f$mapNotNull = false;
            void var7_6 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                List<Object> it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (ReferenceCompletionHelper.INSTANCE.findByFQNRef((String)it, module) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
            $i$f$mapNotNull = false;
            $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Pair it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Object it = element$iv$iv;
                boolean bl4 = false;
                if ((it instanceof String ? new Pair(module.isHCL2Supported() ? (String)it : "\"${" + it + "}\"", (Object)0) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List suggestions = (List)destination$iv$iv;
            if (suggestions.size() == 1) {
                return (Pair)CollectionsKt.first((List)suggestions);
            }
        }
        return null;
    }

    private final boolean isNextIsEqual(PsiElement element) {
        PsiElement psiElement = element;
        return Intrinsics.areEqual(psiElement != null && (psiElement = HCLPsiUtil.getNextSiblingNonWhiteSpace(psiElement)) != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null, (Object)HCLElementTypes.EQUALS);
    }
}

