/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.completion.BasicInsertHandler;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.TerraformIcons;
import org.intellij.terraform.config.TerraformFileType;
import org.intellij.terraform.config.codeinsight.BlockSubNameInsertHandler;
import org.intellij.terraform.config.codeinsight.ResourceBlockNameInsertHandler;
import org.intellij.terraform.config.codeinsight.ResourcePropertyInsertHandler;
import org.intellij.terraform.config.codeinsight.TfLookupElementRenderer;
import org.intellij.terraform.config.documentation.psi.HclFakeElementPsiFactory;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.model.NamedType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.ProviderType;
import org.intellij.terraform.config.model.ResourceOrDataSourceType;
import org.intellij.terraform.config.model.TfFunction;
import org.intellij.terraform.config.model.TfTypeModel;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.hcl.HCLElementTypes;
import org.intellij.terraform.hcl.HCLTokenTypes;
import org.intellij.terraform.hcl.Icons;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hil.codeinsight.ScopeSelectInsertHandler;
import org.intellij.terraform.opentofu.OpenTofuConstants;
import org.intellij.terraform.opentofu.OpenTofuFileType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u000e\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0006J\u0018\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010\u001f\u001a\u00020 J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aJ\u0016\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aJ\u0018\u0010'\u001a\u00020\u00152\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001aH\u0002J\u0016\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)J\u0012\u0010-\u001a\u0004\u0018\u00010\u00062\b\u0010%\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010.\u001a\u0004\u0018\u00010\u00062\u0006\u0010*\u001a\u00020+J\u0015\u0010/\u001a\u00020\u00062\u0006\u0010#\u001a\u00020$H\u0001\u00a2\u0006\u0002\b0J)\u00101\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u00112\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u000604H\u0001\u00a2\u0006\u0002\b5J\u0015\u00106\u001a\u00020\u00062\u0006\u00102\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b7J\u000e\u00108\u001a\u0002092\u0006\u0010%\u001a\u00020\u001aR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006:"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfCompletionUtil;", "", "<init>", "()V", "Scopes", "", "", "getScopes", "()Ljava/util/Set;", "GlobalScopes", "Ljava/util/SortedSet;", "getGlobalScopes", "()Ljava/util/SortedSet;", "RootBlockKeywords", "getRootBlockKeywords", "RootBlockSorted", "", "Lorg/intellij/terraform/config/model/BlockType;", "getRootBlockSorted", "()Ljava/util/List;", "createPropertyOrBlockType", "Lcom/intellij/codeInsight/lookup/LookupElementBuilder;", "value", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "lookupString", "psiElement", "Lcom/intellij/psi/PsiElement;", "createScopeLookup", "createFunction", "function", "Lorg/intellij/terraform/config/model/TfFunction;", "isTerragrunt", "", "buildLookupForProviderBlock", "Lcom/intellij/codeInsight/lookup/LookupElement;", "provider", "Lorg/intellij/terraform/config/model/ProviderType;", "element", "buildLookupForRequiredProvider", "createProviderLookupElement", "getOriginalObject", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "obj", "getClearTextValue", "getIncomplete", "buildProviderTypeText", "buildProviderTypeText$intellij_terraform", "buildResourceDisplayString", "block", "providerLocalNames", "", "buildResourceDisplayString$intellij_terraform", "buildResourceFullString", "buildResourceFullString$intellij_terraform", "getLookupIcon", "Ljavax/swing/Icon;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfCompletionUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfCompletionUtil.kt\norg/intellij/terraform/config/codeinsight/TfCompletionUtil\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n30#2,2:191\n1056#3:193\n*S KotlinDebug\n*F\n+ 1 TfCompletionUtil.kt\norg/intellij/terraform/config/codeinsight/TfCompletionUtil\n*L\n105#1:191,2\n69#1:193\n*E\n"})
public final class TfCompletionUtil {
    @NotNull
    public static final TfCompletionUtil INSTANCE = new TfCompletionUtil();
    @NotNull
    private static final Set<String> Scopes;
    @NotNull
    private static final SortedSet<String> GlobalScopes;
    @NotNull
    private static final Set<String> RootBlockKeywords;
    @NotNull
    private static final List<BlockType> RootBlockSorted;

    private TfCompletionUtil() {
    }

    @NotNull
    public final Set<String> getScopes() {
        return Scopes;
    }

    @NotNull
    public final SortedSet<String> getGlobalScopes() {
        return GlobalScopes;
    }

    @NotNull
    public final Set<String> getRootBlockKeywords() {
        return RootBlockKeywords;
    }

    @NotNull
    public final List<BlockType> getRootBlockSorted() {
        return RootBlockSorted;
    }

    @NotNull
    public final LookupElementBuilder createPropertyOrBlockType(@NotNull PropertyOrBlockType value, @Nullable String lookupString, @Nullable PsiElement psiElement) {
        LookupElementBuilder lookupElementBuilder;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (psiElement == null) {
            String string = lookupString;
            if (string == null) {
                string = value.getName();
            }
            lookupElementBuilder = LookupElementBuilder.create((Object)value, (String)string);
        } else {
            String string = lookupString;
            if (string == null) {
                string = value.getName();
            }
            lookupElementBuilder = LookupElementBuilder.create((Object)value, (String)string).withPsiElement(psiElement);
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder;
        Intrinsics.checkNotNull((Object)lookupElementBuilder2);
        LookupElementBuilder elementBuilder = lookupElementBuilder2;
        PropertyOrBlockType propertyOrBlockType = value;
        lookupElementBuilder2 = elementBuilder.withRenderer((LookupElementRenderer)new TfLookupElementRenderer()).withInsertHandler((InsertHandler)(propertyOrBlockType instanceof BlockType ? (BasicInsertHandler)new ResourceBlockNameInsertHandler((BlockType)value) : (propertyOrBlockType instanceof PropertyType ? (BasicInsertHandler)ResourcePropertyInsertHandler.INSTANCE : null)));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withInsertHandler(...)");
        return lookupElementBuilder2;
    }

    public static /* synthetic */ LookupElementBuilder createPropertyOrBlockType$default(TfCompletionUtil tfCompletionUtil, PropertyOrBlockType propertyOrBlockType, String string, PsiElement psiElement, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            psiElement = null;
        }
        return tfCompletionUtil.createPropertyOrBlockType(propertyOrBlockType, string, psiElement);
    }

    @NotNull
    public final LookupElementBuilder createScopeLookup(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((String)value).withInsertHandler((InsertHandler)ScopeSelectInsertHandler.INSTANCE).withRenderer((LookupElementRenderer)new LookupElementRenderer<LookupElement>(){

            public void renderElement(LookupElement element, LookupElementPresentation presentation) {
                block1: {
                    LookupElementPresentation lookupElementPresentation = presentation;
                    if (lookupElementPresentation != null) {
                        lookupElementPresentation.setIcon(AllIcons.Nodes.Tag);
                    }
                    LookupElementPresentation lookupElementPresentation2 = presentation;
                    if (lookupElementPresentation2 == null) break block1;
                    LookupElement lookupElement = element;
                    lookupElementPresentation2.setItemText(lookupElement != null ? lookupElement.getLookupString() : null);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withRenderer(...)");
        return lookupElementBuilder;
    }

    @NotNull
    public final LookupElementBuilder createFunction(@NotNull TfFunction function, boolean isTerragrunt) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)function, (String)function.getPresentableName()).withInsertHandler((InsertHandler)(function.getArguments().length == 0 ? ParenthesesInsertHandler.NO_PARAMETERS : ParenthesesInsertHandler.WITH_PARAMETERS)).withTailText(function.getArgumentsAsText()).withTypeText(function.getReturnType().getPresentableText()).withIcon(isTerragrunt ? TerraformIcons.Terragrunt : AllIcons.Nodes.Function);
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        return lookupElementBuilder;
    }

    public static /* synthetic */ LookupElementBuilder createFunction$default(TfCompletionUtil tfCompletionUtil, TfFunction tfFunction, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return tfCompletionUtil.createFunction(tfFunction, bl);
    }

    @NotNull
    public final LookupElement buildLookupForProviderBlock(@NotNull ProviderType provider, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LookupElementBuilder lookupElementBuilder = this.createProviderLookupElement(provider, element).withInsertHandler((InsertHandler)new BlockSubNameInsertHandler(provider));
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<HclFakeElementPsiFactory> serviceClass$iv = HclFakeElementPsiFactory.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        LookupElementBuilder lookupElementBuilder2 = lookupElementBuilder.withPsiElement((PsiElement)((HclFakeElementPsiFactory)object).createFakeHclBlock(provider, element.getContainingFile().getOriginalFile()));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder2, (String)"withPsiElement(...)");
        return (LookupElement)lookupElementBuilder2;
    }

    @NotNull
    public final LookupElement buildLookupForRequiredProvider(@NotNull ProviderType provider, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        LookupElementBuilder lookupElementBuilder = this.createProviderLookupElement(provider, element).withInsertHandler((arg_0, arg_1) -> TfCompletionUtil.buildLookupForRequiredProvider$lambda$0(provider, arg_0, arg_1));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withInsertHandler(...)");
        return (LookupElement)lookupElementBuilder;
    }

    private final LookupElementBuilder createProviderLookupElement(ProviderType provider, PsiElement element) {
        LookupElementBuilder lookupElementBuilder = LookupElementBuilder.create((Object)provider, (String)provider.getType()).withTailText(" " + provider.getFullName()).withTypeText(provider.getVersion()).withIcon(this.getLookupIcon(element));
        Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"withIcon(...)");
        return lookupElementBuilder;
    }

    @NotNull
    public final HCLObject getOriginalObject(@NotNull CompletionParameters parameters, @NotNull HCLObject obj) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        PsiElement psiElement = parameters.getOriginalFile().findElementAt(obj.getTextRange().getStartOffset());
        PsiElement originalObject = psiElement != null ? psiElement.getParent() : null;
        HCLObject hCLObject = originalObject instanceof HCLObject ? (HCLObject)originalObject : null;
        if (hCLObject == null) {
            hCLObject = obj;
        }
        return hCLObject;
    }

    @Nullable
    public final String getClearTextValue(@Nullable PsiElement element) {
        String string;
        if (element == null) {
            string = null;
        } else if (element instanceof HCLIdentifier) {
            string = ((HCLIdentifier)element).getId();
        } else if (element instanceof HCLStringLiteral) {
            string = ((HCLStringLiteral)element).getValue();
        } else {
            ASTNode aSTNode = element.getNode();
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)HCLElementTypes.ID)) {
                string = element.getText();
            } else {
                ASTNode aSTNode2 = element.getNode();
                if (HCLTokenTypes.STRING_LITERALS.contains((IElementType)(aSTNode2 != null ? aSTNode2.getElementType() : null))) {
                    String string2 = element.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                    string = HCLPsiUtil.stripQuotes(string2);
                } else {
                    string = null;
                }
            }
        }
        return string;
    }

    @Nullable
    public final String getIncomplete(@NotNull CompletionParameters parameters) {
        String text;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        String string = this.getClearTextValue(position);
        if (string == null) {
            string = position.getText();
        }
        if (Intrinsics.areEqual((Object)(text = string), (Object)"IntellijIdeaRulezzz")) {
            return null;
        }
        Intrinsics.checkNotNull((Object)text);
        return StringUtil.nullize((String)StringsKt.replace$default((String)text, (String)"IntellijIdeaRulezzz", (String)"", (boolean)false, (int)4, null), (boolean)true);
    }

    @NlsSafe
    @NotNull
    public final String buildProviderTypeText$intellij_terraform(@NotNull ProviderType provider) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        return provider.getFullName() + (String)(!StringsKt.isBlank((CharSequence)provider.getVersion()) ? " " + provider.getVersion() : "");
    }

    @NlsSafe
    @NotNull
    public final String buildResourceDisplayString$intellij_terraform(@NotNull BlockType block, @NotNull Map<String, String> providerLocalNames) {
        String string;
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter(providerLocalNames, (String)"providerLocalNames");
        BlockType blockType = block;
        if (blockType instanceof ResourceOrDataSourceType) {
            String string2 = providerLocalNames.get(((ResourceOrDataSourceType)((Object)block)).getProvider().getFullName());
            if (string2 == null) {
                return ((NamedType)((Object)block)).getType();
            }
            String providerLocalName = string2;
            return providerLocalName + "_" + TfTypeModel.Companion.getResourceName(((NamedType)((Object)block)).getType());
        }
        if (blockType instanceof ProviderType) {
            String providerLocalName;
            String string3 = providerLocalNames.get(((ProviderType)block).getFullName());
            if (string3 == null) {
                return ((ProviderType)block).getType();
            }
            string = providerLocalName = string3;
        } else {
            string = block.getLiteral();
        }
        return string;
    }

    @NlsSafe
    @NotNull
    public final String buildResourceFullString$intellij_terraform(@NotNull BlockType block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        BlockType blockType = block;
        if (blockType instanceof ResourceOrDataSourceType) {
            return ((NamedType)((Object)block)).getType() + " (" + this.buildProviderTypeText$intellij_terraform(((ResourceOrDataSourceType)((Object)block)).getProvider()) + ")";
        }
        if (blockType instanceof ProviderType) {
            return ((ProviderType)block).getFullName() + " " + ((ProviderType)block).getVersion();
        }
        return block.getPresentableText();
    }

    @NotNull
    public final Icon getLookupIcon(@NotNull PsiElement element) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        FileType fileType = element.getContainingFile().getFileType();
        if (fileType instanceof TerraformFileType) {
            Icon icon2 = TerraformIcons.Terraform;
            icon = icon2;
            Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"Terraform");
        } else if (fileType instanceof OpenTofuFileType) {
            Icon icon3 = TerraformIcons.Opentofu;
            icon = icon3;
            Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Opentofu");
        } else {
            icon = Icons.FileTypes.INSTANCE.getHCL();
        }
        return icon;
    }

    private static final void buildLookupForRequiredProvider$lambda$0(ProviderType $provider, InsertionContext context, LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        HCLProperty providerProperty = new TfElementGenerator(project2).createRequiredProviderProperty($provider);
        Document document = context.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        document2.replaceString(context.getStartOffset(), context.getTailOffset(), (CharSequence)providerProperty.getText());
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document2);
        PsiFile psiFile = context.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile psiFile2 = psiFile;
        HCLBlock hCLBlock = TfTypeModel.Companion.getTerraformBlock(psiFile2);
        if (hCLBlock == null) {
            return;
        }
        HCLBlock terraformBlock = hCLBlock;
        CodeStyleManager.getInstance((Project)project2).reformatText(psiFile2, (Collection)CollectionsKt.listOf((Object)terraformBlock.getTextRange()));
    }

    static {
        Object[] objectArray = new String[]{"data", "var", "self", "path", "count", "terraform", "local", "module", "ephemeral"};
        Scopes = SetsKt.plus((Set)SetsKt.setOf((Object[])objectArray), (Iterable)OpenTofuConstants.INSTANCE.getOpenTofuScopes$intellij_terraform());
        objectArray = new String[]{"var", "path", "data", "module", "local", "ephemeral"};
        GlobalScopes = CollectionsKt.toSortedSet((Iterable)SetsKt.plus((Set)SetsKt.setOf((Object[])objectArray), (Iterable)OpenTofuConstants.INSTANCE.getOpenTofuScopes$intellij_terraform()));
        RootBlockKeywords = TfTypeModel.Companion.getRootBlocksMap().keySet();
        Iterable $this$sortedBy$iv = TfTypeModel.Companion.getRootBlocks();
        boolean $i$f$sortedBy = false;
        RootBlockSorted = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                BlockType it = (BlockType)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getLiteral());
                it = (BlockType)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLiteral())));
            }
        });
    }
}

