/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.codeinsight;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.terraform.config.codeinsight.QuoteInsertHandler;
import org.intellij.terraform.config.codeinsight.ResourcePropertyInsertHandler;
import org.intellij.terraform.config.codeinsight.TfCompletionUtil;
import org.intellij.terraform.config.codeinsight.TfConfigCompletionContributor;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.Module;
import org.intellij.terraform.config.model.ObjectType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.model.Variable;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLPsiUtil;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.UtilKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00100\u00182\u0006\u0010\u0011\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00100\u0018H\u0002J \u0010\u001f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J(\u0010 \u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/terraform/config/codeinsight/TfPropertyObjectKeyCompletionProvider;", "Lorg/intellij/terraform/config/codeinsight/TfConfigCompletionContributor$TfCompletionProvider;", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "addCompletions", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "getLeftmostName", "", "element", "Lcom/intellij/psi/PsiElement;", "addPropertyValueCompletions", "obj", "Lorg/intellij/terraform/hcl/psi/HCLObject;", "addPropertyCompletions", "pathToRootObject", "", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "findObjectTypeInModule", "Lorg/intellij/terraform/config/model/ObjectType;", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "pathFromRoot", "addInnerBlockCompletions", "handleModuleProvidersMapping", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfPropertyObjectKeyCompletionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfPropertyObjectKeyCompletionProvider.kt\norg/intellij/terraform/config/codeinsight/TfPropertyObjectKeyCompletionProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,127:1\n60#2,5:128\n60#2,5:133\n60#2,5:146\n60#2,5:162\n1563#3:138\n1634#3,3:139\n1563#3:142\n1634#3,3:143\n1563#3:155\n1634#3,3:156\n1803#3,3:159\n1563#3:167\n1634#3,3:168\n1563#3:171\n1634#3,3:172\n774#3:175\n865#3,2:176\n1563#3:178\n1634#3,3:179\n126#4:151\n153#4,3:152\n*S KotlinDebug\n*F\n+ 1 TfPropertyObjectKeyCompletionProvider.kt\norg/intellij/terraform/config/codeinsight/TfPropertyObjectKeyCompletionProvider\n*L\n31#1:128,5\n52#1:133,5\n68#1:146,5\n105#1:162,5\n59#1:138\n59#1:139,3\n60#1:142\n60#1:143,3\n80#1:155\n80#1:156,3\n97#1:159,3\n118#1:167\n118#1:168,3\n120#1:171\n120#1:172,3\n121#1:175\n121#1:176,2\n123#1:178\n123#1:179,3\n79#1:151\n79#1:152,3\n*E\n"})
public final class TfPropertyObjectKeyCompletionProvider
extends TfConfigCompletionContributor.TfCompletionProvider {
    @NotNull
    public static final TfPropertyObjectKeyCompletionProvider INSTANCE = new TfPropertyObjectKeyCompletionProvider();
    @NotNull
    private static final Logger LOG;

    private TfPropertyObjectKeyCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result2) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        PsiElement psiElement = parameters.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPosition(...)");
        PsiElement position = psiElement;
        PsiElement parent = position.getParent();
        HCLObject hCLObject = (HCLObject)PsiTreeUtil.getParentOfType((PsiElement)parent, HCLObject.class, (boolean)false);
        if (hCLObject == null) {
            return;
        }
        HCLObject obj = hCLObject;
        if ((parent instanceof HCLStringLiteral || parent instanceof HCLIdentifier) && HCLPsiUtil.INSTANCE.isPartOfPropertyValue(parent)) {
            this.addPropertyValueCompletions(result2, obj);
            return;
        }
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("TF.TfPropertyObjectKeyCompletionProvider{position=" + position + ", parent=" + parent + ", obj=" + obj + "}", e$iv);
        }
        PsiElement psiElement2 = obj.getParent();
        if (psiElement2 instanceof HCLProperty) {
            this.addPropertyCompletions(parameters, result2, obj);
            return;
        }
        if (psiElement2 instanceof HCLBlock) {
            this.addInnerBlockCompletions(parameters, result2, obj);
            return;
        }
    }

    private final String getLeftmostName(PsiElement element) {
        if (element instanceof HCLProperty) {
            return ((HCLProperty)element).getName();
        }
        if (element instanceof HCLBlock) {
            return UtilKt.getNameElementUnquoted((HCLBlock)element, 0);
        }
        return null;
    }

    private final void addPropertyValueCompletions(CompletionResultSet result2, HCLObject obj) {
        Object object;
        PsiElement psiElement = obj.getParent();
        if (psiElement == null) {
            return;
        }
        PsiElement inner = psiElement;
        HCLBlock hCLBlock = UtilKt.getParent(inner, HCLBlock.class, true);
        if (hCLBlock == null) {
            return;
        }
        HCLBlock block = hCLBlock;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("TF.TfPropertyObjectKeyCompletionProvider.InSomethingValue{block=" + block + ", inner=" + inner + "}", e$iv);
        }
        String string = this.getLeftmostName(inner);
        if (string == null) {
            return;
        }
        String name = string;
        String type = UtilKt.getNameElementUnquoted(block, 0);
        if (Intrinsics.areEqual((Object)name, (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module")) {
            String it;
            Iterable $this$mapTo$iv$iv;
            Module module = ExtensionsKt.getTerraformModule(block);
            Iterable $this$map$iv = module.getDefinedProviders();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                object.add((String)it.getSecond());
            }
            List providers = (List)destination$iv$iv;
            $this$map$iv = providers;
            object = result2;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)QuoteInsertHandler.INSTANCE));
            }
            object.addAllElements((Iterable)((List)destination$iv$iv));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addPropertyCompletions(CompletionParameters parameters, CompletionResultSet result2, HCLObject obj) {
        Object object;
        PsiElement psiElement = obj.getParent();
        HCLProperty hCLProperty = psiElement instanceof HCLProperty ? (HCLProperty)psiElement : null;
        if (hCLProperty == null) {
            return;
        }
        HCLProperty property = hCLProperty;
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)property, HCLBlock.class);
        if (hCLBlock == null) {
            return;
        }
        HCLBlock block = hCLBlock;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            object = $this$debug_u24default$iv;
            boolean bl = false;
            object.debug("TF.TfPropertyObjectKeyCompletionProvider.Property{block=" + block + ", inner-property=" + property + "}", e$iv);
        }
        String type = UtilKt.getNameElementUnquoted(block, 0);
        if (Intrinsics.areEqual((Object)property.getName(), (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module")) {
            this.handleModuleProvidersMapping(block, parameters, obj, result2);
            return;
        }
        if (Intrinsics.areEqual((Object)type, (Object)"module")) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object2;
            Collection destination$iv$iv;
            Object $this$map$iv2;
            List<String> pathToRoot = this.pathToRootObject(property);
            ObjectType objTypeProperty = this.findObjectTypeInModule(block, CollectionsKt.reversed((Iterable)pathToRoot));
            Object object3 = objTypeProperty;
            if (object3 != null && (object3 = object3.getElements()) != null) {
                void $this$mapTo$iv$iv2;
                $this$map$iv2 = object3;
                boolean $i$f$map = false;
                Object object4 = $this$map$iv2;
                destination$iv$iv = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo = false;
                object2 = $this$mapTo$iv$iv2.entrySet().iterator();
                while (object2.hasNext()) {
                    void it;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = object2.next();
                    object = destination$iv$iv;
                    boolean bl = false;
                    String string = (String)it.getKey();
                    HclType hclType = (HclType)it.getValue();
                    if (hclType == null) {
                        hclType = Types.INSTANCE.getAny();
                    }
                    object.add(new PropertyType(string, hclType, null, false, null, null, false, false, false, false, null, null, false, 8188, null));
                }
            } else {
                return;
            }
            List properties = (List)destination$iv$iv;
            Iterable iterable = properties;
            object = result2;
            boolean $i$f$map = false;
            $this$map$iv2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object2 = (PropertyType)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(TfCompletionUtil.createPropertyOrBlockType$default(TfCompletionUtil.INSTANCE, (PropertyOrBlockType)it, null, null, 6, null));
            }
            object.addAllElements((Iterable)((List)destination$iv$iv2));
        }
    }

    private final List<String> pathToRootObject(HCLProperty element) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)element, TfPropertyObjectKeyCompletionProvider::pathToRootObject$lambda$0), TfPropertyObjectKeyCompletionProvider::pathToRootObject$lambda$1));
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectType findObjectTypeInModule(HCLBlock block, List<String> pathFromRoot) {
        void $this$fold$iv;
        Module module = Module.Companion.getAsModuleBlock(block);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Variable variable = (Variable)CollectionsKt.firstOrNull(module2.findVariables((String)CollectionsKt.first(pathFromRoot)));
        Object object = variable != null ? variable.getType() : null;
        ObjectType rootObject = object instanceof ObjectType ? (ObjectType)object : null;
        object = com.intellij.util.containers.UtilKt.tail(pathFromRoot);
        ObjectType initial$iv = rootObject;
        boolean $i$f$fold = false;
        ObjectType accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void pathElement;
            HclType hclType;
            String string = (String)element$iv;
            ObjectType current = accumulator$iv;
            boolean bl = false;
            Object object2 = current;
            HclType hclType2 = hclType = object2 != null && (object2 = object2.getElements()) != null ? (HclType)object2.get(pathElement) : null;
            if ((hclType instanceof ObjectType ? (ObjectType)hclType : null) == null) {
                return current;
            }
            accumulator$iv = accumulator$iv;
        }
        return accumulator$iv;
    }

    private final void addInnerBlockCompletions(CompletionParameters parameters, CompletionResultSet result2, HCLObject obj) {
        HCLBlock hCLBlock = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)obj, HCLBlock.class);
        if (hCLBlock == null) {
            return;
        }
        HCLBlock innerBlock = hCLBlock;
        HCLBlock hCLBlock2 = (HCLBlock)PsiTreeUtil.getParentOfType((PsiElement)innerBlock, HCLBlock.class, (boolean)true);
        if (hCLBlock2 == null) {
            return;
        }
        HCLBlock block = hCLBlock2;
        Logger $this$debug_u24default$iv = LOG;
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("TF.TfPropertyObjectKeyCompletionProvider.Block{block=" + block + ", inner-block=" + block + "}", e$iv);
        }
        String type = UtilKt.getNameElementUnquoted(block, 0);
        if (Intrinsics.areEqual((Object)innerBlock.getName(), (Object)"providers") && Intrinsics.areEqual((Object)type, (Object)"module")) {
            this.handleModuleProvidersMapping(block, parameters, obj, result2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleModuleProvidersMapping(HCLBlock block, CompletionParameters parameters, HCLObject obj, CompletionResultSet result2) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Module module = Module.Companion.getAsModuleBlock(block);
        if (module == null) {
            return;
        }
        Module module2 = module;
        String incomplete = TfCompletionUtil.INSTANCE.getIncomplete(parameters);
        List<HCLProperty> list = TfCompletionUtil.INSTANCE.getOriginalObject(parameters, obj).getPropertyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getPropertyList(...)");
        Iterable $this$map$iv2 = list;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            HCLProperty hCLProperty = (HCLProperty)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List defined = (List)destination$iv$iv;
        Iterable $i$f$map22 = module2.getDefinedProviders();
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add((String)it.getSecond());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!defined.contains(it) || incomplete != null && StringsKt.contains$default((CharSequence)it, (CharSequence)incomplete, (boolean)false, (int)2, null))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List providers = (List)destination$iv$iv2;
        $this$filter$iv = providers;
        collection = result2;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String it = (String)item$iv$iv;
            Collection collection2 = destination$iv$iv2;
            boolean bl = false;
            collection2.add(LookupElementBuilder.create((String)it).withInsertHandler((InsertHandler)ResourcePropertyInsertHandler.INSTANCE));
        }
        collection.addAllElements((List)destination$iv$iv2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final HCLProperty pathToRootObject$lambda$0(HCLProperty current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        ProgressManager.checkCanceled();
        if (!(current.getParent() instanceof HCLObject)) return null;
        PsiElement psiElement = current.getParent();
        if (!((psiElement != null ? psiElement.getParent() : null) instanceof HCLProperty)) return null;
        PsiElement psiElement2 = current.getParent().getParent();
        if (!(psiElement2 instanceof HCLProperty)) return null;
        HCLProperty hCLProperty = (HCLProperty)psiElement2;
        return hCLProperty;
    }

    private static final String pathToRootObject$lambda$1(HCLProperty it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    static {
        Logger logger = Logger.getInstance(TfPropertyObjectKeyCompletionProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

