/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.formatter;

import com.intellij.application.options.CodeStyleAbstractConfigurable;
import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.config.TerraformLanguage;
import org.intellij.terraform.hcl.formatter.HclCodeStyleOtherPanel;
import org.intellij.terraform.hcl.formatter.HclCodeStyleSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lorg/intellij/terraform/config/formatter/TfCodeStyleSettingsProvider;", "Lcom/intellij/psi/codeStyle/CodeStyleSettingsProvider;", "<init>", "()V", "getLanguage", "Lcom/intellij/lang/Language;", "createConfigurable", "Lcom/intellij/psi/codeStyle/CodeStyleConfigurable;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "originalSettings", "createCustomSettings", "Lcom/intellij/psi/codeStyle/CustomCodeStyleSettings;", "intellij.terraform"})
public final class TfCodeStyleSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return TerraformLanguage.INSTANCE;
    }

    @NotNull
    public CodeStyleConfigurable createConfigurable(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettings originalSettings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)originalSettings, (String)"originalSettings");
        String string = this.getLanguage().getDisplayName();
        return (CodeStyleConfigurable)new CodeStyleAbstractConfigurable(settings, originalSettings, this, string){
            final /* synthetic */ TfCodeStyleSettingsProvider this$0;
            {
                this.this$0 = $receiver;
                super($settings, $originalSettings, $super_call_param$1);
            }

            protected CodeStyleAbstractPanel createPanel(CodeStyleSettings settings) {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                CodeStyleSettings currentSettings = this.getCurrentSettings();
                Language language = this.this$0.getLanguage();
                return (CodeStyleAbstractPanel)new TabbedLanguageCodeStylePanel(currentSettings, settings, language){

                    protected void initTabs(CodeStyleSettings settings) {
                        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                        this.addIndentOptionsTab(settings);
                        this.addSpacesTab(settings);
                        this.addBlankLinesTab(settings);
                        this.addWrappingAndBracesTab(settings);
                        this.addTab(new HclCodeStyleOtherPanel(settings));
                    }
                };
            }
        };
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        String string = this.getLanguage().getID();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getID(...)");
        return new HclCodeStyleSettings(string, settings);
    }
}

