/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.codeinsight.ResourcePropertyInsertHandler;
import org.intellij.terraform.config.model.ExtensionsKt;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.PropertyOrBlockType;
import org.intellij.terraform.config.model.PropertyType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.config.psi.TfElementGenerator;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Lorg/intellij/terraform/config/inspection/AddResourcePropertiesFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "add", "", "Lorg/intellij/terraform/config/model/PropertyOrBlockType;", "<init>", "(Ljava/util/Collection;)V", "getAdd", "()Ljava/util/Collection;", "getName", "", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nHclBlockMissingPropertyInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HclBlockMissingPropertyInspection.kt\norg/intellij/terraform/config/inspection/AddResourcePropertiesFix\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1563#2:174\n1634#2,3:175\n*S KotlinDebug\n*F\n+ 1 HclBlockMissingPropertyInspection.kt\norg/intellij/terraform/config/inspection/AddResourcePropertiesFix\n*L\n60#1:174\n60#1:175,3\n*E\n"})
public final class AddResourcePropertiesFix
implements LocalQuickFix {
    @FileModifier.SafeFieldForPreview
    @NotNull
    private final Collection<PropertyOrBlockType> add;

    public AddResourcePropertiesFix(@NotNull Collection<? extends PropertyOrBlockType> add) {
        Intrinsics.checkNotNullParameter(add, (String)"add");
        this.add = add;
    }

    @NotNull
    public final Collection<PropertyOrBlockType> getAdd() {
        return this.add;
    }

    @NotNull
    public String getName() {
        String string = HCLBundle.message("missing.resource.property.inspection.add.properties.quick.fix.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        return this.getName();
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement().getParent();
        HCLBlock hCLBlock = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
        if (hCLBlock == null) {
            return;
        }
        HCLBlock element = hCLBlock;
        HCLObject hCLObject = element.getObject();
        if (hCLObject == null) {
            return;
        }
        HCLObject obj = hCLObject;
        IntentionPreviewUtils.write(() -> AddResourcePropertiesFix.applyFix$lambda$0(project, this, obj, element));
    }

    /*
     * WARNING - void declaration
     */
    private static final void applyFix$lambda$0(Project $project, AddResourcePropertiesFix this$0, HCLObject $obj, HCLBlock $element) {
        void $this$mapTo$iv$iv;
        TfElementGenerator generator = new TfElementGenerator($project);
        Iterable $this$map$iv = this$0.add;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PsiElement psiElement;
            void it;
            PropertyOrBlockType propertyOrBlockType = (PropertyOrBlockType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (it instanceof PropertyType) {
                Object object;
                Object value;
                HclType type = ((PropertyType)it).getType();
                Object object2 = ResourcePropertyInsertHandler.INSTANCE.getPlaceholderValue(type);
                if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
                    HclType hclType = type;
                    object2 = Intrinsics.areEqual((Object)hclType, (Object)Types.INSTANCE.getBoolean()) ? "false" : (value = Intrinsics.areEqual((Object)hclType, (Object)Types.INSTANCE.getNumber()) ? "0" : (Intrinsics.areEqual((Object)hclType, (Object)Types.INSTANCE.getNull()) ? "null" : "\"\""));
                }
                if ((object = ResourcePropertyInsertHandler.INSTANCE.getProposedValueFromModelAndHint((PropertyType)it, ExtensionsKt.getTerraformModule($element))) == null || (object = (String)object.getFirst()) == null) {
                    object = value;
                }
                value = object;
                psiElement = generator.createProperty(((PropertyType)it).getName(), (String)value);
            } else {
                psiElement = generator.createBlock(it.getName());
            }
            collection.add(psiElement);
        }
        List elements = (List)destination$iv$iv;
        for (PsiElement it : elements) {
            $obj.addBefore(it, $obj.getLastChild());
            $obj.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)"\n", $obj.getNode().getLastChildNode());
        }
    }
}

