/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.util.TfExecutor;
import org.intellij.terraform.config.util.TfExecutorService;
import org.intellij.terraform.config.util.TfExecutorUtilKt;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.install.TfToolType;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/terraform/config/inspection/RunTFToolGetFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "directoryName", "", "executableName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "Companion", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTfMissingModuleInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfMissingModuleInspection.kt\norg/intellij/terraform/config/inspection/RunTFToolGetFix\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,117:1\n30#2,2:118\n*S KotlinDebug\n*F\n+ 1 TfMissingModuleInspection.kt\norg/intellij/terraform/config/inspection/RunTFToolGetFix\n*L\n100#1:118,2\n*E\n"})
public final class RunTFToolGetFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String directoryName;
    @NotNull
    private final String executableName;
    @NotNull
    private static final Logger LOG;

    public RunTFToolGetFix(@NotNull String directoryName, @NotNull String executableName) {
        Intrinsics.checkNotNullParameter((Object)directoryName, (String)"directoryName");
        Intrinsics.checkNotNullParameter((Object)executableName, (String)"executableName");
        this.directoryName = directoryName;
        this.executableName = executableName;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.directoryName, this.executableName};
        String string = HCLBundle.message("missing.module.inspection.run.terraform.get.quick.fix.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.executableName};
        String string = HCLBundle.message("missing.module.inspection.run.terraform.get.quick.fix.family.name", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        HCLBlock hCLBlock = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
        if (hCLBlock == null) {
            return;
        }
        HCLBlock block = hCLBlock;
        PsiFile psiFile = block.getContainingFile();
        if (psiFile == null || (psiFile = psiFile.getContainingDirectory()) == null) {
            return;
        }
        PsiFile dir = psiFile;
        VirtualFile virtualFile = dir.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        VirtualFile vf = virtualFile;
        if (!(vf.getFileSystem() instanceof LocalFileSystem)) {
            LOG.warn("Cannot run on non-local FS: " + vf);
            return;
        }
        TfToolType toolType = TfExecutorUtilKt.getApplicableToolType(vf);
        try {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TfExecutorService> serviceClass$iv = TfExecutorService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            TfExecutorService tfExecutorService = (TfExecutorService)object;
            String[] stringArray = new String[]{"get"};
            TfExecutor tfExecutor = TfExecutor.in(project, toolType).withWorkDirectory(vf.getPath()).withParameters(stringArray).withPresentableName(toolType.getExecutableName() + " get").showOutputOnError().showNotifications(true, false);
            Intrinsics.checkNotNullExpressionValue((Object)tfExecutor, (String)"showNotifications(...)");
            tfExecutorService.executeInBackground(tfExecutor);
        }
        catch (ExecutionException e) {
            LOG.warn("Failed to run '" + toolType.getExecutableName() + " get': " + e.getMessage(), (Throwable)e);
            Object[] objectArray = new Object[]{e.getMessage(), toolType.getExecutableName()};
            String string = HCLBundle.message("missing.module.inspection.run.terraform.get.quick.fix.failure.message", objectArray);
            objectArray = new Object[]{toolType.getDisplayName()};
            Messages.showMessageDialog((Project)project, (String)string, (String)HCLBundle.message("missing.module.inspection.run.terraform.get.quick.fix.failure.title", objectArray), (Icon)Messages.getErrorIcon());
        }
    }

    static {
        Logger logger = Logger.getInstance(RunTFToolGetFix.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/intellij/terraform/config/inspection/RunTFToolGetFix$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.terraform"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

