/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInsight.completion.CodeCompletionHandlerBase;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommandAction;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandAction;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.UniqueNameGenerator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.codeinsight.TfInsertHandlerService;
import org.intellij.terraform.config.codeinsight.TfModelHelper;
import org.intellij.terraform.config.model.BlockType;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.config.refactoring.TfElementRenameValidator;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\u001d\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "getID", "", "getBatchSuppressActions", "", "Lcom/intellij/codeInspection/SuppressQuickFix;", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)[Lcom/intellij/codeInspection/SuppressQuickFix;", "MyEV", "AddNameElementsQuickFix", "RemoveExtraNameElementsQuickFix", "RenameBlockFix", "intellij.terraform"})
public final class TfBlockNameValidnessInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformCompatiblePsiFile(file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @NotNull
    public String getID() {
        return "BlockNameValidness";
    }

    @NotNull
    public SuppressQuickFix[] getBatchSuppressActions(@Nullable PsiElement element) {
        SuppressQuickFix[] suppressQuickFixArray = super.getBatchSuppressActions(PsiTreeUtil.getParentOfType((PsiElement)element, HCLBlock.class, (boolean)false));
        Intrinsics.checkNotNullExpressionValue((Object)suppressQuickFixArray, (String)"getBatchSuppressActions(...)");
        return suppressQuickFixArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J3\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0096\u0002\u00a8\u0006\u0016"}, d2={"Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$AddNameElementsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFixAndIntentionActionOnPsiElement;", "element", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)V", "getText", "", "getFamilyName", "startInWriteAction", "", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "psiFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfBlockNameValidnessInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfBlockNameValidnessInspection.kt\norg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$AddNameElementsQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public static final class AddNameElementsQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public AddNameElementsQuickFix(@NotNull HCLBlock element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @NotNull
        public String getText() {
            String string = HCLBundle.message("block.name.validness.inspection.add.name.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
            HCLBlock hCLBlock = startElement instanceof HCLBlock ? (HCLBlock)startElement : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock block = hCLBlock;
            if (editor == null) {
                return;
            }
            if (!TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)block.getContainingFile())) {
                return;
            }
            BlockType blockType = TfModelHelper.INSTANCE.getAbstractBlockType(block);
            if (blockType == null) {
                return;
            }
            BlockType type = blockType;
            HCLElement[] hCLElementArray = block.getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
            HCLElement[] nameElements = hCLElementArray;
            int required = type.getArgs() + 1 - nameElements.length;
            if (required <= 0) {
                return;
            }
            WriteAction.run(() -> AddNameElementsQuickFix.invoke$lambda$0(nameElements, editor, required));
            CodeCompletionHandlerBase.createHandler((CompletionType)CompletionType.BASIC).invokeCompletion(project, editor);
        }

        private static final void invoke$lambda$0(HCLElement[] $nameElements, Editor $editor, int $required) {
            HCLElement it = (HCLElement)ArraysKt.last((Object[])$nameElements);
            boolean bl = false;
            int offset = it.getTextOffset() + it.getTextLength();
            $editor.getCaretModel().moveToOffset(offset);
            TfInsertHandlerService.Companion.addArguments$intellij_terraform($required, $editor);
            $editor.getCaretModel().moveToOffset(offset + $required * 3 - 1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "visitStringLiteral", "", "o", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "visitBlock", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfBlockNameValidnessInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfBlockNameValidnessInspection.kt\norg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$MyEV\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @Override
        public void visitStringLiteral(@NotNull HCLStringLiteral o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            PsiElement psiElement = o.getParent();
            HCLBlock hCLBlock = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock parent = hCLBlock;
            if (parent.getNameIdentifier() != o) {
                return;
            }
            String string = o.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.holder.registerProblem((PsiElement)o, HCLBundle.message("block.name.validness.inspection.block.name.should.not.be.empty.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitBlock(@NotNull HCLBlock o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (!TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)o.getContainingFile())) {
                return;
            }
            TfElementRenameValidator validator = new TfElementRenameValidator();
            PsiElement identifier = o.getNameIdentifier();
            if (identifier != null && validator.getPattern().accepts((Object)o)) {
                String string = o.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                if (!validator.isInputValid(string, o)) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{RenameBlockFix.INSTANCE};
                    this.holder.registerProblem(identifier, HCLBundle.message("block.name.validness.inspection.invalid.name.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
                }
            }
            BlockType blockType = TfModelHelper.INSTANCE.getAbstractBlockType(o);
            if (blockType == null) {
                return;
            }
            BlockType type = blockType;
            Object[] objectArray = o.getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getNameElements(...)");
            Object[] nameElements = objectArray;
            int required = type.getArgs() + 1 - nameElements.length;
            if (required == 0) {
                return;
            }
            if (required > 0) {
                void it;
                HCLElement hCLElement = (HCLElement)ArraysKt.last((Object[])nameElements);
                int n = ((HCLElement)ArraysKt.first((Object[])nameElements)).getStartOffsetInParent();
                boolean bl = false;
                int n2 = it.getStartOffsetInParent() + it.getTextLength();
                int n3 = n2;
                int n4 = n;
                TextRange range = new TextRange(n4, n3);
                Object[] objectArray2 = new Object[]{required};
                String string = HCLBundle.message("block.name.validness.inspection.missing.block.name.error.message", objectArray2);
                objectArray2 = new LocalQuickFix[]{new AddNameElementsQuickFix(o)};
                this.holder.registerProblem((PsiElement)o, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, range, (LocalQuickFix[])objectArray2);
            } else {
                void it;
                List extra = CollectionsKt.takeLast((List)ArraysKt.toList((Object[])nameElements), (int)(-1 * required));
                HCLElement bl = (HCLElement)CollectionsKt.last((List)extra);
                int n = ((HCLElement)CollectionsKt.first((List)extra)).getStartOffsetInParent();
                boolean bl2 = false;
                int n5 = it.getStartOffsetInParent() + it.getTextLength();
                int n6 = n5;
                int n7 = n;
                TextRange range = new TextRange(n7, n6);
                this.holder.problem((PsiElement)o, HCLBundle.message("block.name.validness.inspection.extra.block.name.error.message", new Object[0])).range(range).fix((ModCommandAction)new RemoveExtraNameElementsQuickFix(o)).register();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0094\u0002\u00a8\u0006\u000f"}, d2={"Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$RemoveExtraNameElementsQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandAction;", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "element", "<init>", "(Lorg/intellij/terraform/hcl/psi/HCLBlock;)V", "getFamilyName", "", "invoke", "", "context", "Lcom/intellij/modcommand/ActionContext;", "block", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    public static final class RemoveExtraNameElementsQuickFix
    extends PsiUpdateModCommandAction<HCLBlock> {
        public RemoveExtraNameElementsQuickFix(@NotNull HCLBlock element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            super((PsiElement)element);
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("block.name.validness.inspection.remove.name.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void invoke(@NotNull ActionContext context, @NotNull HCLBlock block, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            HCLObject hCLObject = block.getObject();
            if (hCLObject == null) {
                return;
            }
            HCLObject obj = hCLObject;
            if (!TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)block.getContainingFile())) {
                return;
            }
            BlockType blockType = TfModelHelper.INSTANCE.getAbstractBlockType(block);
            if (blockType == null) {
                return;
            }
            BlockType type = blockType;
            int extra = block.getNameElements().length - (type.getArgs() + 1);
            if (extra <= 0) {
                return;
            }
            HCLElement[] hCLElementArray = block.getNameElements();
            Intrinsics.checkNotNullExpressionValue((Object)hCLElementArray, (String)"getNameElements(...)");
            List toRemove = CollectionsKt.takeLast((List)ArraysKt.toList((Object[])hCLElementArray), (int)extra);
            PsiElement psiElement = obj.getPrevSibling();
            Intrinsics.checkNotNull((Object)psiElement);
            PsiElement end = psiElement;
            if (end.textContains('\n')) {
                Object object = CollectionsKt.last((List)toRemove);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"last(...)");
                end = (PsiElement)object;
            }
            block.deleteChildRange((PsiElement)CollectionsKt.first((List)toRemove), end);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/inspection/TfBlockNameValidnessInspection$RenameBlockFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "<init>", "()V", "getFamilyName", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "Lcom/intellij/psi/PsiElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "intellij.terraform"})
    private static final class RenameBlockFix
    extends PsiUpdateModCommandQuickFix {
        @NotNull
        public static final RenameBlockFix INSTANCE = new RenameBlockFix();

        private RenameBlockFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = HCLBundle.message("block.name.validness.inspection.rename.block.quick.fix.name", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
            HCLStringLiteral hCLStringLiteral = element instanceof HCLStringLiteral ? (HCLStringLiteral)element : null;
            PsiElement psiElement = hCLStringLiteral != null ? hCLStringLiteral.getParent() : null;
            HCLBlock hCLBlock = psiElement instanceof HCLBlock ? (HCLBlock)psiElement : null;
            if (hCLBlock == null) {
                return;
            }
            HCLBlock block = hCLBlock;
            String string = UniqueNameGenerator.generateUniqueName((String)"new_name", arg_0 -> RenameBlockFix.applyFix$lambda$1(RenameBlockFix::applyFix$lambda$0, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
            String newName = string;
            updater.rename((PsiNameIdentifierOwner)block, CollectionsKt.listOf((Object)newName));
        }

        private static final boolean applyFix$lambda$0(String name) {
            Intrinsics.checkNotNull((Object)name);
            return TfElementRenameValidator.Companion.isInputValid$intellij_terraform(name);
        }

        private static final boolean applyFix$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }
}

