/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.UtilKt;
import org.intellij.terraform.config.patterns.TfPsiPatterns;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLElement;
import org.intellij.terraform.hcl.psi.HCLElementVisitor;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLHeredocContent;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.intellij.terraform.hcl.psi.HCLStringLiteral;
import org.intellij.terraform.hcl.psi.common.MethodCallExpression;
import org.intellij.terraform.hil.ILLanguageInjector;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/intellij/terraform/config/inspection/TfNoInterpolationsAllowedInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "isAvailableForFile", "", "file", "Lcom/intellij/psi/PsiFile;", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "MyEV", "intellij.terraform"})
public final class TfNoInterpolationsAllowedInspection
extends LocalInspectionTool {
    public boolean isAvailableForFile(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UtilKt.isTerraformFile(file) && TfPsiPatterns.INSTANCE.getTerraformConfigFile().accepts((Object)file);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return new MyEV(holder);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0010H\u0002J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001b\u001a\u00020\u001c2\u0016\u0010\u001d\u001a\u0012\u0012\u0004\u0012\u00020\u001f0\u001ej\b\u0012\u0004\u0012\u00020\u001f` H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/intellij/terraform/config/inspection/TfNoInterpolationsAllowedInspection$MyEV;", "Lorg/intellij/terraform/hcl/psi/HCLElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "<init>", "(Lorg/intellij/terraform/config/inspection/TfNoInterpolationsAllowedInspection;Lcom/intellij/codeInspection/ProblemsHolder;)V", "getHolder", "()Lcom/intellij/codeInspection/ProblemsHolder;", "visitBlock", "", "block", "Lorg/intellij/terraform/hcl/psi/HCLBlock;", "visitStringLiteral", "o", "Lorg/intellij/terraform/hcl/psi/HCLStringLiteral;", "visitHeredocContent", "Lorg/intellij/terraform/hcl/psi/HCLHeredocContent;", "visitProperty", "Lorg/intellij/terraform/hcl/psi/HCLProperty;", "checkModule", "checkTerraform", "checkForVariableInterpolations", "checkDependsOn", "reportRanges", "e", "where", "", "getInjectedLanguagePlacesCollector", "Lcom/intellij/psi/InjectedLanguagePlaces;", "ranges", "Ljava/util/ArrayList;", "Lcom/intellij/openapi/util/TextRange;", "Lkotlin/collections/ArrayList;", "intellij.terraform"})
    @SourceDebugExtension(value={"SMAP\nTfNoInterpolationsAllowedInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TfNoInterpolationsAllowedInspection.kt\norg/intellij/terraform/config/inspection/TfNoInterpolationsAllowedInspection$MyEV\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n808#2,11:125\n1869#2,2:136\n*S KotlinDebug\n*F\n+ 1 TfNoInterpolationsAllowedInspection.kt\norg/intellij/terraform/config/inspection/TfNoInterpolationsAllowedInspection$MyEV\n*L\n75#1:121\n75#1:122,3\n76#1:125,11\n77#1:136,2\n*E\n"})
    public final class MyEV
    extends HCLElementVisitor {
        @NotNull
        private final ProblemsHolder holder;

        public MyEV(ProblemsHolder holder) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            this.holder = holder;
        }

        @NotNull
        public final ProblemsHolder getHolder() {
            return this.holder;
        }

        @Override
        public void visitBlock(@NotNull HCLBlock block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            if (TfPsiPatterns.INSTANCE.getModuleRootBlock().accepts((Object)block)) {
                this.checkModule(block);
            } else if (TfPsiPatterns.INSTANCE.getTerraformRootBlock().accepts((Object)block)) {
                this.checkTerraform(block);
            }
        }

        @Override
        public void visitStringLiteral(@NotNull HCLStringLiteral o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (TfPsiPatterns.INSTANCE.getStringLiteralAnywhereInVariable().accepts((Object)o)) {
                this.checkForVariableInterpolations(o);
            }
        }

        @Override
        public void visitHeredocContent(@NotNull HCLHeredocContent o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (TfPsiPatterns.INSTANCE.getHeredocContentAnywhereInVariable().accepts((Object)o)) {
                this.checkForVariableInterpolations(o);
            }
        }

        @Override
        public void visitProperty(@NotNull HCLProperty o) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            if (TfPsiPatterns.INSTANCE.getDependsOnPattern().accepts((Object)o)) {
                this.checkDependsOn(o);
            }
        }

        private final void checkModule(HCLBlock block) {
            HCLExpression source;
            HCLElement hCLElement = block.getObject();
            HCLExpression hCLExpression = hCLElement != null && (hCLElement = hCLElement.findProperty("source")) != null ? hCLElement.getValue() : (source = null);
            if (source != null) {
                if (source instanceof HCLStringLiteral) {
                    this.reportRanges((HCLStringLiteral)source, "module source");
                } else {
                    this.holder.registerProblem((PsiElement)source, HCLBundle.message("illegal.interpolations.inspection.no.double.quotes.error.message", new Object[0]), new LocalQuickFix[0]);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkTerraform(HCLBlock block) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Object object = block.getObject();
            if (object == null || (object = object.getPropertyList()) == null) {
                return;
            }
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                HCLProperty hCLProperty = (HCLProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getValue());
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof HCLStringLiteral)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                HCLStringLiteral it = (HCLStringLiteral)element$iv;
                boolean bl = false;
                this.reportRanges(it, "properties inside 'terraform' block");
            }
        }

        private final void checkForVariableInterpolations(HCLStringLiteral o) {
            this.reportRanges(o, "variables");
        }

        private final void checkForVariableInterpolations(HCLHeredocContent o) {
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            ILLanguageInjector.Companion.getHCLHeredocContentInjections$default(ILLanguageInjector.Companion, o, this.getInjectedLanguagePlacesCollector(ranges), null, 4, null);
            Iterator<TextRange> iterator = ranges.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TextRange> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TextRange range;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                this.holder.registerProblem((PsiElement)o, HCLBundle.message("illegal.interpolations.inspection.in.variable.error.message", new Object[0]), ProblemHighlightType.ERROR, range, new LocalQuickFix[0]);
            }
        }

        private final void checkDependsOn(HCLProperty o) {
            HCLExpression hCLExpression = o.getValue();
            HCLArray hCLArray = hCLExpression instanceof HCLArray ? (HCLArray)hCLExpression : null;
            if (hCLArray == null) {
                return;
            }
            HCLArray value = hCLArray;
            List<HCLExpression> list = value.getElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
            List<HCLExpression> list2 = list;
            for (HCLExpression e : list2) {
                if (e instanceof HCLStringLiteral) {
                    this.reportRanges((HCLStringLiteral)e, "depends_on");
                    continue;
                }
                if (!(e instanceof MethodCallExpression)) continue;
                this.holder.registerProblem((PsiElement)e, HCLBundle.message("illegal.interpolations.inspection.no.function.calls.error.message", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
            }
        }

        private final void reportRanges(HCLStringLiteral e, String where) {
            ArrayList<TextRange> ranges = new ArrayList<TextRange>();
            ILLanguageInjector.Companion.getStringLiteralInjections$default(ILLanguageInjector.Companion, e, this.getInjectedLanguagePlacesCollector(ranges), null, 4, null);
            Iterator<TextRange> iterator = ranges.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<TextRange> iterator2 = iterator;
            while (iterator2.hasNext()) {
                TextRange range;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                Object[] objectArray = new Object[]{where};
                this.holder.registerProblem((PsiElement)e, HCLBundle.message("illegal.interpolations.inspection.depends.on.error.message", objectArray), ProblemHighlightType.ERROR, range, new LocalQuickFix[0]);
            }
        }

        private final InjectedLanguagePlaces getInjectedLanguagePlacesCollector(ArrayList<TextRange> ranges) {
            return (arg_0, arg_1, arg_2, arg_3) -> MyEV.getInjectedLanguagePlacesCollector$lambda$0(ranges, arg_0, arg_1, arg_2, arg_3);
        }

        private static final void getInjectedLanguagePlacesCollector$lambda$0(ArrayList $ranges, Language language, TextRange rangeInsideHost, String string, String string2) {
            Intrinsics.checkNotNullParameter((Object)language, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)rangeInsideHost, (String)"rangeInsideHost");
            $ranges.add(rangeInsideHost);
        }
    }
}

