/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.inspection;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.terraform.config.model.HclType;
import org.intellij.terraform.config.model.HclTypeImpl;
import org.intellij.terraform.config.model.HclTypeModelKt;
import org.intellij.terraform.config.model.ListType;
import org.intellij.terraform.config.model.MapType;
import org.intellij.terraform.config.model.OptionalType;
import org.intellij.terraform.config.model.SetType;
import org.intellij.terraform.config.model.TupleType;
import org.intellij.terraform.config.model.Types;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.psi.HCLArray;
import org.intellij.terraform.hcl.psi.HCLBlock;
import org.intellij.terraform.hcl.psi.HCLExpression;
import org.intellij.terraform.hcl.psi.HCLIdentifier;
import org.intellij.terraform.hcl.psi.HCLMethodCallExpression;
import org.intellij.terraform.hcl.psi.HCLObject;
import org.intellij.terraform.hcl.psi.HCLParameterList;
import org.intellij.terraform.hcl.psi.HCLProperty;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020\u0018H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/intellij/terraform/config/inspection/TypeSpecificationValidator;", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "constraint", "", "supportArglessTypes", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;ZZ)V", "error", "Lorg/intellij/terraform/config/model/HclType;", "element", "Lcom/intellij/psi/PsiElement;", "description", "", "range", "Lcom/intellij/openapi/util/TextRange;", "getType", "e", "Lorg/intellij/terraform/hcl/psi/HCLExpression;", "checkIdentifier", "o", "Lorg/intellij/terraform/hcl/psi/HCLIdentifier;", "checkMethodCallExpression", "Lorg/intellij/terraform/hcl/psi/HCLMethodCallExpression;", "intellij.terraform"})
@SourceDebugExtension(value={"SMAP\nTypeSpecificationValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeSpecificationValidator.kt\norg/intellij/terraform/config/inspection/TypeSpecificationValidator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1869#2,2:140\n1563#2:142\n1634#2,2:143\n1636#2:146\n1563#2:147\n1634#2,3:148\n1#3:145\n*S KotlinDebug\n*F\n+ 1 TypeSpecificationValidator.kt\norg/intellij/terraform/config/inspection/TypeSpecificationValidator\n*L\n117#1:140,2\n120#1:142\n120#1:143,2\n120#1:146\n133#1:147\n133#1:148,3\n*E\n"})
public class TypeSpecificationValidator {
    @Nullable
    private final ProblemsHolder holder;
    private final boolean constraint;
    private final boolean supportArglessTypes;

    public TypeSpecificationValidator(@Nullable ProblemsHolder holder, boolean constraint, boolean supportArglessTypes) {
        this.holder = holder;
        this.constraint = constraint;
        this.supportArglessTypes = supportArglessTypes;
    }

    public /* synthetic */ TypeSpecificationValidator(ProblemsHolder problemsHolder, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(problemsHolder, bl, bl2);
    }

    @Nullable
    protected HclType error(@NotNull PsiElement element, @Nls @NotNull String description, @Nullable TextRange range) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            ProblemsHolder problemsHolder = this.holder;
            if (problemsHolder == null) break block0;
            problemsHolder.registerProblem(element, range, description, new LocalQuickFix[0]);
        }
        return null;
    }

    public static /* synthetic */ HclType error$default(TypeSpecificationValidator typeSpecificationValidator, PsiElement psiElement, String string, TextRange textRange, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: error");
        }
        if ((n & 4) != 0) {
            textRange = null;
        }
        return typeSpecificationValidator.error(psiElement, string, textRange);
    }

    @Nullable
    public final HclType getType(@NotNull HCLExpression e) {
        HclType hclType;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        HCLExpression hCLExpression = e;
        if (hCLExpression instanceof HCLIdentifier) {
            hclType = this.checkIdentifier((HCLIdentifier)e);
        } else if (hCLExpression instanceof HCLMethodCallExpression) {
            hclType = this.checkMethodCallExpression((HCLMethodCallExpression)e);
        } else {
            PsiElement psiElement = e;
            String string = HCLBundle.message("type.specification.validator.illegal.type.specification.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            hclType = TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
        }
        return hclType;
    }

    private final HclType checkIdentifier(HCLIdentifier o) {
        String string = o.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return switch (string) {
            case "bool" -> Types.INSTANCE.getBoolean();
            case "string" -> Types.INSTANCE.getString();
            case "number" -> Types.INSTANCE.getNumber();
            case "any" -> {
                String kw;
                if (this.constraint) {
                    yield Types.INSTANCE.getAny();
                }
                PsiElement v2 = o;
                Object[] var4_3 = new Object[]{kw};
                String v3 = HCLBundle.message("type.specification.validator.exact.type.required.error.message", var4_3);
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"message(...)");
                yield TypeSpecificationValidator.error$default(this, v2, v3, null, 4, null);
            }
            case "set", "list", "map" -> {
                String kw;
                if (!this.supportArglessTypes) {
                    PsiElement v4 = o;
                    Object[] var4_4 = new Object[]{kw};
                    String v5 = HCLBundle.message("type.specification.validator.collection.argument.required.error.message", var4_4);
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"message(...)");
                    yield TypeSpecificationValidator.error$default(this, v4, v5, null, 4, null);
                }
                HclTypeImpl v6 = switch (kw) {
                    case "list" -> new ListType(null);
                    case "set" -> new SetType(null);
                    case "map" -> new MapType(null);
                    default -> Types.INSTANCE.getAny();
                };
                yield v6;
            }
            case "object" -> {
                if (!this.supportArglessTypes) {
                    PsiElement v7 = o;
                    String v8 = HCLBundle.message("type.specification.validator.object.argument.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"message(...)");
                    yield TypeSpecificationValidator.error$default(this, v7, v8, null, 4, null);
                }
                yield HclTypeModelKt.ObjectType$default(null, null, 2, null);
            }
            case "tuple" -> {
                if (!this.supportArglessTypes) {
                    PsiElement v9 = o;
                    String v10 = HCLBundle.message("type.specification.validator.tuple.argument.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"message(...)");
                    yield TypeSpecificationValidator.error$default(this, v9, v10, null, 4, null);
                }
                yield new TupleType(CollectionsKt.emptyList());
            }
            default -> {
                String kw;
                PsiElement v11 = o;
                Object[] var4_5 = new Object[]{kw};
                String v12 = HCLBundle.message("type.specification.validator.invalid.type.specification.error.message", var4_5);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"message(...)");
                yield TypeSpecificationValidator.error$default(this, v11, v12, null, 4, null);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final HclType checkMethodCallExpression(HCLMethodCallExpression e) {
        int paramsSize;
        List<HCLExpression> params;
        String methodName;
        block84: {
            HCLIdentifier hCLIdentifier = e.getCallee();
            Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier, (String)"<get-callee>(...)");
            HCLIdentifier method = hCLIdentifier;
            String string = method.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            switch (methodName = string) {
                case "number": 
                case "bool": 
                case "string": 
                case "any": {
                    HCLIdentifier hCLIdentifier2 = e.getCallee();
                    Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier2, (String)"<get-callee>(...)");
                    PsiElement psiElement = hCLIdentifier2;
                    Object[] objectArray = new Object[]{methodName};
                    String string2 = HCLBundle.message("type.specification.validator.no.argument.expected.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    return TypeSpecificationValidator.error$default(this, psiElement, string2, null, 4, null);
                }
                default: {
                    HCLIdentifier hCLIdentifier3 = e.getCallee();
                    Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier3, (String)"<get-callee>(...)");
                    PsiElement psiElement = hCLIdentifier3;
                    Object[] objectArray = new Object[]{e.getCallee().getText()};
                    String string3 = HCLBundle.message("type.specification.validator.invalid.type.specification.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    TypeSpecificationValidator.error$default(this, psiElement, string3, null, 4, null);
                }
                case "tuple": 
                case "set": 
                case "optional": 
                case "list": 
                case "map": 
                case "object": 
            }
            List<HCLExpression> list = e.getParameterList().getElements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
            params = list;
            paramsSize = params.size();
            if (paramsSize == 1) break block84;
            TextRange range = paramsSize > 1 ? new TextRange(params.get(1).getTextRangeInParent().getStartOffset(), ((HCLExpression)CollectionsKt.last(params)).getTextRangeInParent().getEndOffset()) : null;
            switch (methodName) {
                case "set": 
                case "list": 
                case "map": {
                    HCLParameterList hCLParameterList = e.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)hCLParameterList, (String)"<get-parameterList>(...)");
                    PsiElement psiElement = hCLParameterList;
                    Object[] objectArray = new Object[]{methodName};
                    String string4 = HCLBundle.message("type.specification.validator.collection.argument.required.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
                    return this.error(psiElement, string4, range);
                }
                case "object": {
                    HCLParameterList hCLParameterList = e.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)hCLParameterList, (String)"<get-parameterList>(...)");
                    PsiElement psiElement = hCLParameterList;
                    String string5 = HCLBundle.message("type.specification.validator.object.argument.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
                    return this.error(psiElement, string5, range);
                }
                case "tuple": {
                    HCLParameterList hCLParameterList = e.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)hCLParameterList, (String)"<get-parameterList>(...)");
                    PsiElement psiElement = hCLParameterList;
                    String string6 = HCLBundle.message("type.specification.validator.tuple.argument.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
                    return this.error(psiElement, string6, range);
                }
            }
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"optional") && paramsSize != 1 && paramsSize != 2) {
            HCLParameterList hCLParameterList = e.getParameterList();
            Intrinsics.checkNotNullExpressionValue((Object)hCLParameterList, (String)"<get-parameterList>(...)");
            PsiElement psiElement = hCLParameterList;
            String string = HCLBundle.message("type.specification.validator.optional.argument.required.error.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
        }
        HCLExpression firstArgument = (HCLExpression)CollectionsKt.first(params);
        switch (methodName) {
            case "number": 
            case "bool": 
            case "string": 
            case "any": {
                HCLIdentifier hCLIdentifier = e.getCallee();
                Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier, (String)"<get-callee>(...)");
                PsiElement psiElement = hCLIdentifier;
                Object[] objectArray = new Object[]{methodName};
                String string = HCLBundle.message("type.specification.validator.no.argument.expected.error.message", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
            }
            case "list": {
                Intrinsics.checkNotNull((Object)firstArgument);
                return new ListType(this.getType(firstArgument));
            }
            case "set": {
                Intrinsics.checkNotNull((Object)firstArgument);
                return new SetType(this.getType(firstArgument));
            }
            case "map": {
                Intrinsics.checkNotNull((Object)firstArgument);
                return new MapType(this.getType(firstArgument));
            }
            case "optional": {
                Intrinsics.checkNotNull((Object)firstArgument);
                return new OptionalType(this.getType(firstArgument));
            }
            case "object": {
                void $this$mapTo$iv$iv;
                Object element$iv2;
                if (!(firstArgument instanceof HCLObject)) {
                    Intrinsics.checkNotNull((Object)firstArgument);
                    PsiElement psiElement = firstArgument;
                    String string = HCLBundle.message("type.specification.validator.object.argument.map.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
                }
                List<HCLBlock> list = ((HCLObject)firstArgument).getBlockList();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getBlockList(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    HCLBlock it = (HCLBlock)element$iv2;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    PsiElement psiElement = it;
                    String string = HCLBundle.message("type.specification.validator.block.not.allowed.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
                }
                List<HCLProperty> list2 = ((HCLObject)firstArgument).getPropertyList();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getPropertyList(...)");
                Iterable $this$map$iv = list2;
                boolean $i$f$map2 = false;
                element$iv2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    HclType hclType;
                    void it;
                    HCLProperty hCLProperty = (HCLProperty)item$iv$iv2;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    if (!(it.getNameElement() instanceof HCLIdentifier)) {
                        HCLExpression hCLExpression = it.getNameElement();
                        Intrinsics.checkNotNullExpressionValue((Object)hCLExpression, (String)"getNameElement(...)");
                        PsiElement psiElement = hCLExpression;
                        String string = HCLBundle.message("type.specification.validator.object.constructor.map.keys.must.be.attribute.names.error.message", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
                    }
                    String string = it.getName();
                    if (it.getValue() != null) {
                        void expr;
                        String string7 = string;
                        boolean bl2 = false;
                        hclType = this.getType((HCLExpression)expr);
                        string = string7;
                    } else {
                        hclType = null;
                    }
                    collection.add(TuplesKt.to((Object)string, hclType));
                }
                Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
                return HclTypeModelKt.ObjectType$default(map, null, 2, null);
            }
            case "tuple": {
                void $this$mapTo$iv$iv;
                if (!(firstArgument instanceof HCLArray)) {
                    Intrinsics.checkNotNull((Object)firstArgument);
                    PsiElement psiElement = firstArgument;
                    String string = HCLBundle.message("type.specification.validator.tuple.argument.required.error.message", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
                }
                List<HCLExpression> list = ((HCLArray)firstArgument).getElements();
                Intrinsics.checkNotNullExpressionValue(list, (String)"<get-elements>(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable $i$f$map2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    HCLExpression item$iv$iv2 = (HCLExpression)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(this.getType((HCLExpression)it));
                }
                List list3 = (List)destination$iv$iv;
                return new TupleType(list3);
            }
        }
        HCLIdentifier hCLIdentifier = e.getCallee();
        Intrinsics.checkNotNullExpressionValue((Object)hCLIdentifier, (String)"<get-callee>(...)");
        PsiElement psiElement = hCLIdentifier;
        Object[] objectArray = new Object[]{methodName};
        String string = HCLBundle.message("type.specification.validator.invalid.type.constructor.error.message", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        TypeSpecificationValidator.error$default(this, psiElement, string, null, 4, null);
        return null;
    }
}

