/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.terraform.config.model;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageMatcher;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.terraform.hcl.HCLBundle;
import org.intellij.terraform.hcl.HCLLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\n\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\"\u0014\u0010\u0004\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0006\"\u0014\u0010\u0007\u001a\u00020\u00058@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0006\u00a8\u0006\n"}, d2={"restrictToTerraformFiles", "Lcom/intellij/psi/search/GlobalSearchScope;", "project", "Lcom/intellij/openapi/project/Project;", "isDeepVariableSearchEnabled", "", "()Z", "isFallbackVariableSearchEnabled", "createDisableDeepVariableSearchQuickFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "intellij.terraform"})
public final class ModuleKt {
    @NotNull
    public static final GlobalSearchScope restrictToTerraformFiles(@NotNull GlobalSearchScope $this$restrictToTerraformFiles, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)$this$restrictToTerraformFiles, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        SearchScope searchScope = PsiSearchScopeUtil.restrictScopeToFileLanguage((Project)project, (SearchScope)((SearchScope)$this$restrictToTerraformFiles), (LanguageMatcher)LanguageMatcher.matchWithDialects((Language)HCLLanguage.INSTANCE));
        Intrinsics.checkNotNull((Object)searchScope, (String)"null cannot be cast to non-null type com.intellij.psi.search.GlobalSearchScope");
        return (GlobalSearchScope)searchScope;
    }

    public static final boolean isDeepVariableSearchEnabled() {
        return AdvancedSettings.Companion.getBoolean("org.intellij.terraform.config.variables.deep.search");
    }

    public static final boolean isFallbackVariableSearchEnabled() {
        return AdvancedSettings.Companion.getBoolean("org.intellij.terraform.variables.search.fallback");
    }

    @Nullable
    public static final LocalQuickFix createDisableDeepVariableSearchQuickFix() {
        if (!ModuleKt.isFallbackVariableSearchEnabled()) {
            return null;
        }
        if (!ModuleKt.isDeepVariableSearchEnabled()) {
            return null;
        }
        return new LocalQuickFix(){

            public boolean startInWriteAction() {
                return false;
            }

            public String getFamilyName() {
                String string = HCLBundle.message("disable.deep.variable.search", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }

            public void applyFix(Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                AdvancedSettings.Companion.setBoolean("org.intellij.terraform.config.variables.deep.search", false);
                DaemonCodeAnalyzer.getInstance((Project)project).restart((Object)"createDisableDeepVariableSearchQuickFix");
            }
        };
    }
}

